/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.notify;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.mihalis.opal.notify.NotifierColors;

public class NotifierColorsFactory {
    private NotifierColorsFactory() {
    }

    static NotifierColors getColorsForTheme(NotifierTheme theme) {
        NotifierColors colors = new NotifierColors();
        switch (theme) {
            case BLUE_THEME: {
                colors.textColor = new Color((Device)Display.getDefault(), 4, 64, 140);
                colors.titleColor = Display.getDefault().getSystemColor(2);
                colors.borderColor = new Color((Device)Display.getDefault(), 153, 188, 232);
                colors.leftColor = new Color((Device)Display.getDefault(), 210, 225, 244);
                colors.rightColor = new Color((Device)Display.getDefault(), 182, 207, 238);
                break;
            }
            case GRAY_THEME: {
                colors.textColor = Display.getDefault().getSystemColor(2);
                colors.titleColor = Display.getDefault().getSystemColor(4);
                colors.borderColor = new Color((Device)Display.getDefault(), 208, 208, 208);
                colors.leftColor = new Color((Device)Display.getDefault(), 255, 255, 255);
                colors.rightColor = new Color((Device)Display.getDefault(), 208, 208, 208);
                break;
            }
            default: {
                colors.textColor = Display.getDefault().getSystemColor(2);
                colors.titleColor = Display.getDefault().getSystemColor(2);
                colors.borderColor = new Color((Device)Display.getDefault(), 218, 178, 85);
                colors.leftColor = new Color((Device)Display.getDefault(), 220, 220, 160);
                colors.rightColor = new Color((Device)Display.getDefault(), 255, 255, 191);
            }
        }
        return colors;
    }

    public static enum NotifierTheme {
        YELLOW_THEME,
        GRAY_THEME,
        BLUE_THEME;

    }
}

