/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.navigator.ResourceSorter;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.StringMatcher;
import zipeditor.actions.ViewerAction;

public abstract class DialogAction
extends ViewerAction {
    private boolean fUseFilter;

    protected DialogAction(String text, StructuredViewer viewer, boolean useFilter) {
        super(text, viewer);
        this.fUseFilter = useFilter;
    }

    protected String[] openDialog(String text, String path, boolean multiSelection, boolean showFiles) {
        FileDialog dialog = new FileDialog(text);
        dialog.setMultiSelection(multiSelection);
        dialog.setShowFiles(showFiles);
        dialog.setSelection(path);
        dialog.open();
        return dialog.getFileNames();
    }

    private class FileDialog
    extends Dialog
    implements ISelectionChangedListener {
        private TreeViewer fWorkspaceViewer;
        private TreeViewer fFileSystemViewer;
        private Label fStatusLabel;
        private List fWorkspaceSelection;
        private List fFileSystemSelection;
        private String fText;
        private boolean fMultiSelection;
        private boolean fShowFiles;
        private String fInitialSelection;

        private FileDialog(String text) {
            super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            this.setShellStyle(this.getShellStyle() | 0x4F0);
            this.fText = text;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.fText);
        }

        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            this.fWorkspaceViewer = this.createWorkspaceArea(control);
            this.fFileSystemViewer = this.createFileSystemArea(control);
            this.fWorkspaceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.fFileSystemViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            ISelectionChangedListener listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (FileDialog.this.fMultiSelection) {
                        return;
                    }
                    FileDialog.this.fWorkspaceViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                    FileDialog.this.fFileSystemViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                    (event.getSource() == FileDialog.this.fFileSystemViewer ? FileDialog.this.fWorkspaceViewer : FileDialog.this.fFileSystemViewer).setSelection((ISelection)StructuredSelection.EMPTY);
                    FileDialog.this.fWorkspaceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    FileDialog.this.fFileSystemViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            };
            this.fWorkspaceViewer.addSelectionChangedListener(listener);
            this.fFileSystemViewer.addSelectionChangedListener(listener);
            GridData data = (GridData)control.getLayoutData();
            data.widthHint = this.convertWidthInCharsToPixels(80);
            this.fStatusLabel = new Label(control, 16448);
            this.fStatusLabel.setLayoutData((Object)new GridData(768));
            FileDialog.applyDialogFont((Control)control);
            this.setInitialSelection();
            return control;
        }

        private void setInitialSelection() {
            if (this.fInitialSelection == null) {
                return;
            }
            this.fFileSystemViewer.setSelection((ISelection)new StructuredSelection((Object)new File(this.fInitialSelection)), true);
            try {
                this.fWorkspaceViewer.setSelection((ISelection)new StructuredSelection((Object)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.fInitialSelection))), true);
            }
            catch (Exception exception) {}
        }

        private TreeViewer createWorkspaceArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setLayoutData((Object)new GridData(1808));
            FilterArea filterArea = null;
            if (DialogAction.this.fUseFilter) {
                filterArea = new FilterArea(composite, ActionMessages.getString("DialogAction.0"));
            }
            TreeViewer viewer = new TreeViewer(composite, 0x800 | (this.fMultiSelection ? 2 : 4));
            if (filterArea != null) {
                filterArea.setViewer(viewer);
            }
            viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            viewer.setSorter((ViewerSorter)new ResourceSorter(1));
            if (!this.fShowFiles) {
                viewer.addFilter((ViewerFilter)new FileFilter());
            }
            viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(10);
            viewer.getControl().setLayoutData((Object)data);
            return viewer;
        }

        private TreeViewer createFileSystemArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setLayoutData((Object)new GridData(1808));
            FilterArea filterArea = null;
            if (DialogAction.this.fUseFilter) {
                filterArea = new FilterArea(composite, ActionMessages.getString("DialogAction.1"));
            }
            TreeViewer viewer = new TreeViewer(composite, 0x800 | (this.fMultiSelection ? 2 : 4));
            if (filterArea != null) {
                filterArea.setViewer(viewer);
            }
            viewer.setContentProvider((IContentProvider)new FileSystemContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new FileSystemLabelProvider());
            viewer.setSorter((ViewerSorter)new FileSorter());
            if (!this.fShowFiles) {
                viewer.addFilter((ViewerFilter)new FileFilter());
            }
            viewer.setInput((Object)File.listRoots());
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(10);
            viewer.getControl().setLayoutData((Object)data);
            return viewer;
        }

        protected void okPressed() {
            this.fWorkspaceSelection = this.toList((IStructuredSelection)this.fWorkspaceViewer.getSelection());
            this.fFileSystemSelection = this.toList((IStructuredSelection)this.fFileSystemViewer.getSelection());
            super.okPressed();
        }

        public String[] getFileNames() {
            ArrayList allNames = new ArrayList();
            if (this.fWorkspaceSelection != null) {
                allNames.addAll(this.fWorkspaceSelection);
            }
            if (this.fFileSystemSelection != null) {
                allNames.addAll(this.fFileSystemSelection);
            }
            return allNames.toArray(new String[allNames.size()]);
        }

        private List toList(IStructuredSelection selection) {
            List list = selection.toList();
            int i = 0;
            while (i < list.size()) {
                Object element = list.get(i);
                if (element instanceof IResource) {
                    list.set(i, ((IResource)element).getLocation().toFile().getAbsolutePath());
                } else if (element instanceof File) {
                    list.set(i, ((File)element).getAbsolutePath());
                }
                ++i;
            }
            return list;
        }

        public void setMultiSelection(boolean multiSelection) {
            this.fMultiSelection = multiSelection;
        }

        public void setShowFiles(boolean showFiles) {
            this.fShowFiles = showFiles;
        }

        public void setSelection(String path) {
            this.fInitialSelection = path;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateStatusText();
        }

        private void updateStatusText() {
            int wsSize = ((IStructuredSelection)this.fWorkspaceViewer.getSelection()).size();
            int fsSize = ((IStructuredSelection)this.fFileSystemViewer.getSelection()).size();
            this.fStatusLabel.setText(ActionMessages.getFormattedString("DialogAction.2", new Object[]{new Integer(wsSize), new Integer(fsSize)}));
        }

        private class FilterArea
        extends Composite
        implements FocusListener,
        ModifyListener {
            private TreeViewer fViewer;
            private Color fGrayColor;
            private final String fEmptyText;
            private final Text fText;
            private StringMatcher[] fMatchers;
            private final RefreshJob fRefreshJob;

            public FilterArea(Composite parent, String labelText) {
                super(parent, 0);
                this.fEmptyText = ActionMessages.getString("DialogAction.3");
                this.fRefreshJob = new RefreshJob(this.getDisplay());
                this.setLayout((Layout)new GridLayout(2, false));
                this.setLayoutData(new GridData(768));
                Label label = new Label((Composite)this, 16384);
                label.setText(labelText);
                this.fText = new Text((Composite)this, 18432);
                this.fText.setLayoutData((Object)new GridData(768));
                this.fText.setText(this.fEmptyText);
                this.fText.setForeground(this.getGrayColor());
                this.fText.addFocusListener((FocusListener)this);
                this.fText.addModifyListener((ModifyListener)this);
            }

            private void setPattern(String patternString) {
                if (patternString == null || patternString.trim().length() == 0 || this.fEmptyText.equals(patternString)) {
                    this.fMatchers = null;
                } else {
                    String[] strings = patternString.split(",");
                    this.fMatchers = new StringMatcher[strings.length];
                    int i = 0;
                    while (i < strings.length) {
                        this.fMatchers[i] = new StringMatcher(strings[i].trim(), true, false);
                        ++i;
                    }
                }
            }

            private Color getGrayColor() {
                if (this.fGrayColor == null) {
                    this.fGrayColor = new Color((Device)this.getDisplay(), 160, 160, 160);
                }
                return this.fGrayColor;
            }

            public void dispose() {
                this.fGrayColor.dispose();
                super.dispose();
            }

            public void focusLost(FocusEvent e) {
                if (this.fText.getText().length() == 0 || this.fEmptyText.equals(this.fText.getText())) {
                    this.fText.setForeground(this.getGrayColor());
                    this.fText.setText(this.fEmptyText);
                }
                this.modifyText(null);
            }

            public void focusGained(FocusEvent e) {
                if (this.fEmptyText.equals(this.fText.getText())) {
                    this.fText.setForeground(this.getForeground());
                    this.fText.setText("");
                }
            }

            public void modifyText(ModifyEvent e) {
                this.fRefreshJob.cancel();
                this.fRefreshJob.schedule(500L);
            }

            private void selectMatches() {
                if (this.fMatchers != null) {
                    Tree tree = this.fViewer.getTree();
                    ArrayList selection = new ArrayList();
                    this.findElements(tree.getItems(), selection);
                    this.fViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                } else {
                    this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }

            private Object findElements(TreeItem[] items, List selection) {
                ILabelProvider labelProvider = (ILabelProvider)this.fViewer.getLabelProvider();
                int i = 0;
                while (i < items.length) {
                    Object element = items[i].getData();
                    if (!(element instanceof IContainer || element instanceof File && ((File)element).isDirectory())) {
                        int j = 0;
                        while (j < this.fMatchers.length) {
                            if (this.fMatchers[j].match(labelProvider.getText(element))) {
                                selection.add(element);
                            }
                            ++j;
                        }
                    }
                    this.findElements(items[i].getItems(), selection);
                    ++i;
                }
                return null;
            }

            protected void setViewer(TreeViewer viewer) {
                this.fViewer = viewer;
                this.fViewer.setUseHashlookup(true);
            }

            private class RefreshJob
            extends UIJob {
                public RefreshJob(Display display) {
                    super(display, "Refresh");
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!FilterArea.this.fText.isDisposed()) {
                        FilterArea.this.setPattern(FilterArea.this.fText.getText());
                        FilterArea.this.selectMatches();
                    }
                    return Status.OK_STATUS;
                }
            }
        }
    }

    private class FileFilter
    extends ViewerFilter {
        private FileFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof IFolder || element instanceof IProject || element instanceof File && ((File)element).isDirectory();
        }
    }

    private class FileSorter
    extends ViewerSorter {
        private FileSorter() {
        }

        public int category(Object element) {
            return ((File)element).isDirectory() ? -1 : 1;
        }
    }

    private class FileSystemContentProvider
    implements ITreeContentProvider {
        private FileSystemContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] files;
            File file;
            if (parentElement instanceof File[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof File && (file = (File)parentElement).isDirectory() && (files = file.listFiles()) != null) {
                return files;
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return element instanceof File ? ((File)element).getParentFile() : null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FileSystemLabelProvider
    extends LabelProvider {
        private FileSystemLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof File) {
                File file = (File)element;
                return file.getName().length() > 0 ? file.getName() : file.getPath();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof File) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName(), null);
                if (descriptor != null) {
                    return ZipEditorPlugin.getImage(descriptor);
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return super.getImage(element);
        }
    }
}

