/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import zipeditor.model.ZipModel;

public class ZipContentDescriber
implements IContentDescriber {
    private static final Set ALL_TYPES = new HashSet();
    public static final String ZIP_FILE = ZipContentDescriber.add("zipfile");
    public static final String GZ_FILE = ZipContentDescriber.add("gzipfile");
    public static final String TAR_FILE = ZipContentDescriber.add("tarfile");
    public static final String TGZ_FILE = ZipContentDescriber.add("targzfile");
    public static final String BZ2_FILE = ZipContentDescriber.add("bz2file");
    public static final String TBZ_FILE = ZipContentDescriber.add("tarbz2file");
    private static final String EMPTY = "empty";

    private static String add(String s) {
        String contentTypeId = "org.tizen.common.externals." + s;
        ALL_TYPES.add(contentTypeId);
        return contentTypeId;
    }

    public static boolean isForUs(String contentTypeId) {
        return ALL_TYPES.contains(contentTypeId);
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        String contentTypeId;
        String type = this.detectType(contents);
        if (type == null) {
            return 0;
        }
        if (description == null || type == EMPTY) {
            return 2;
        }
        String string = contentTypeId = description.getContentType() != null ? description.getContentType().getId() : null;
        if (type.equals(contentTypeId)) {
            return 2;
        }
        if (type == TGZ_FILE && GZ_FILE.equals(contentTypeId)) {
            return 2;
        }
        if (type == TBZ_FILE && BZ2_FILE.equals(contentTypeId)) {
            return 2;
        }
        return 0;
    }

    private String detectType(InputStream contents) {
        switch (ZipModel.detectType(contents)) {
            default: {
                return null;
            }
            case 1: {
                return ZIP_FILE;
            }
            case 2: {
                return TAR_FILE;
            }
            case 3: {
                return GZ_FILE;
            }
            case 4: {
                return TGZ_FILE;
            }
            case 5: {
                return BZ2_FILE;
            }
            case 6: {
                return TBZ_FILE;
            }
            case 99: 
        }
        return EMPTY;
    }

    public QualifiedName[] getSupportedOptions() {
        return IContentDescription.ALL;
    }
}

