/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.project.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.tproject.Platform;
import org.tizen.common.core.application.tproject.Platforms;
import org.tizen.common.core.application.tproject.Tproject;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.common.project.model.IProjectPlatformChange;
import org.tizen.common.util.StringUtil;

public abstract class AbstractProjectPlatformChange
implements IProjectPlatformChange {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TIZEN_PROJECT_DESCRIPTION_FILE = ".tproject";

    protected String getPlatformByTprojectInDirectory(String path) {
        if (StringUtil.isEmpty((CharSequence)path)) {
            return null;
        }
        File tprojectFile = new File(path, TIZEN_PROJECT_DESCRIPTION_FILE);
        if (!tprojectFile.exists()) {
            return null;
        }
        this.logger.debug("Found a '.tproject' file");
        Tproject tproject = TprojectHandler.unmarshalTproject((File)tprojectFile);
        if (tproject == null) {
            this.logger.debug("Failed to get tproject model");
            return null;
        }
        Platforms platforms = tproject.getPlatforms();
        if (platforms == null) {
            this.logger.debug("tproject model don't have platforms");
            return null;
        }
        List platform = platforms.getPlatform();
        if (platform == null || platform.isEmpty()) {
            this.logger.debug("tproject model have an enmpty platform in platforms");
            return null;
        }
        return ((Platform)platform.get(0)).getName();
    }

    @Override
    public List<String> getAvailableProfile(String profile) {
        ArrayList<String> result = new ArrayList<String>();
        for (ProfileInfo info : InstallPathConfig.flattenPlatformPathInfos()) {
            String profileName = info.getProfile();
            if (result.contains(profileName)) continue;
            result.add(profileName);
        }
        return result;
    }

    @Override
    public List<String> getAvailableVersion(String profile, String version) {
        ProfileInfo profileInfo = InstallPathConfig.getProfileInfo((String)profile);
        if (profileInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String ver : profileInfo.getVersions()) {
            result.add(ver);
        }
        Collections.sort(result);
        return result;
    }
}

