/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import org.tizen.sdb.Buffer;
import org.tizen.sdb.CommandResponse;

public class Channel {
    public static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static InetSocketAddress socketAddr;
    SocketChannel channel = null;
    private static final byte COMMAND = 1;
    private static final byte DATA = 2;
    private static final int TIM_HEADER_SIZE = 8;

    static {
        try {
            socketAddr = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 27099);
        }
        catch (SecurityException securityException) {
        }
        catch (UnknownHostException unknownHostException) {}
    }

    private void tryClose(Closeable obj) {
        if (obj == null) {
            return;
        }
        try {
            obj.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Unable to fully structure code
     */
    public void connect() throws IOException {
        if (!Channel.$assertionsDisabled && Channel.socketAddr == null) {
            throw new AssertionError();
        }
        try {
            this.channel = SocketChannel.open(Channel.socketAddr);
            this.channel.configureBlocking(false);
            if (true) ** GOTO lbl14
        }
        catch (Exception v0) {
            this.tryClose(this.channel);
            throw new IOException();
        }
        do {
            this.channel.finishConnect();
lbl14:
            // 2 sources

        } while (this.channel.isConnectionPending());
    }

    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isConnected();
    }

    public boolean tryConnection() {
        boolean isConnected = false;
        assert (socketAddr != null);
        try {
            SocketChannel channel = SocketChannel.open(socketAddr);
            isConnected = channel.isConnected();
            channel.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return isConnected;
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public void close() throws IOException {
        this.tryClose(this.channel);
    }

    public boolean writeCommand(String data) {
        return this.writeCommand(data, data.length());
    }

    public boolean writeCommand(String data, int length) {
        if (!this.writePacket((byte)1, length, data)) {
            return false;
        }
        return this.writeLastPacket((byte)1);
    }

    public boolean writeData(String buffer, int length) {
        return this.writePacket((byte)2, length, buffer);
    }

    public String readCommand() throws IOException {
        byte[] data = null;
        CommandResponse response = null;
        ByteBuffer buf = ByteBuffer.allocate(8);
        if (!this.readPacketHeader(buf, (byte)1)) {
            response = new CommandResponse(1, "Failure", "Communication error: failed to get packet header");
            return response.makeJson();
        }
        buf.clear();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int readLength = this.readFully(buf.array(), 4);
        if (readLength <= 0) {
            response = new CommandResponse(1, "Failure", "Communication error: failed to read data size");
            return response.makeJson();
        }
        int length = buf.getInt();
        if (length > 0 && (readLength = this.readFully(data = new byte[length], length)) <= 0) {
            response = new CommandResponse(1, "Failure", "Communication error: failed to read data");
            return response.makeJson();
        }
        buf.clear();
        if (!this.readPacketHeader(buf, (byte)1)) {
            response = new CommandResponse(1, "Failure", "Communication error: failed to read command header");
            return response.makeJson();
        }
        if (data == null) {
            response = new CommandResponse(1, "Failure", "Communication error: failed to read command data");
            return response.makeJson();
        }
        return new String(data, UTF_CHARSET);
    }

    public int readData(byte[] data) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        int length = 0;
        this.readPacketHeader(buf, (byte)2);
        buf.clear();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int readLength = this.readFully(buf.array(), 4);
        if (readLength <= 0) {
            return readLength;
        }
        length = buf.getInt();
        if (length > 0 && (readLength = this.readFully(data, length)) <= 0) {
            return readLength;
        }
        return length;
    }

    public Buffer read() throws IOException {
        Buffer.BufferType type;
        byte[] buffer = null;
        ByteBuffer buf = ByteBuffer.allocate(8);
        int readLength = this.readFully(buf.array(), buf.capacity());
        if (readLength <= 0) {
            return null;
        }
        if (buf.get() != 84 || buf.get() != 73 || buf.get() != 77) assert (false);
        byte t = buf.get();
        switch (t) {
            case 0: {
                type = Buffer.BufferType.RAW;
                break;
            }
            case 1: {
                type = Buffer.BufferType.COMMAND;
                break;
            }
            case 2: {
                type = Buffer.BufferType.DATA;
                break;
            }
            default: {
                type = Buffer.BufferType.UNIDENTIFIED;
            }
        }
        buf.clear();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        readLength = this.readFully(buf.array(), 4);
        if (readLength <= 0) {
            return null;
        }
        int length = buf.getInt();
        if (length > 0 && (readLength = this.readFully(buffer = new byte[length], length)) <= 0) {
            return null;
        }
        if (type == Buffer.BufferType.COMMAND) {
            buf.clear();
            if (!this.readPacketHeader(buf, (byte)1)) {
                return null;
            }
            readLength = this.readFully(buf.array(), 4);
        }
        return new Buffer(type, buffer, length);
    }

    public boolean endWriteData() {
        return this.writeLastPacket((byte)2);
    }

    private int writeFully(byte[] data, int length) {
        int writeLength = 0;
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length < 0 ? data.length : length);
        while (buf.hasRemaining()) {
            try {
                writeLength = this.channel.write(buf);
                if (writeLength >= 0) continue;
                throw new IOException("channel EOF");
            }
            catch (IOException iOException) {
                return 0;
            }
        }
        return writeLength;
    }

    private boolean writePacket(byte type, int length, String data) {
        TIMHeader header = new TIMHeader();
        header.type = type;
        int writeLength = this.writeFully(header.toBytes(), 8);
        if (writeLength == 0) {
            return false;
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(length);
        writeLength = this.writeFully(buf.array(), 4);
        if (writeLength == 0) {
            return false;
        }
        return length <= 0 || (writeLength = this.writeFully(data.getBytes(UTF_CHARSET), length)) != 0;
    }

    private boolean writeLastPacket(byte type) {
        return this.writePacket(type, 0, null);
    }

    private int readFully(byte[] buffer, int length) throws IOException {
        int readLength = 0;
        ByteBuffer buf = ByteBuffer.wrap(buffer, 0, length > buffer.length ? buffer.length : length);
        for (int readTotalLength = 0; readTotalLength < length; readTotalLength += readLength) {
            try {
                buf.position(readTotalLength);
                readLength = this.channel.read(buf);
                if (readLength >= 0) continue;
                throw new IOException("channel EOF");
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.tryClose(this.channel);
                throw new IOException("channel EOF");
            }
            catch (InterruptedIOException interruptedIOException) {
                this.tryClose(this.channel);
                throw new IOException("channel EOF");
            }
            catch (IOException iOException) {
                this.tryClose(this.channel);
                throw new IOException("channel EOF");
            }
        }
        return readLength;
    }

    private boolean readPacketHeader(ByteBuffer buf, byte type) throws IOException {
        int readLength = this.readFully(buf.array(), buf.array().length);
        if (readLength <= 0) {
            return false;
        }
        if (buf.get() != 84 || buf.get() != 73 || buf.get() != 77 || buf.get() != type) assert (false);
        return true;
    }

    static class TIMHeader {
        byte[] id = new byte[]{84, 73, 77};
        byte type;
        int sessionID = 0;

        TIMHeader() {
        }

        byte[] toBytes() {
            byte[] data = new byte[8];
            System.arraycopy(this.id, 0, data, 0, 3);
            data[3] = this.type;
            byte[] bytes = ByteBuffer.allocate(4).putInt(this.sessionID).array();
            System.arraycopy(bytes, 0, data, 4, 4);
            return data;
        }
    }
}

