/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.daemon;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tizen.sdblib.daemon.Server;
import org.tizen.sdblib.daemon.ServerState;
import org.tizen.sdblib.exception.ServerException;
import org.tizen.sdblib.util.Log;

public abstract class AbstractServer
implements Server,
Runnable {
    protected Thread thread = null;
    protected Lock lock = new ReentrantLock();
    protected ServerState state = ServerState.Terminated;
    protected final String name;

    public AbstractServer() {
        this(null);
    }

    public AbstractServer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ServerState getStatus() {
        this.lock.lock();
        try {
            ServerState serverState = this.state;
            return serverState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(ServerState state) {
        this.lock.lock();
        try {
            this.state = state;
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            AbstractServer abstractServer = this;
            synchronized (abstractServer) {
                this.notifyAll();
            }
            throw throwable;
        }
        this.lock.unlock();
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            this.notifyAll();
        }
    }

    public boolean isState(ServerState ... states) {
        this.lock.lock();
        try {
            ServerState[] serverStateArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                ServerState state = serverStateArray[n2];
                if (this.state.equals((Object)state)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitState(ServerState ... states) {
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            while (true) {
                if (this.isState(states)) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (this.isState(new ServerState[]{ServerState.Halting})) {
            this.setStatus(ServerState.Terminated);
            return;
        }
        try {
            block12: {
                this.initialize();
                this.lock.lock();
                if (!this.isState(new ServerState[]{ServerState.Halting})) break block12;
                this.lock.unlock();
                return;
                {
                    catch (Throwable var1_1) {
                        throw var1_1;
                    }
                }
            }
            try {
                try {
                    this.setStatus(ServerState.Running);
                    if (true) ** GOTO lbl23
                }
                finally {
                    this.lock.unlock();
                }
                do {
                    this.process();
lbl23:
                    // 2 sources

                } while (!this.isState(new ServerState[]{ServerState.Halting}));
            }
            catch (Exception e) {
                Log.e("Error occurred:", e);
            }
        }
        finally {
            this.terminate();
            this.setStatus(ServerState.Terminated);
        }
    }

    @Override
    public void boot() throws ServerException {
        this.lock.lock();
        try {
            if (!this.isState(ServerState.Terminated)) {
                throw new IllegalStateException();
            }
            String name = this.getName();
            this.thread = name == null ? new Thread(this) : new Thread((Runnable)this, name);
            this.thread.setDaemon(true);
            this.thread.start();
            this.setStatus(ServerState.Initializing);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void down() {
        this.lock.lock();
        try {
            if (this.isState(ServerState.Terminated, ServerState.Halting)) {
                throw new IllegalStateException();
            }
            this.setStatus(ServerState.Halting);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void initialize() throws ServerException {
    }

    protected abstract void process() throws Exception;

    protected void terminate() {
    }
}

