/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.common.ui.dialog.TransferProgressMonitorDialog;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.service.ISyncProgressMonitor;

public class SyncProgressMonitor
implements ISyncProgressMonitor {
    protected static String[] UNITS = new String[]{"B", "KB", "MB", "GB"};
    protected static String[] FORMATS = new String[]{"%.0f %s", "%.0f %s", "%.0f %s", "%.2f %s"};
    protected final TransferProgressMonitorDialog dialog;
    protected final IProgressMonitor monitor;
    protected final MessageConsoleStream console;
    protected String name;
    private String labelFrom = "From: ";
    private String labelTo = "To: ";
    private String labelSize = "Size: ";
    private String lastFromStr = "";
    private String lastToStr = "";
    private String lastSizeStr = "";
    protected long totalWork;
    protected long worked;
    protected int rate;

    protected static String getSizeAndUnit(long size) {
        int index = 0;
        double value = size;
        while (index < UNITS.length - 1 && value >= 1000.0) {
            value /= 1000.0;
            ++index;
        }
        return String.format(FORMATS[index], value, UNITS[index]);
    }

    public SyncProgressMonitor(TransferProgressMonitorDialog tmd, IProgressMonitor monitor, String name) {
        this.dialog = tmd;
        this.monitor = monitor;
        this.name = name;
        this.console = null;
    }

    public SyncProgressMonitor(TransferProgressMonitorDialog tmd, IProgressMonitor monitor, String name, MessageConsoleStream console) {
        this.dialog = tmd;
        this.monitor = monitor;
        this.name = name;
        this.console = console;
    }

    public void start(long totalWork) {
        this.totalWork = totalWork;
        this.rate = 1;
        while (totalWork > Integer.MAX_VALUE) {
            totalWork /= 10L;
            this.rate *= 10;
        }
        this.monitor.beginTask(this.name, (int)totalWork);
        this.apply(0);
    }

    public void stop() {
        this.monitor.done();
    }

    public void advance(long work) {
        this.worked += work;
        this.apply((int)work / this.rate);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void startSubTask(String name) {
        this.name = name;
        this.apply(0);
    }

    protected void apply(final int work) {
        String fromStr;
        String toStr;
        String sizeStr;
        final Label fromLabel = this.dialog.getFromLabel();
        final Label toLabel = this.dialog.getToLabel();
        final Label sizeLabel = this.dialog.getSizeLabel();
        if (fromLabel.isDisposed() || toLabel.isDisposed() || sizeLabel.isDisposed()) {
            return;
        }
        if (this.name == null) {
            sizeStr = "";
            toStr = "";
            fromStr = "";
        } else {
            String[] subTasks = this.name.split("\t");
            if (subTasks.length != 2) {
                fromStr = subTasks[0];
                toStr = "";
                sizeStr = "";
            } else {
                fromStr = String.valueOf(this.labelFrom) + subTasks[0];
                toStr = String.valueOf(this.labelTo) + subTasks[1];
                sizeStr = String.valueOf(this.labelSize) + String.format("( %s / %s )", SyncProgressMonitor.getSizeAndUnit(this.getWorked()), SyncProgressMonitor.getSizeAndUnit(this.getTotal()));
            }
        }
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                SyncProgressMonitor.this.monitor.worked(work);
                if (!SyncProgressMonitor.this.lastFromStr.equals(fromStr)) {
                    fromLabel.setText(TransferProgressMonitorDialog.shortenText((String)fromStr, (Control)fromLabel));
                    SyncProgressMonitor.this.lastFromStr = fromStr;
                }
                if (!SyncProgressMonitor.this.lastToStr.equals(toStr)) {
                    toLabel.setText(TransferProgressMonitorDialog.shortenText((String)toStr, (Control)toLabel));
                    SyncProgressMonitor.this.lastToStr = toStr;
                }
                if (!sizeStr.contains("KB") && !SyncProgressMonitor.this.lastSizeStr.equals(sizeStr)) {
                    sizeLabel.setText(TransferProgressMonitorDialog.shortenText((String)sizeStr, (Control)sizeLabel));
                    SyncProgressMonitor.this.lastSizeStr = sizeStr;
                }
            }
        });
    }

    public long getTotal() {
        return this.totalWork;
    }

    public long getWorked() {
        return this.worked;
    }

    public void printLog(String msg) {
        if (this.console != null) {
            this.console.println(msg);
        }
    }
}

