/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.DaemonClient;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.resolver.FileResolver;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_exportRepositoriesOverGit")
class Daemon
extends TextBuiltin {
    @Option(name="--config-file", metaVar="metaVar_configFile", usage="usage_configFile")
    File configFile;
    @Option(name="--port", metaVar="metaVar_port", usage="usage_portNumberToListenOn")
    int port = 9418;
    @Option(name="--listen", metaVar="metaVar_hostName", usage="usage_hostnameOrIpToListenOn")
    String host;
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Option(name="--enable", metaVar="metaVar_service", usage="usage_enableTheServiceInAllRepositories", multiValued=true)
    final List<String> enable = new ArrayList<String>();
    @Option(name="--disable", metaVar="metaVar_service", usage="usage_disableTheServiceInAllRepositories", multiValued=true)
    final List<String> disable = new ArrayList<String>();
    @Option(name="--allow-override", metaVar="metaVar_service", usage="usage_configureTheServiceInDaemonServicename", multiValued=true)
    final List<String> canOverride = new ArrayList<String>();
    @Option(name="--forbid-override", metaVar="metaVar_service", usage="usage_configureTheServiceInDaemonServicename", multiValued=true)
    final List<String> forbidOverride = new ArrayList<String>();
    @Option(name="--export-all", usage="usage_exportWithoutGitDaemonExportOk")
    boolean exportAll;
    @Argument(required=true, metaVar="metaVar_directory", usage="usage_directoriesToExport")
    final List<File> directory = new ArrayList<File>();

    Daemon() {
    }

    protected boolean requiresRepository() {
        return false;
    }

    protected void run() throws Exception {
        int threads;
        PackConfig packConfig = new PackConfig();
        if (this.configFile != null) {
            if (!this.configFile.exists()) {
                throw Daemon.die(MessageFormat.format(CLIText.get().configFileNotFound, this.configFile.getAbsolutePath()));
            }
            FileBasedConfig cfg = new FileBasedConfig(this.configFile, FS.DETECTED);
            cfg.load();
            new WindowCacheConfig().fromConfig(cfg).install();
            packConfig.fromConfig(cfg);
        }
        if ((threads = packConfig.getThreads()) <= 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        if (1 < threads) {
            packConfig.setExecutor(Executors.newFixedThreadPool(threads));
        }
        FileResolver<DaemonClient> resolver = new FileResolver<DaemonClient>();
        for (File f : this.directory) {
            this.outw.println(MessageFormat.format(CLIText.get().exporting, f.getAbsolutePath()));
            resolver.exportDirectory(f);
        }
        resolver.setExportAll(this.exportAll);
        org.eclipse.jgit.transport.Daemon d = new org.eclipse.jgit.transport.Daemon(this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port));
        d.setPackConfig(packConfig);
        d.setRepositoryResolver(resolver);
        if (0 <= this.timeout) {
            d.setTimeout(this.timeout);
        }
        for (String n : this.enable) {
            Daemon.service(d, n).setEnabled(true);
        }
        for (String n : this.disable) {
            Daemon.service(d, n).setEnabled(false);
        }
        for (String n : this.canOverride) {
            Daemon.service(d, n).setOverridable(true);
        }
        for (String n : this.forbidOverride) {
            Daemon.service(d, n).setOverridable(false);
        }
        d.start();
        this.outw.println(MessageFormat.format(CLIText.get().listeningOn, d.getAddress()));
    }

    private static DaemonService service(org.eclipse.jgit.transport.Daemon d, String n) {
        DaemonService svc = d.getService(n);
        if (svc == null) {
            throw Daemon.die(MessageFormat.format(CLIText.get().serviceNotSupported, n));
        }
        return svc;
    }
}

