/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.smartlaunch.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.gom.smartlaunch.GomSmartLauncher;
import org.tizen.common.gom.smartlaunch.messages.GomMessages;
import org.tizen.common.gom.smartlaunch.ui.GomContentProvider;
import org.tizen.common.gom.smartlaunch.ui.GomLabelProvider;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;

public class GomDialog
extends TitleAreaDialog {
    private static final int WIDTH = 550;
    private static final int HEIGHT = 550;
    private Label lbBuild;
    private Button[] btnMode;
    private Text textConfigName;
    private Combo comboBuildConfiguration;
    private Combo comboShortcut;
    private String[] modes = new String[]{GomSmartLauncher.MODES.RUN.getMode(), GomSmartLauncher.MODES.DEBUG.getMode(), GomSmartLauncher.MODES.PROFILE.getMode()};
    private List<IProject> projectList = new ArrayList<IProject>();
    private List<String> configList = new ArrayList<String>();
    private List filteredShortcuts = null;
    private String configurationName;
    private IProject project;
    private String buildConfigName;
    private String mode;
    private LaunchShortcutExtension ext;
    private IProject[] projects;
    private boolean isDirtyName = false;

    public GomDialog(Shell shell) {
        super(shell);
        this.setShellStyle(112);
        this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(GomMessages.SMARTLAUNCH_DIALOG_TITLE);
        Rectangle bounds = newShell.getBounds();
        int x = bounds.x + (bounds.width - 550) / 2;
        int y = bounds.y + (bounds.height - 550) / 2;
        newShell.setLocation(x, y);
        newShell.setSize(550, 550);
        newShell.setMinimumSize(550, 550);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.tizen.ide.native.smart_launch_context");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createDescriptionArea(container);
        this.createContentArea(container);
        return container;
    }

    private void createDescriptionArea(Composite composite) {
        Composite topComp = new Composite(composite, 0);
        GridData gd = new GridData(768);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        this.setTitle(GomMessages.SMARTLAUNCH_DIALOG_DESCRIPTION);
    }

    private void createContentArea(Composite composite) {
        SashForm sash = new SashForm(composite, 65536);
        sash.setOrientation(256);
        GridData gd = new GridData(1808);
        sash.setLayoutData((Object)gd);
        sash.setVisible(true);
        Control projectArea = this.createProjectSelectionArea((Composite)sash);
        projectArea.setLayoutData((Object)new GridData(1808));
        Control launchArea = this.createLaunchArea((Composite)sash);
        launchArea.setLayoutData((Object)new GridData(1808));
        sash.setWeights(new int[]{3, 5});
    }

    private Control createProjectSelectionArea(Composite composite) {
        Composite comp = new Composite(composite, 2048);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        Label lbProject = new Label(comp, 0);
        lbProject.setText(GomMessages.SMARTLAUNCH_NEW_DIALOG_PROJECTS);
        Group grpProjects = new Group(comp, 0);
        grpProjects.setLayout((Layout)new GridLayout(1, false));
        GridData radio_gd = new GridData(1808);
        grpProjects.setLayoutData((Object)radio_gd);
        grpProjects.setBackground(composite.getDisplay().getSystemColor(25));
        this.createProjectViewer((Composite)grpProjects);
        return comp;
    }

    private void createProjectViewer(Composite composite) {
        this.projectList.clear();
        TreeViewer viewer = new TreeViewer(composite, 66304);
        final Tree tree = viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider((IContentProvider)new GomContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new GomLabelProvider(composite.getDisplay()));
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GomDialog.this.project = (IProject)tree.getSelection()[0].getData();
                GomDialog.this.setBuildConfigurationCombo();
                GomDialog.this.setModeCombo();
                GomDialog.this.setShortcutCombo();
                GomDialog.this.modifyDefaultConfigName();
            }
        });
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isTizenProject((IProject)project)) {
                this.projectList.add(project);
            }
            ++n2;
        }
        if (this.projectList.size() > 0) {
            this.project = this.projectList.get(0);
        }
        viewer.setInput((Object)this.projectList.toArray(new IProject[this.projectList.size()]));
    }

    private Control createLaunchArea(Composite composite) {
        Composite comp = new Composite(composite, 2048);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        this.createWidget(comp);
        return comp;
    }

    private void createWidget(Composite composite) {
        this.createConfigNamePart(composite);
        this.createBuildConfigPart(composite);
        this.createModeAndShortcutPart(composite);
    }

    private void createConfigNamePart(Composite composite) {
        Label lbName = new Label(composite, 0);
        lbName.setText(GomMessages.SMARTLAUNCH_NEW_DIALOG_LABEL_CONFIGURATION);
        this.textConfigName = new Text(composite, 2048);
        this.textConfigName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textConfigName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                GomDialog.this.configurationName = text.getText();
                GomDialog.this.validateInput(GomDialog.this.configurationName);
                GomDialog.this.isDirtyName = true;
            }
        });
    }

    private void createBuildConfigPart(Composite composite) {
        this.lbBuild = new Label(composite, 0);
        this.lbBuild.setText(GomMessages.SMARTLAUNCH_NEW_DIALOG_BUILD_CONFIGURATION);
        this.comboBuildConfiguration = new Combo(composite, 8);
        this.comboBuildConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboBuildConfiguration.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                GomDialog.this.setSelectionBuildConfiguration(combo.getSelectionIndex());
                GomDialog.this.modifyDefaultConfigName();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setBuildConfigurationCombo();
    }

    private void setBuildConfigurationCombo() {
        this.comboBuildConfiguration.removeAll();
        if (!ProjectUtil.isTizenNativeProject((IProject)this.project)) {
            this.lbBuild.setVisible(false);
            this.comboBuildConfiguration.setVisible(false);
            return;
        }
        this.lbBuild.setVisible(true);
        this.comboBuildConfiguration.setVisible(true);
        this.configList.clear();
        ITizenNativeProject adapter = (ITizenNativeProject)this.project.getAdapter(ITizenNativeProject.class);
        this.configList = adapter.getBuildConfigurations();
        String defaultConfig = adapter.getDefaultBuildConfiguration();
        if (this.configList.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)(String.valueOf(this.project.getName()) + " failed"));
            return;
        }
        int i = 0;
        while (i < this.configList.size()) {
            String config = this.configList.get(i);
            this.comboBuildConfiguration.add(this.configList.get(i));
            if (defaultConfig != null && defaultConfig.equals(config)) {
                this.setSelectionBuildConfiguration(i);
            }
            ++i;
        }
    }

    private void setSelectionBuildConfiguration(int index) {
        this.comboBuildConfiguration.select(index);
        this.buildConfigName = this.configList.get(index);
    }

    private void createModeAndShortcutPart(Composite composite) {
        Label lbMode = new Label(composite, 0);
        lbMode.setText(GomMessages.SMARTLAUNCH_NEW_DIALOG_MODE);
        Group grpMode = new Group(composite, 0);
        grpMode.setLayout((Layout)new GridLayout(1, false));
        GridData radio_gd = new GridData(768);
        grpMode.setLayoutData((Object)radio_gd);
        this.btnMode = new Button[this.modes.length];
        int i = 0;
        while (i < this.modes.length) {
            this.btnMode[i] = new Button((Composite)grpMode, 16);
            this.btnMode[i].setText(StringUtil.convertFirstLetterUpperCase((String)this.modes[i]));
            this.btnMode[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    String[] stringArray = GomDialog.this.modes;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String m = stringArray[n2];
                        if (m.equals(btn.getText().toLowerCase())) {
                            GomDialog.this.mode = m;
                        }
                        ++n2;
                    }
                    GomDialog.this.setShortcutCombo();
                    GomDialog.this.modifyDefaultConfigName();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        this.btnMode[0].setSelection(true);
        this.mode = this.modes[0];
        Label lbShortcut = new Label(composite, 0);
        lbShortcut.setText(GomMessages.SMARTLAUNCH_NEW_DIALOG_CONFIGURATION_TYPE);
        this.comboShortcut = new Combo(composite, 8);
        this.comboShortcut.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboShortcut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                GomDialog.this.ext = (LaunchShortcutExtension)GomDialog.this.filteredShortcuts.get(combo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setShortcutCombo();
    }

    private void setModeCombo() {
        if (!ProjectUtil.isTizenNativeProject((IProject)this.project)) {
            this.btnMode[2].setVisible(false);
            this.btnMode[2].setSelection(false);
            if (this.mode.equals(this.modes[2])) {
                this.btnMode[0].setSelection(true);
                this.mode = this.modes[0];
                this.setShortcutCombo();
                this.modifyDefaultConfigName();
            }
            return;
        }
        this.btnMode[2].setVisible(true);
    }

    private void setShortcutCombo() {
        this.comboShortcut.removeAll();
        this.filteredShortcuts = GomSmartLauncher.getShortcuts(this.project, this.mode);
        for (LaunchShortcutExtension ext : this.filteredShortcuts) {
            this.comboShortcut.add(ext.getContextLabel(this.mode));
        }
        if (this.setComboSelectDefault(this.comboShortcut)) {
            this.ext = (LaunchShortcutExtension)this.filteredShortcuts.get(0);
        }
    }

    private boolean setComboSelectDefault(Combo combo) {
        if (combo.getItemCount() > 0) {
            combo.select(0);
            return true;
        }
        return false;
    }

    private void validateInput(String text) {
        String errorMessage = null;
        errorMessage = this.isValidConfigName(text);
        this.setErrorMessage(errorMessage);
    }

    private String isValidConfigName(String fileName) {
        int validLinuxCheck = FilenameUtil.isVaildName((String)fileName, (int)1024);
        int validWinCheck = FilenameUtil.isVaildName((String)fileName, (int)256);
        if (validLinuxCheck != 0 || validWinCheck != 0) {
            if (validLinuxCheck == 1 || validWinCheck == 1) {
                return GomMessages.SMARTLAUNCH_NEW_DIALOG_INVALID_NAME;
            }
            if (validLinuxCheck == 2 || validWinCheck == 2) {
                return GomMessages.SMARTLAUNCH_NEW_DIALOG_NO_NAME;
            }
        }
        return null;
    }

    public void modifyDefaultConfigName() {
        if (!this.isDirtyName) {
            this.setDefaultConfigName();
        }
    }

    private void setDefaultConfigName() {
        String buildConfigInfo = ProjectUtil.isTizenNativeProject((IProject)this.project) ? "_" + this.buildConfigName : "";
        String defaultName = "[" + StringUtil.convertFirstLetterUpperCase((String)this.mode) + "] " + this.project.getName() + buildConfigInfo;
        this.textConfigName.setText(defaultName);
        this.isDirtyName = false;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getMode() {
        return this.mode;
    }

    public String getBuildConfiguration() {
        return this.buildConfigName;
    }

    public LaunchShortcutExtension getLaunchShortcutExtension() {
        return this.ext;
    }
}

