/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.tizen.common.rest.ui.preferences.IPreferenceConstants;

public class RestPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.common.rest";
    private static RestPlugin plugin;
    private ResourceBundle resourceBundle;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.tizen.common.rest.messages");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RestPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return RestPlugin.imageDescriptorFromPlugin((String)RestPlugin.getPluginId(), (String)path);
    }

    public static String getString(String key) {
        ResourceBundle bundle = RestPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String format(String key, String arg) {
        try {
            return MessageFormat.format(RestPlugin.getString(key), arg);
        }
        catch (MissingResourceException missingResourceException) {
            return "Can not find resource : " + key;
        }
    }

    public static String format(String key, String[] args) {
        try {
            return MessageFormat.format(RestPlugin.getString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static String getPluginId() {
        return RestPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(Throwable e) {
        RestPlugin.log((IStatus)new Status(4, RestPlugin.getPluginId(), e.getMessage(), e));
    }

    public static void log(IStatus status) {
        RestPlugin.getDefault().getLog().log(status);
    }

    public static String getPluginPath() {
        try {
            Bundle bundle = RestPlugin.getDefault().getBundle();
            URL url = Platform.asLocalURL((URL)bundle.getEntry("/"));
            String path = url.getPath().trim();
            return path;
        }
        catch (IOException e) {
            RestPlugin.log(e);
            return null;
        }
    }

    public String getVersion() {
        return (String)this.getBundle().getHeaders().get("Bundle-Version");
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("PREF_KEY_REPO_PATH", IPreferenceConstants.DEFAULT_PREF_VALUE_REPO_PATH);
        store.setDefault("PREF_KEY_USER_VARIABLES_PROFILE", "Default");
        store.setDefault("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE", "Default");
        store.setDefault("PREF_KEY_RUN_HISTORY_SIZE", 5);
        store.setDefault("PREF_KEY_USE_PROXY", "false");
        store.setDefault("PREF_KEY_PROXY_HOST", "");
        store.setDefault("PREF_KEY_PROXY_PORT", "");
        store.setDefault("PREF_KEY_USE_PROXY_AUTH", "false");
        store.setDefault("PREF_KEY_PROXY_USER", "");
        store.setDefault("PREF_KEY_PROXY_PASSWORD", "");
        store.setDefault("PREF_KEY_RES_SAVE_AUTO", "false");
        store.setDefault("PREF_KEY_RES_SAVE_ASK", "true");
        store.setDefault("PREF_KEY_RES_SAVE_OVERWRITE", "false");
        store.setDefault("PREF_KEY_AUTH_OAUTH_GRANT_TYPE", "authorization_code");
        store.setDefault("PREF_KEY_AUTH_OAUTH_LOCATION_ACCESS_TOKEN", "PREF_VALUE_AUTH_OAUTH_LOCATION_JSON");
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(String path) {
        return RestPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

