/*
* Native IDE - Command Line Interface
*
* Copyright (c) 2000 - 2013 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact:
* Ho Namkoong <ho.namkoong@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* Kangho Kim <kh5325.kim@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/

package org.tizen.cli.exec.pack;

import java.io.File;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.command.Executor;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.build.AbstractMultiPackager;
import org.tizen.nativecpp.misc.core.NewAppXmlStore;

public class CLIMultiPackager extends AbstractMultiPackager{

    public static final String BIN_FOLDER_NAME = "CommandLineBuild";
    private String rootPrjPath;
    private String[] refPrjPath;
    
    CLIMultiPackager(String rootPrjPath, String[] refPrjPath, Executor executor) {
        super(executor);
        this.rootPrjPath = rootPrjPath;
        this.refPrjPath = refPrjPath;
    }
    
    @Override
    protected String getBinaryFolder() {
        return BIN_FOLDER_NAME;
    }

    @Override
    protected void buildPrjs() throws Exception {
        // TODO do later
    }

    @Override
    protected String[] getRefPrjPaths() {
        return refPrjPath;
    }

    @Override
    protected String getRootPrjPath() {
        return rootPrjPath;
    }

    @Override
    protected boolean validateMultiPackage() {
        File manifestFile = new File(rootPrjPath, TizenPlatformConstants.MANIFEST_XML_FILE_NAME);
        if(!manifestFile.exists() || refPrjPath == null || refPrjPath.length < 1) {
            return false;
        }
        
        return true;
    }

    @Override
    protected IXMLStore getIXmlStore() throws Exception {
        return new NewAppXmlStore();
    }
    
}
