/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.horizontalSpinner;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.utils.StringUtil;

public class HorizontalSpinner
extends Composite {
    private final List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private Button leftButton;
    private Button rightButton;
    private Text text;
    private int digits = 0;
    private int increment = 1;
    private int maximum = 0;
    private int minimum = 255;
    private int pageIncrement = 10;
    private int storedValue = 0;
    private final char decimalFormatSeparator;

    public HorizontalSpinner(Composite parent, int style) {
        super(parent, style);
        GridLayout gd = new GridLayout(3, false);
        gd.verticalSpacing = 0;
        gd.horizontalSpacing = 0;
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        this.setLayout((Layout)gd);
        this.createContent(style);
        this.addTextListeners();
        this.addButtonsListener();
        this.addModifyListeners();
        this.decimalFormatSeparator = new DecimalFormatSymbols().getDecimalSeparator();
    }

    private void createContent(int style) {
        boolean readOnly = (style & 8) == 8;
        boolean flat = (style & 0x800000) == 0x800000;
        int buttonStyle = 4 | (flat ? 0x800000 : 0);
        this.leftButton = new Button((Composite)this, buttonStyle | 0x4000);
        this.leftButton.setFont(this.getFont());
        this.leftButton.setBackground(this.getBackground());
        this.leftButton.setCursor(this.getCursor());
        this.leftButton.setEnabled(this.getEnabled());
        this.leftButton.setFont(this.getFont());
        this.leftButton.setForeground(this.getForeground());
        this.leftButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.text = new Text((Composite)this, readOnly ? 8 : 0);
        GridData gd = new GridData(4, 2, true, false);
        gd.minimumWidth = 40;
        this.text.setLayoutData((Object)gd);
        this.rightButton = new Button((Composite)this, buttonStyle | 0x20000);
        this.rightButton.setFont(this.getFont());
        this.rightButton.setBackground(this.getBackground());
        this.rightButton.setCursor(this.getCursor());
        this.rightButton.setEnabled(this.getEnabled());
        this.rightButton.setFont(this.getFont());
        this.rightButton.setForeground(this.getForeground());
        this.rightButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void addTextListeners() {
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.character != '\u0000' && !Character.isDigit(e.character) && e.keyCode != 8 && e.keyCode != 127) {
                    e.doit = false;
                    return;
                }
                e.doit = HorizontalSpinner.this.verifyEntryAndStoreValue(e.text, e.keyCode);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    HorizontalSpinner.this.increaseValue(HorizontalSpinner.this.increment);
                }
                if (e.keyCode == 0x1000002) {
                    HorizontalSpinner.this.decreaseValue(HorizontalSpinner.this.increment);
                }
                if (e.keyCode == 0x1000005) {
                    HorizontalSpinner.this.increaseValue(HorizontalSpinner.this.pageIncrement);
                }
                if (e.keyCode == 0x1000006) {
                    HorizontalSpinner.this.decreaseValue(HorizontalSpinner.this.pageIncrement);
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (HorizontalSpinner.this.text.getText().trim().equals("")) {
                    HorizontalSpinner.this.setSelection(HorizontalSpinner.this.storedValue);
                }
            }
        });
    }

    private boolean verifyEntryAndStoreValue(String entry, int keyCode) {
        String work = keyCode == 127 ? StringUtil.removeCharAt(this.text.getText(), this.text.getCaretPosition()) : (keyCode == 8 && this.text.getCaretPosition() == 0 ? StringUtil.removeCharAt(this.text.getText(), this.text.getCaretPosition() - 1) : (keyCode == 0 ? entry : StringUtil.insertString(this.text.getText(), entry, this.text.getCaretPosition())));
        try {
            double d = Double.parseDouble(work.replace(this.decimalFormatSeparator, '.'));
            this.storedValue = (int)(d * Math.pow(10.0, this.getDigits()));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        for (SelectionListener s : this.selectionListeners) {
            s.widgetSelected(null);
        }
        return true;
    }

    private void addButtonsListener() {
        this.leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HorizontalSpinner.this.decreaseValue(HorizontalSpinner.this.increment);
            }
        });
        this.rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HorizontalSpinner.this.increaseValue(HorizontalSpinner.this.increment);
            }
        });
    }

    private void increaseValue(int value) {
        this.setSelection(this.getSelection() + value);
    }

    private void decreaseValue(int value) {
        this.setSelection(this.getSelection() - value);
    }

    private void addModifyListeners() {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (ModifyListener m : HorizontalSpinner.this.modifyListeners) {
                    m.modifyText(e);
                }
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.modifyListeners.add(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.add(listener);
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return this.storedValue;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.modifyListeners.remove(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.remove(listener);
    }

    public void setDigits(int value) {
        this.checkWidget();
        this.digits = value;
        this.convertSelection();
    }

    public void setIncrement(int value) {
        this.checkWidget();
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        this.maximum = value;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        this.minimum = value;
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        this.pageIncrement = value;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection < this.minimum) {
            selection = this.minimum;
        } else if (selection > this.maximum) {
            selection = this.maximum;
        }
        this.storedValue = selection;
        this.text.setText(this.convertSelection());
        this.text.selectAll();
        this.text.setFocus();
        for (SelectionListener s : this.selectionListeners) {
            s.widgetSelected(null);
        }
    }

    private String convertSelection() {
        if (this.getDigits() == 0) {
            return String.valueOf(this.storedValue);
        }
        String temp = String.valueOf((double)this.storedValue * Math.pow(10.0, -1 * this.getDigits()));
        return temp.replace('.', this.decimalFormatSeparator);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setDigits(digits);
        this.setIncrement(increment);
        this.setPageIncrement(pageIncrement);
        this.setSelection(selection);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        return this.text.forceFocus();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.leftButton.setBackground(color);
        this.rightButton.setBackground(color);
        this.text.setBackground(color);
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.leftButton.setBackgroundImage(image);
        this.rightButton.setBackgroundImage(image);
        this.text.setBackgroundImage(image);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.leftButton.setCursor(cursor);
        this.rightButton.setCursor(cursor);
        this.text.setCursor(cursor);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.leftButton.setEnabled(enabled);
        this.rightButton.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.leftButton.setForeground(color);
        this.rightButton.setForeground(color);
        this.text.setForeground(color);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.leftButton.setMenu(menu);
        this.rightButton.setMenu(menu);
        this.text.setMenu(menu);
    }

    public void setToolTipText(String tooltipText) {
        super.setToolTipText(tooltipText);
        this.leftButton.setToolTipText(tooltipText);
        this.rightButton.setToolTipText(tooltipText);
        this.text.setToolTipText(tooltipText);
    }
}

