/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import javafx.stage.FileChooser;
import org.tizen.common.connection.logview.dialog.EditLogTabDialog;
import org.tizen.common.connection.logview.model.Log;
import org.tizen.common.connection.logview.model.LogModel;
import org.tizen.common.connection.logview.service.DeviceDescriptor;
import org.tizen.common.connection.logview.view.Messages;

public class LogTabToolBarController {
    private LogModel logModel;
    private String FILE_DIALOG_TITLE = Messages.Log_Tab_Dialog_Title_Export_Logs;
    private String FILE_DIALOG_EXTENSION_TXT = Messages.Log_Tab_Dialog_Extension_Txt;
    private String FILE_DIALOG_FILE_NAME_POST_FIX = Messages.Log_Tab_Dialog_File_Name_Postfix;

    public LogTabToolBarController(LogModel model) {
        this.logModel = model;
    }

    public void changeMessageFilter(String newValue) {
        ArrayList<String> messages = new ArrayList<String>();
        if (!newValue.isEmpty()) {
            messages.add(newValue);
        }
        this.logModel.setMessageCriterion(messages);
    }

    public String getNewTabName(String tabname, DeviceDescriptor deviceDescriptor) {
        EditLogTabDialog dialog = new EditLogTabDialog(tabname, deviceDescriptor);
        return (String)dialog.showAndWait();
    }

    public void clearLog() {
        this.logModel.clearAllLogs();
    }

    public void exportLogToFile(String tabname) {
        try (PrintWriter fw = null;){
            try {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle(this.FILE_DIALOG_TITLE);
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.FILE_DIALOG_EXTENSION_TXT, new String[]{"*." + this.FILE_DIALOG_EXTENSION_TXT}));
                fileChooser.setInitialFileName(String.valueOf(tabname) + this.FILE_DIALOG_FILE_NAME_POST_FIX + "." + this.FILE_DIALOG_EXTENSION_TXT);
                File file = fileChooser.showSaveDialog(null);
                if (file != null) {
                    String filename = file.getAbsolutePath();
                    fw = new PrintWriter(filename);
                    BufferedWriter bw = new BufferedWriter(fw);
                    ArrayList<Log> logs = this.logModel.getMatchedLogs();
                    for (Log log : logs) {
                        bw.write(log.toString());
                        bw.newLine();
                    }
                    bw.close();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                if (fw != null) {
                    fw.close();
                }
            }
        }
    }
}

