/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import zipeditor.PreferenceInitializer;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.FileOpener;
import zipeditor.model.Node;

public class OpenWithMenu
extends ContributionItem {
    private IWorkbenchPage fPage;
    private IAdaptable fFile;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private FileOpener fFileOpener;
    private static Hashtable imageCache = new Hashtable(11);
    private static FileOpener.Editor previouslySelectedEditor;
    private static String previouslySelectedRadio;
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer;

    static {
        comparer = new Comparator(){
            private Collator collator = Collator.getInstance();

            public int compare(Object arg0, Object arg1) {
                String s1 = ((IEditorDescriptor)arg0).getLabel();
                String s2 = ((IEditorDescriptor)arg1).getLabel();
                return this.collator.compare(s1, s2);
            }
        };
    }

    public OpenWithMenu(IWorkbenchPage page, FileOpener fileOpener, IAdaptable file) {
        super(ID);
        this.fPage = page;
        this.fFileOpener = fileOpener;
        this.fFile = file;
        this.getFileResource();
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileResource().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.getFileResource().getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor[] editors = this.registry.getEditors(file.getName(), Utils.getContentType(file));
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, null);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, null);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, null);
        descriptor = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        if (descriptor != null) {
            this.createMenuItem(menu, descriptor, null);
        }
        this.createDefaultMenuItem(menu, file);
        new MenuItem(menu, 2);
        this.createChooseItem(menu, file);
    }

    private IFileStore getFileResource() {
        if (this.fFile instanceof IFileStore) {
            return (IFileStore)this.fFile;
        }
        return (IFileStore)this.fFile.getAdapter(IFileStore.class);
    }

    private Node getNode() {
        return (Node)(this.fFile instanceof Node ? this.fFile : (IAdaptable)this.fFile.getAdapter(Node.class));
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor) {
        IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        try {
            String editorId = editor == null ? "org.eclipse.ui.systemExternalEditor" : editor.getId();
            this.fPage.openEditor(Utils.createEditorInput(file), editorId, true, 3);
            ZipEditorPlugin.getDefault().addFileMonitor(new File(file.toURI()), this.getNode());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.fPage.getWorkbenchWindow().getShell(), (String)ActionMessages.getString("OpenWithMenu.0"), (String)e.getMessage(), (IStatus)ZipEditorPlugin.createErrorStatus(e.getMessage(), e));
        }
    }

    private void openWithProgram(IFileStore file) {
        ExecutableSelectionDialog dialog = new ExecutableSelectionDialog(this.fPage.getWorkbenchWindow().getShell(), previouslySelectedEditor);
        if (dialog.open() != 0) {
            return;
        }
        previouslySelectedEditor = (FileOpener.Editor)dialog.getSelection();
        this.fFileOpener.openFromOther(file, previouslySelectedEditor);
    }

    private void createDefaultMenuItem(Menu menu, final IFileStore file) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setText(ActionMessages.getString("OpenWithMenu.1"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        try {
                            OpenWithMenu.this.fPage.openEditor(Utils.createEditorInput(file), Utils.getEditorId(file), true, 3);
                            ZipEditorPlugin.getDefault().addFileMonitor(new File(file.toURI()), OpenWithMenu.this.getNode());
                            break;
                        }
                        catch (PartInitException e) {
                            ErrorDialog.openError((Shell)OpenWithMenu.this.fPage.getWorkbenchWindow().getShell(), (String)ActionMessages.getString("OpenWithMenu.2"), (String)e.getMessage(), (IStatus)ZipEditorPlugin.createErrorStatus(e.getMessage(), e));
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createChooseItem(Menu menu, final IFileStore file) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setText(ActionMessages.getString("OpenWithMenu.4"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openWithProgram(file);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private class ExecutableSelectionDialog
    extends SelectionStatusDialog {
        private TableViewer fTableViewer;
        private Object fSelection;
        private String fLastFilterPath;
        private Set fExternalEditors;
        private Set fInternalEditors;
        private Button fAddButton;
        private IAction fAddAction;
        private IAction fEditAction;
        private IAction fRemoveAction;

        public ExecutableSelectionDialog(Shell parentShell, Object initialSelection) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fSelection = initialSelection;
            this.setTitle(ActionMessages.getString("OpenWithMenu.5"));
            this.fAddAction = new AddAction();
            this.fEditAction = new EditAction();
            this.fRemoveAction = new RemoveAction();
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            if (this.fSelection != null) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fSelection));
            }
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 16384);
            label.setText(ActionMessages.getString("OpenWithMenu.6"));
            label.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 16384);
            label.setText(String.valueOf(ActionMessages.getString("OpenWithMenu.7")) + OpenWithMenu.this.getFileResource().getName());
            label.setLayoutData((Object)new GridData(32));
            this.createExternalEditorGroup(composite);
            ExecutableSelectionDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private Control createExternalEditorGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(ActionMessages.getString("OpenWithMenu.8"));
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(1808));
            Button[] buttons = this.createRadioButtons((Composite)group);
            this.fTableViewer = this.createTableViewer((Composite)group);
            Composite btnComposite = new Composite((Composite)group, 0);
            btnComposite.setLayout((Layout)new GridLayout(2, false));
            btnComposite.setLayoutData((Object)new GridData(768));
            this.fAddButton = new Button(btnComposite, 8);
            this.fAddButton.setText(ActionMessages.getString("OpenWithMenu.9"));
            this.setButtonLayoutData(this.fAddButton);
            ((GridData)this.fAddButton.getLayoutData()).horizontalAlignment |= 0x20;
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutableSelectionDialog.this.handleAddButtonSelected();
                }
            });
            if (buttons[0].getText().equals(previouslySelectedRadio)) {
                this.handleExternalButtonSelected(buttons[0]);
                buttons[0].setSelection(true);
            }
            if (buttons[1].getText().equals(previouslySelectedRadio)) {
                this.handleInternalButtonSelected(buttons[1]);
                buttons[1].setSelection(true);
            }
            return group;
        }

        private Button[] createRadioButtons(Composite parent) {
            Button[] buttons = new Button[2];
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, true));
            composite.setLayoutData((Object)new GridData(768));
            Button button = buttons[0] = new Button(composite, 16);
            button.setText(ActionMessages.getString("OpenWithMenu.10"));
            this.setButtonLayoutData(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutableSelectionDialog.this.handleExternalButtonSelected((Button)e.widget);
                }
            });
            button = buttons[1] = new Button(composite, 16);
            button.setText(ActionMessages.getString("OpenWithMenu.11"));
            this.setButtonLayoutData(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutableSelectionDialog.this.handleInternalButtonSelected((Button)e.widget);
                }
            });
            return buttons;
        }

        private Set getExternalEditors() {
            if (this.fExternalEditors == null) {
                this.fExternalEditors = new HashSet();
                this.fExternalEditors.addAll(Arrays.asList(this.createExternalEditors(this.loadExecutables())));
            }
            return this.fExternalEditors;
        }

        private Object getInternalEditors() {
            if (this.fInternalEditors == null) {
                this.fInternalEditors = new HashSet<FileOpener.Editor>(Arrays.asList(this.createInternalEditors(this.getEditorsFromRegistry())));
            }
            return this.fInternalEditors;
        }

        private IEditorDescriptor[] getEditorsFromRegistry() {
            try {
                IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                return (IEditorDescriptor[])editorRegistry.getClass().getMethod("getSortedEditorsFromPlugins", null).invoke((Object)editorRegistry, null);
            }
            catch (Exception e) {
                ZipEditorPlugin.log(e);
                return new IEditorDescriptor[0];
            }
        }

        private TableViewer createTableViewer(Composite parent) {
            TableViewer viewer = new TableViewer(parent, 2052);
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new EditorDescriptorLabelProvider());
            viewer.setSorter(new ViewerSorter());
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(14);
            data.widthHint = this.convertWidthInCharsToPixels(45);
            viewer.getTable().setLayoutData((Object)data);
            viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ExecutableSelectionDialog.this.okPressed();
                }
            });
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ExecutableSelectionDialog.this.updateButtons();
                }
            });
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add(ExecutableSelectionDialog.this.fAddAction);
                    manager.add(ExecutableSelectionDialog.this.fEditAction);
                    manager.add(ExecutableSelectionDialog.this.fRemoveAction);
                }
            });
            Menu contextMenu = manager.createContextMenu(viewer.getControl());
            viewer.getControl().setMenu(contextMenu);
            return viewer;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.updateButtons();
            return control;
        }

        private FileOpener.Editor[] createExternalEditors(String[] executablePaths) {
            FileOpener.Editor[] editors = new FileOpener.Editor[executablePaths.length];
            int i = 0;
            while (i < editors.length) {
                editors[i] = new FileOpener.Editor(executablePaths[i]);
                ++i;
            }
            return editors;
        }

        private FileOpener.Editor[] createInternalEditors(IEditorDescriptor[] descriptors) {
            FileOpener.Editor[] editors = new FileOpener.Editor[descriptors.length];
            int i = 0;
            while (i < editors.length) {
                editors[i] = new FileOpener.Editor(descriptors[i]);
                ++i;
            }
            return editors;
        }

        private String[] loadExecutables() {
            IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
            return (String[])PreferenceInitializer.split(store.getString("EXTERNAL_EDITORS"), ",", String.class);
        }

        private void saveExecutables() {
            IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
            store.setValue("EXTERNAL_EDITORS", PreferenceInitializer.join(this.getExternalEditors().toArray(), ","));
        }

        private void updateButtons() {
            boolean empty = this.fTableViewer.getSelection().isEmpty();
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(!empty);
            }
            this.fAddAction.setEnabled(this.fAddButton.isEnabled());
            this.fEditAction.setEnabled(this.fAddButton.isEnabled() && !empty);
            this.fRemoveAction.setEnabled(this.fAddButton.isEnabled() && !empty);
        }

        private void handleExternalButtonSelected(Button button) {
            this.fTableViewer.setInput((Object)this.getExternalEditors());
            this.fAddAction.setEnabled(true);
            this.fEditAction.setEnabled(true);
            this.fRemoveAction.setEnabled(true);
            this.fAddButton.setEnabled(true);
            previouslySelectedRadio = button.getText();
            this.updateButtons();
        }

        private void handleInternalButtonSelected(Button button) {
            this.fTableViewer.setInput(this.getInternalEditors());
            this.fAddAction.setEnabled(false);
            this.fEditAction.setEnabled(false);
            this.fRemoveAction.setEnabled(false);
            this.fAddButton.setEnabled(false);
            previouslySelectedRadio = button.getText();
            this.updateButtons();
        }

        private void handleAddButtonSelected() {
            this.addNewEditor();
        }

        private void addNewEditor() {
            EditDialog dialog = new EditDialog(new FileOpener.Editor(null, null));
            if (dialog.open() == 0) {
                this.addExternalEditor(dialog.getEditor());
            }
        }

        private void addExternalEditor(FileOpener.Editor editor) {
            this.getExternalEditors().add(editor);
            this.fTableViewer.refresh();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)editor));
        }

        public Object getSelection() {
            return this.fSelection;
        }

        protected void computeResult() {
            this.fSelection = ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
            this.saveExecutables();
        }

        private class AddAction
        extends Action {
            private AddAction() {
                super(ActionMessages.getString("OpenWithMenu.18"));
            }

            public void run() {
                ExecutableSelectionDialog.this.addNewEditor();
            }
        }

        private class EditAction
        extends Action {
            private EditAction() {
                super(ActionMessages.getString("OpenWithMenu.12"));
            }

            public void run() {
                EditDialog dialog = new EditDialog((FileOpener.Editor)((IStructuredSelection)ExecutableSelectionDialog.this.fTableViewer.getSelection()).getFirstElement());
                if (dialog.open() == 0) {
                    ExecutableSelectionDialog.this.fTableViewer.refresh();
                }
            }
        }

        private class EditDialog
        extends SelectionDialog {
            private FileOpener.Editor fEditor;
            private Text fLabel;
            private Text fPath;
            private Button fBrowse;

            private EditDialog(FileOpener.Editor editor) {
                super(ExecutableSelectionDialog.this.getShell());
                this.setShellStyle(this.getShellStyle() | 0x10);
                this.fEditor = editor;
                this.setTitle(ActionMessages.getString("OpenWithMenu.16"));
            }

            protected Control createDialogArea(Composite parent) {
                Composite control = (Composite)super.createDialogArea(parent);
                ((GridLayout)control.getLayout()).numColumns = 2;
                Label label = new Label(control, 16384);
                label.setText(ActionMessages.getString("OpenWithMenu.14"));
                this.fLabel = this.createText(control, this.fEditor.getLabel());
                label = new Label(control, 16384);
                label.setText(ActionMessages.getString("OpenWithMenu.15"));
                this.fPath = this.createText(control, this.fEditor.getPath());
                new ContentAssistCommandAdapter((Control)this.fPath, (IControlContentAdapter)new TextContentAdapter(), new IContentProposalProvider(){

                    public IContentProposal[] getProposals(String contents, int position) {
                        return EditDialog.this.doGetProposals(contents, position);
                    }
                }, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
                this.fBrowse = new Button(control, 8);
                this.fBrowse.setText(ActionMessages.getString("OpenWithMenu.19"));
                this.fBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditDialog.this.handleBrowseSelected();
                    }
                });
                EditDialog.applyDialogFont((Control)control);
                return control;
            }

            private Text createText(Composite parent, String string) {
                Text text = new Text(parent, 2048);
                if (string != null) {
                    text.setText(string);
                }
                GridData data = new GridData(768);
                data.widthHint = this.convertWidthInCharsToPixels(20);
                text.setLayoutData((Object)data);
                return text;
            }

            protected void okPressed() {
                this.fEditor.setLabel(this.fLabel.getText());
                this.fEditor.setPath(this.fPath.getText());
                super.okPressed();
            }

            public FileOpener.Editor getEditor() {
                return this.fEditor;
            }

            private void handleBrowseSelected() {
                String selectedFile;
                FileDialog dialog = new FileDialog(this.getShell(), 4096);
                if (ExecutableSelectionDialog.this.fLastFilterPath != null) {
                    dialog.setFilterPath(ExecutableSelectionDialog.this.fLastFilterPath);
                }
                if ((selectedFile = dialog.open()) == null) {
                    return;
                }
                int lastPoint = selectedFile.lastIndexOf(46);
                int lastSlash = selectedFile.lastIndexOf(47);
                if (lastSlash == -1) {
                    lastSlash = selectedFile.lastIndexOf(92);
                }
                String label = selectedFile.substring(lastSlash + 1, lastPoint != -1 ? lastPoint : selectedFile.length());
                if (this.fLabel.getText().length() == 0) {
                    this.fLabel.setText(label);
                }
                this.fPath.setText(selectedFile);
            }

            private IContentProposal[] doGetProposals(String contents, int position) {
                String all = ActionMessages.getString("OpenWithMenu.17");
                StringTokenizer st = new StringTokenizer(all, "\n");
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                while (st.hasMoreElements()) {
                    String entry = st.nextToken();
                    StringTokenizer tst = new StringTokenizer(entry, " ");
                    String value = tst.nextToken();
                    int wordoffset = contents.lastIndexOf(32, position - 1) + 1;
                    if (wordoffset > position) {
                        wordoffset = position;
                    }
                    String word = contents.substring(wordoffset, position);
                    if (position >= 3 && contents.substring(position - 3).startsWith("$e")) {
                        TreeSet<IEditorDescriptor> set = new TreeSet<IEditorDescriptor>(new Comparator(){

                            public int compare(Object arg0, Object arg1) {
                                return ((IEditorDescriptor)arg0).getLabel().compareTo(((IEditorDescriptor)arg1).getLabel());
                            }
                        });
                        set.addAll(Arrays.asList(ExecutableSelectionDialog.this.getEditorsFromRegistry()));
                        IEditorDescriptor[] editors = set.toArray(new IEditorDescriptor[set.size()]);
                        int i = 0;
                        while (i < editors.length) {
                            proposals.add(new ContentProposal(editors[i].getId(), editors[i].getLabel(), null));
                            ++i;
                        }
                        break;
                    }
                    if (!value.startsWith(word)) continue;
                    proposals.add(new ContentProposal(value.substring(word.length()), value, entry));
                }
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }

            private class ContentProposal
            implements IContentProposal {
                private String content;
                private String label;
                private String description;
                private int cursorPosition;

                public ContentProposal(String content, String label, String description) {
                    this.content = content;
                    this.label = label;
                    this.description = description;
                    this.cursorPosition = content.length();
                }

                public String getContent() {
                    return this.content;
                }

                public int getCursorPosition() {
                    return this.cursorPosition;
                }

                public String getLabel() {
                    return this.label;
                }

                public String getDescription() {
                    return this.description;
                }
            }
        }

        private class EditorDescriptorLabelProvider
        extends LabelProvider {
            private EditorDescriptorLabelProvider() {
            }

            public String getText(Object element) {
                if (!(element instanceof FileOpener.Editor)) {
                    return super.getText(element);
                }
                FileOpener.Editor editor = (FileOpener.Editor)element;
                return editor.getDescriptor() != null ? editor.getDescriptor().getLabel() : editor.getLabel();
            }

            public Image getImage(Object element) {
                if (!(element instanceof FileOpener.Editor)) {
                    return super.getImage(element);
                }
                FileOpener.Editor editor = (FileOpener.Editor)element;
                return editor.getDescriptor() != null ? ZipEditorPlugin.getImage(editor.getDescriptor().getImageDescriptor()) : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
        }

        private class RemoveAction
        extends Action {
            private RemoveAction() {
                super(ActionMessages.getString("OpenWithMenu.13"));
            }

            public void run() {
                Object selectedEditor = ((IStructuredSelection)ExecutableSelectionDialog.this.fTableViewer.getSelection()).getFirstElement();
                ExecutableSelectionDialog.this.getExternalEditors().remove(selectedEditor);
                IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
                ArrayList<FileOpener.Editor> editors = new ArrayList<FileOpener.Editor>(Arrays.asList((FileOpener.Editor[])PreferenceInitializer.split(store.getString("recentlyUsedEditors"), ",", FileOpener.Editor.class)));
                editors.remove(selectedEditor);
                store.setValue("recentlyUsedEditors", PreferenceInitializer.join(editors.toArray(), ","));
                ExecutableSelectionDialog.this.fTableViewer.refresh();
            }
        }
    }
}

