/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWText;
import org.mihalis.opal.utils.StringUtil;

public class PWFloatText
extends PWText {
    public PWFloatText(String label, String propertyKey) {
        super(label, propertyKey);
    }

    @Override
    public void addVerifyListeners() {
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.character != '\u0000' && !Character.isDigit(e.character) && e.keyCode != 8 && e.keyCode != 127 && e.character != '.' && e.character != ',') {
                    e.doit = false;
                    return;
                }
                e.doit = PWFloatText.this.verifyEntry(e.text, e.keyCode);
            }
        });
    }

    private boolean verifyEntry(String entry, int keyCode) {
        String work = keyCode == 127 ? StringUtil.removeCharAt(this.text.getText(), this.text.getCaretPosition()) : (keyCode == 8 && this.text.getCaretPosition() == 0 ? StringUtil.removeCharAt(this.text.getText(), this.text.getCaretPosition() - 1) : (keyCode == 0 ? entry : StringUtil.insertString(this.text.getText(), entry, this.text.getCaretPosition())));
        try {
            Double.parseDouble(work.replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), new Float(0.0f));
        } else if (!(value instanceof Float)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a Float because it is associated to a float text widget");
        }
    }

    @Override
    public Object convertValue() {
        return Float.valueOf(Float.parseFloat(this.text.getText()));
    }

    @Override
    public int getStyle() {
        return 0;
    }
}

