/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.autoemul.DeviceCliManager;
import org.tizen.common.autoemul.DeviceEntry;
import org.tizen.common.autoemul.DeviceVMSXmlManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class DeviceEntryManager {
    protected static final Logger logger = LoggerFactory.getLogger(DeviceEntryManager.class);
    protected static final ArrayList<DeviceEntry> newDeviceEntryList = new ArrayList();
    protected static ArrayList<DeviceEntry> oldDeviceEntryList = new ArrayList();
    public static DeviceEntryManager deviceEntryManager = null;
    protected static DeviceCliManager deviceCliManager = null;
    protected DeviceVMSXmlManager deviceXmlManager = null;
    public static String DeviceInfoOnConfiguration = null;

    private DeviceEntryManager() {
    }

    public static DeviceEntryManager getDeviceEntryManager() {
        if (deviceEntryManager == null) {
            deviceEntryManager = new DeviceEntryManager();
        }
        return deviceEntryManager;
    }

    public static ArrayList<DeviceEntry> getOldDeviceList() {
        return oldDeviceEntryList;
    }

    public static boolean doUpdateDeviceList() {
        boolean isUpdate = false;
        ArrayList<DeviceEntry> newList = deviceEntryManager.getDeviceEntryListFromXML();
        if (newList.size() != oldDeviceEntryList.size()) {
            isUpdate = true;
            DeviceEntryManager.saveNewList2OldList(newList);
            return isUpdate;
        }
        if (newList.size() == 0 && oldDeviceEntryList.size() == 0) {
            isUpdate = false;
            return isUpdate;
        }
        ArrayList<DeviceEntry> tempList = new ArrayList<DeviceEntry>();
        tempList.addAll(newList);
        Collections.sort(tempList, DeviceEntry.DeviceEntryComparator);
        Collections.sort(oldDeviceEntryList, DeviceEntry.DeviceEntryComparator);
        tempList.removeAll(oldDeviceEntryList);
        if (tempList.size() == 0) {
            return isUpdate;
        }
        isUpdate = true;
        DeviceEntryManager.saveNewList2OldList(newList);
        return isUpdate;
    }

    private static boolean checkChaingOnOffnewDeviceStatus() {
        IDevice[] devices;
        boolean isChaingDeviceStatus = false;
        IDevice[] iDeviceArray = devices = SmartDevelopmentBridge.getBridge().getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice id = iDeviceArray[n2];
            for (DeviceEntry de : newDeviceEntryList) {
                if (!id.getDeviceName().equals(de.getEntryName())) continue;
                de.setEntryStatus("On");
                isChaingDeviceStatus = true;
            }
            ++n2;
        }
        return isChaingDeviceStatus;
    }

    public int getIndexFromName(String latestDeviceInfo) {
        int i = 0;
        while (i < oldDeviceEntryList.size()) {
            DeviceEntry entry = oldDeviceEntryList.get(i);
            if (latestDeviceInfo.equals(entry.getEntryName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setHighlightListener(Shell shell, final Table table) {
        final Color backGround1 = shell.getDisplay().getSystemColor(31);
        final Color backGround2 = shell.getDisplay().getSystemColor(31);
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = table.getClientArea().width;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(backGround1);
                gc.setBackground(backGround2);
                gc.fillGradientRectangle(0, event.y, clientWidth, event.height, false);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
    }

    public boolean runEmulatorManager() {
        deviceCliManager = new DeviceCliManager();
        int status = -1;
        try {
            status = deviceCliManager.executeEmulManagerCommand();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (status == 0) {
            return true;
        }
        if (2 == status) {
            return false;
        }
        return false;
    }

    public static boolean runDeviceAndResult(String emulatorName) {
        deviceCliManager = new DeviceCliManager();
        int status = -1;
        try {
            status = deviceCliManager.executeLaunchEmulCliCommand("launch -n " + emulatorName);
        }
        catch (InterruptedException e) {
            logger.error("fail to launch emulator by using cli", (Throwable)e);
        }
        if (status == 0) {
            return true;
        }
        if (2 == status) {
            return false;
        }
        return false;
    }

    @Deprecated
    public ArrayList<DeviceEntry> getDeviceEntryListFromCLI() {
        deviceCliManager = new DeviceCliManager();
        ArrayList<String> result = deviceCliManager.executeListVmCliCommand("list-vm");
        int i = 0;
        while (i < result.size()) {
            newDeviceEntryList.add(new DeviceEntry.Builder(result.get(i)).entryResolution("2").entryStatus("off").build());
            ++i;
        }
        return newDeviceEntryList;
    }

    private ArrayList<DeviceEntry> getDeviceEntryListFromXML() {
        this.newDeviceEntryListClear();
        Map<String, List<String>> m = DeviceVMSXmlManager.getVMSDetailInformation();
        if (!m.isEmpty()) {
            Set<String> keySet = m.keySet();
            for (String keyName : keySet) {
                List<String> list = m.get(keyName);
                newDeviceEntryList.add(new DeviceEntry.Builder(keyName).entryResolution(String.valueOf(list.get(0)) + "X" + list.get(1)).entryStatus("Off").build());
            }
        }
        this.updateOnOffnewDevice();
        return newDeviceEntryList;
    }

    private void updateOnOffnewDevice() {
        DeviceEntryManager.checkChaingOnOffnewDeviceStatus();
    }

    public ArrayList<DeviceEntry> getNewDeviceEntryListFromXML() {
        ArrayList<DeviceEntry> newList = this.getDeviceEntryListFromXML();
        DeviceEntryManager.saveNewList2OldList(newList);
        return oldDeviceEntryList;
    }

    public static boolean checkAvailableDevice(String name) {
        ArrayList<DeviceEntry> deviceList = deviceEntryManager.getNewDeviceEntryListFromXML();
        if (deviceList.size() != 0) {
            for (DeviceEntry de : deviceList) {
                if (!name.equals(de.getEntryName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void saveNewList2OldList(ArrayList<DeviceEntry> newList) {
        DeviceEntryManager.oldDeviceEntryListClear();
        oldDeviceEntryList = new ArrayList<DeviceEntry>(newList);
    }

    public void newDeviceEntryListClear() {
        newDeviceEntryList.clear();
    }

    public static void oldDeviceEntryListClear() {
        oldDeviceEntryList.clear();
    }
}

