/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.wizard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.ui.dialog.CertificateCreationWizardDialog;
import org.tizen.common.sign.ui.dialog.NewProfileNotificationDialog;
import org.tizen.common.sign.ui.wizard.AuthorCertCreationPage;
import org.tizen.common.sign.ui.wizard.AuthorCertImportPage;
import org.tizen.common.sign.ui.wizard.AuthorCertSelectionPage;
import org.tizen.common.sign.ui.wizard.CertificateBaseWizardPage;
import org.tizen.common.sign.ui.wizard.DistributorCertImportPage;
import org.tizen.common.sign.ui.wizard.DistributorCertSelectionPage;
import org.tizen.common.sign.ui.wizard.Messages;
import org.tizen.common.sign.ui.wizard.ProfileCreationPage;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.IOUtil;

public class CertificateCreationWizard
extends Wizard
implements IPageChangedListener {
    private static final String PROFILE_CREATION_PAGE = "p1";
    private static final String AUTHOR_CERT_SELECTION_PAGE = "p2";
    private static final String AUTHOR_CERT_CREATION_PAGE = "p3";
    private static final String AUTHOR_CERT_IMPORT_PAGE = "p4";
    private static final String DIST_CERT_SELECTION_PAGE = "p5";
    private static final String DIST_CERT_IMPORT_PAGE = "p6";
    private static final String EXE_PATH = Paths.get(InstallPathConfig.getToolsPath(), "certificate-generator", "KeyCertGeneratorApi.jar").toString();
    private static final String JAVA = InstallPathConfig.getJava();
    private static final String FLAG = "-jar";
    private static final String SUCCESS_CONDITION = "Certificate generated successfully";
    private static final String COUNTRY = "--country";
    private static final String STATE = "--state";
    private static final String CITY = "--city";
    private static final String COMMONNAME = "--commonname";
    private static final String ORGANIZATION = "--organization";
    private static final String UNIT = "--unit";
    private static final String EMAIL = "--email";
    private static final String CERTGEN = "--certgen";
    private static final String PASSWORD = "--password";
    private static final String ALIAS = "--alias";
    private static final String KEYSTORE = "--keystore";
    private static final int CERTIFICATE_PROFILE_NAVI_IDX = 0;
    private static final int AUTHOR_CERTIFICATE_NAVI_IDX = 1;
    private static final int DISTRIBUTOR_CERTIFICATE_NAVI_IDX = 2;
    private boolean bCanFinish = false;
    private boolean isFirstProfile = false;
    private ProfileCreationPage profileCreationPage;
    private AuthorCertSelectionPage authCertSelectionPage;
    private AuthorCertCreationPage authCertCreationPage;
    private AuthorCertImportPage authCertImportPage;
    private DistributorCertSelectionPage distCertSelectionPage;
    private DistributorCertImportPage distCertImportPage;
    private CertificateCreationWizardDialog wizardDialog;
    protected SigningProfileContainer container = SigningProfileUtil.getProfileContainerFromFile();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void addPages() {
        this.profileCreationPage = new ProfileCreationPage(PROFILE_CREATION_PAGE);
        this.profileCreationPage.setNavigationIndex(0);
        this.authCertSelectionPage = new AuthorCertSelectionPage(AUTHOR_CERT_SELECTION_PAGE);
        this.authCertSelectionPage.setNavigationIndex(1);
        this.addPage((IWizardPage)this.profileCreationPage);
        this.addPage((IWizardPage)this.authCertSelectionPage);
        this.wizardDialog = (CertificateCreationWizardDialog)this.getContainer();
        this.wizardDialog.addPageChangedListener(this);
        this.wizardDialog.setNavigationString(new String[]{Messages.CERT_PROFILE_CREATE_STEP1, Messages.CERT_PROFILE_CREATE_STEP2, Messages.CERT_PROFILE_CREATE_STEP3});
    }

    public String getWindowTitle() {
        return Messages.CERT_WIZARD_TITLE;
    }

    public boolean canFinish() {
        return this.bCanFinish;
    }

    public void setCanFinish(boolean b) {
        this.bCanFinish = b;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.authCertSelectionPage) {
            if (this.authCertSelectionPage.isSelectedNewCreation()) {
                if (this.authCertCreationPage == null) {
                    this.authCertCreationPage = new AuthorCertCreationPage(AUTHOR_CERT_CREATION_PAGE);
                    this.authCertCreationPage.setNavigationIndex(1);
                    this.addPage((IWizardPage)this.authCertCreationPage);
                }
                return this.authCertCreationPage;
            }
            if (this.authCertImportPage == null) {
                this.authCertImportPage = new AuthorCertImportPage(AUTHOR_CERT_IMPORT_PAGE);
                this.authCertImportPage.setNavigationIndex(1);
                this.addPage((IWizardPage)this.authCertImportPage);
            }
            return this.authCertImportPage;
        }
        if (page == this.authCertCreationPage || page == this.authCertImportPage) {
            if (this.distCertSelectionPage == null) {
                this.distCertSelectionPage = new DistributorCertSelectionPage(DIST_CERT_SELECTION_PAGE);
                this.distCertSelectionPage.setNavigationIndex(2);
                this.addPage((IWizardPage)this.distCertSelectionPage);
            }
            return this.distCertSelectionPage;
        }
        if (page == this.distCertSelectionPage && this.distCertSelectionPage.isSelectedAnother()) {
            if (this.distCertImportPage == null) {
                this.distCertImportPage = new DistributorCertImportPage(DIST_CERT_IMPORT_PAGE);
                this.distCertImportPage.setNavigationIndex(2);
                this.addPage((IWizardPage)this.distCertImportPage);
            }
            return this.distCertImportPage;
        }
        return super.getNextPage(page);
    }

    public boolean performCancel() {
        int result = DialogUtil.openQuestionDialog((String)Messages.CERT_WIZARD_TITLE, (String)Messages.CERT_WIZARD_CANCEL);
        return result == 64;
    }

    private boolean checkValid(String attr) {
        return attr != null && !attr.trim().isEmpty();
    }

    private ArrayList<String> makeCommandLineArgs(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(JAVA);
        cmdArgs.add(FLAG);
        cmdArgs.add(EXE_PATH);
        if (this.checkValid(countryName)) {
            cmdArgs.add(COUNTRY);
            cmdArgs.add(countryName.trim());
        }
        if (this.checkValid(stateName)) {
            cmdArgs.add(STATE);
            cmdArgs.add(stateName.trim());
        }
        if (this.checkValid(cityName)) {
            cmdArgs.add(CITY);
            cmdArgs.add(cityName.trim());
        }
        if (this.checkValid(commonName)) {
            cmdArgs.add(COMMONNAME);
            cmdArgs.add(commonName.trim());
        }
        if (this.checkValid(organizationName)) {
            cmdArgs.add(ORGANIZATION);
            cmdArgs.add(organizationName.trim());
        }
        if (this.checkValid(orgUnitName)) {
            cmdArgs.add(UNIT);
            cmdArgs.add(orgUnitName.trim());
        }
        if (this.checkValid(emailId)) {
            cmdArgs.add(EMAIL);
            cmdArgs.add(emailId.trim());
        }
        if (this.checkValid(certGenDirPath)) {
            cmdArgs.add(CERTGEN);
            cmdArgs.add(certGenDirPath.trim());
        }
        if (this.checkValid(password)) {
            cmdArgs.add(PASSWORD);
            cmdArgs.add(password.trim());
        }
        if (this.checkValid(alias)) {
            cmdArgs.add(ALIAS);
            cmdArgs.add(alias.trim());
        }
        if (this.checkValid(pkcsKeyStorePath)) {
            cmdArgs.add(KEYSTORE);
            cmdArgs.add(pkcsKeyStorePath.trim());
        }
        return cmdArgs;
    }

    private boolean generateSignedCertificate(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) throws Exception {
        ArrayList<String> command = this.makeCommandLineArgs(countryName, stateName, cityName, commonName, organizationName, orgUnitName, emailId, certGenDirPath, password, alias, pkcsKeyStorePath);
        String line = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                ProcessBuilder builder = new ProcessBuilder(command);
                Process process = builder.start();
                inputStream = process.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                line = bufferedReader.readLine();
            }
            catch (IOException ioe) {
                this.logger.error("Failed to create author certificate.", (Throwable)ioe);
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bufferedReader});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bufferedReader});
        return line != null && line.startsWith(SUCCESS_CONDITION);
    }

    public boolean performFinish() {
        String distPassword;
        String distKeyPath;
        String email;
        String department;
        String organization;
        String city;
        String state;
        String country;
        String password;
        String userName;
        String keyFilename;
        String authorPassword;
        String authorKeyPath;
        final boolean isNewAuthor = this.authCertSelectionPage.isSelectedNewCreation();
        final boolean isImportDist = this.distCertSelectionPage.isSelectedAnother();
        final String profileName = this.profileCreationPage.getProfileName();
        if (!isNewAuthor) {
            authorKeyPath = this.authCertImportPage.getCertPath();
            authorPassword = this.authCertImportPage.getPassword();
            keyFilename = null;
            userName = null;
            password = null;
            country = null;
            state = null;
            city = null;
            organization = null;
            department = null;
            email = null;
        } else {
            authorKeyPath = null;
            authorPassword = null;
            keyFilename = this.authCertCreationPage.getKeyfilename();
            userName = this.authCertCreationPage.getUsername();
            password = this.authCertCreationPage.getPassword();
            country = this.authCertCreationPage.getCountry();
            state = this.authCertCreationPage.getState();
            city = this.authCertCreationPage.getCity();
            organization = this.authCertCreationPage.getOrganization();
            department = this.authCertCreationPage.getDepartment();
            email = this.authCertCreationPage.getEmail();
        }
        if (isImportDist) {
            distKeyPath = this.distCertImportPage.getCertPath();
            distPassword = this.distCertImportPage.getPassword();
        } else {
            distKeyPath = null;
            distPassword = null;
        }
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.PROGRESS_CREATE_CERT_PROFILE, 4);
                    SigningProfile profile = new SigningProfile(profileName);
                    profile.createEmptyProfileItem(0);
                    monitor.worked(1);
                    if (isNewAuthor) {
                        monitor.setTaskName(Messages.PROGRESS_CREATE_AUTHOR_CERT);
                        String pkcsKeyStorePath = SigningPathUtil.getAuthorKeyStorePath((String)keyFilename);
                        try {
                            if (!CertificateCreationWizard.this.generateSignedCertificate(country, state, city, userName, organization, department, email, SigningPathUtil.getCertificateGeneratorPath(), password, userName, pkcsKeyStorePath)) {
                                CertificateCreationWizard.this.logger.error("Failed to create author certificate.");
                                throw new Exception("Failed to create author certificate.");
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                        SigningProfileItem item = profile.getAuthorProfileItem();
                        item.setKeyLocation(pkcsKeyStorePath);
                        item.setPassword(password.toCharArray());
                    } else {
                        monitor.setTaskName(Messages.PROGRESS_IMPORT_AUTHOR_CERT);
                        SigningProfileItem item = profile.getAuthorProfileItem();
                        item.setKeyLocation(authorKeyPath);
                        item.setPassword(authorPassword.toCharArray());
                    }
                    monitor.worked(1);
                    if (isImportDist) {
                        monitor.setTaskName(Messages.PROGRESS_IMPORT_DIST_CERT);
                        profile.createProfileItem(1, distKeyPath, distPassword, "", "");
                    } else if (CertificateCreationWizard.this.distCertSelectionPage.isPartnerSelected()) {
                        profile.createProfileItemForPartnerDeveloper();
                    } else {
                        profile.createProfileItemForDeveloper();
                    }
                    profile.createEmptyProfileItem(2);
                    monitor.worked(1);
                    CertificateCreationWizard.this.isFirstProfile = CertificateCreationWizard.this.container.getActiveProfile() == null && CertificateCreationWizard.this.container.getProfiles().isEmpty();
                    CertificateCreationWizard.this.container.addProfile(profile);
                    SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)CertificateCreationWizard.this.container);
                    CertificateCreationWizard.this.logger.trace("New certificate profile is saved");
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Failed to create a new certificate profile", (Throwable)e);
            return false;
        }
        NewProfileNotificationDialog createdDlg = new NewProfileNotificationDialog(this.getShell(), this.isFirstProfile);
        createdDlg.open();
        if (createdDlg.isSetActive()) {
            SigningProfileUtil.setActiveProfileName((String)profileName);
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public void pageChanged(PageChangedEvent event) {
        CertificateBaseWizardPage page = (CertificateBaseWizardPage)((Object)event.getSelectedPage());
        this.wizardDialog.setNavigatorCurrentPage(page.getNavigationIndex());
        this.wizardDialog.redrawNavigator();
        if (page == this.distCertImportPage) {
            this.distCertImportPage.validate();
        } else if (page == this.distCertSelectionPage) {
            this.distCertSelectionPage.validate();
        }
    }
}

