/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.utils.HTMLStyledTextParser;

public class SWTGraphicUtil {
    private SWTGraphicUtil() {
    }

    public static void dispose(Control control, final Resource r) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose(r);
            }
        });
    }

    public static void dispose(Resource r) {
        if (r != null && !r.isDisposed()) {
            r.dispose();
        }
    }

    public static Image createImage(String fileName) {
        return new Image((Device)Display.getCurrent(), SWTGraphicUtil.class.getClassLoader().getResourceAsStream(fileName));
    }

    public static Image createReflectedImage(Image source) {
        if (source == null) {
            return null;
        }
        if (source.isDisposed()) {
            SWT.error((int)24);
        }
        Rectangle sourceBounds = source.getBounds();
        Image newImage = new Image(source.getDevice(), new Rectangle(0, 0, sourceBounds.width, (int)((double)sourceBounds.height * 1.5)));
        GC gc = new GC((Drawable)newImage);
        gc.setAdvanced(true);
        gc.drawImage(source, 0, 0);
        Transform t = new Transform(source.getDevice());
        t.setElements(1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)(sourceBounds.height + sourceBounds.height / 2));
        gc.setTransform(t);
        gc.drawImage(source, 0, 0);
        t.dispose();
        gc.dispose();
        ImageData imgData = newImage.getImageData();
        int width = imgData.width;
        int height = imgData.height;
        byte[] alphaData = new byte[height * width];
        byte[] noAlpha = new byte[width];
        int x = 0;
        while (x < width) {
            noAlpha[x] = -1;
            ++x;
        }
        int y = 0;
        while (y < height) {
            byte[] alphaRow = new byte[width];
            if (y < sourceBounds.height) {
                System.arraycopy(noAlpha, 0, alphaData, y * width, width);
            } else {
                int x2 = 0;
                while (x2 < width) {
                    alphaRow[x2] = (byte)(255 - 255 * y / height);
                    ++x2;
                }
                System.arraycopy(alphaRow, 0, alphaData, y * width, width);
            }
            ++y;
        }
        imgData.alphaData = alphaData;
        return new Image(source.getDevice(), imgData);
    }

    public static Image resize(Image source, int newWidth, int newHeight) {
        if (source == null) {
            return null;
        }
        if (source.isDisposed()) {
            SWT.error((int)24);
        }
        Image scaledImage = new Image(source.getDevice(), newWidth, newHeight);
        GC gc = new GC((Drawable)scaledImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, newWidth, newHeight);
        gc.dispose();
        return scaledImage;
    }

    public static Image createReflectedResizedImage(Image source, int newWidth, int newHeight) {
        if (source == null) {
            return null;
        }
        if (source.isDisposed()) {
            SWT.error((int)24);
        }
        Image newImage = new Image(source.getDevice(), newWidth, (int)((double)newHeight * 1.5));
        GC gc = new GC((Drawable)newImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, newWidth, newHeight);
        Transform t = new Transform(source.getDevice());
        t.setElements(1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)((double)newHeight * 1.5));
        gc.setTransform(t);
        gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, newWidth, newHeight);
        t.dispose();
        gc.dispose();
        ImageData imgData = newImage.getImageData();
        int width = imgData.width;
        int height = imgData.height;
        byte[] alphaData = new byte[height * width];
        byte[] noAlpha = new byte[width];
        int x = 0;
        while (x < width) {
            noAlpha[x] = -1;
            ++x;
        }
        int y = 0;
        while (y < height) {
            byte[] alphaRow = new byte[width];
            if (y < newHeight) {
                System.arraycopy(noAlpha, 0, alphaData, y * width, width);
            } else {
                int x2 = 0;
                while (x2 < width) {
                    alphaRow[x2] = (byte)(255 - 255 * y / height);
                    ++x2;
                }
                System.arraycopy(alphaRow, 0, alphaData, y * width, width);
            }
            ++y;
        }
        imgData.alphaData = alphaData;
        return new Image(source.getDevice(), imgData);
    }

    public static void centerShell(Shell shell) {
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    public static void applyHTMLFormating(StyledText styledText) {
        try {
            new HTMLStyledTextParser(styledText).parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ImageData blur(ImageData originalImageData, int radius) {
        if (radius < 1) {
            return originalImageData;
        }
        ImageData newImageData = new ImageData(originalImageData.width, originalImageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
        if (radius >= newImageData.height || radius >= newImageData.width) {
            radius = Math.min(newImageData.height, newImageData.width) - 1;
        }
        ArrayList<RGB[]> rowCache = new ArrayList<RGB[]>();
        int cacheSize = radius * 2 + 1 > newImageData.height ? newImageData.height : radius * 2 + 1;
        int cacheStartIndex = 0;
        int row = 0;
        while (row < cacheSize) {
            rowCache.add(rowCache.size(), SWTGraphicUtil.blurRow(originalImageData, row, radius));
            ++row;
        }
        RGB[] rowRGBSums = new RGB[newImageData.width];
        int[] rowRGBAverages = new int[newImageData.width];
        int topSumBoundary = 0;
        int targetRow = 0;
        int bottomSumBoundary = 0;
        int numRows = 0;
        int i = 0;
        while (i < newImageData.width) {
            rowRGBSums[i] = new RGB(0, 0, 0);
            ++i;
        }
        while (targetRow < newImageData.height) {
            int col;
            if (bottomSumBoundary < newImageData.height) {
                do {
                    col = 0;
                    while (col < newImageData.width) {
                        rowRGBSums[col].red += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].red;
                        rowRGBSums[col].green += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].green;
                        rowRGBSums[col].blue += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].blue;
                        ++col;
                    }
                    ++numRows;
                    if (++bottomSumBoundary >= newImageData.height || bottomSumBoundary - cacheStartIndex <= radius * 2) continue;
                    rowCache.add(rowCache.size(), SWTGraphicUtil.blurRow(originalImageData, bottomSumBoundary, radius));
                } while (bottomSumBoundary <= radius);
            }
            if (targetRow - topSumBoundary > radius) {
                col = 0;
                while (col < newImageData.width) {
                    rowRGBSums[col].red -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].red;
                    rowRGBSums[col].green -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].green;
                    rowRGBSums[col].blue -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].blue;
                    ++col;
                }
                --numRows;
                ++topSumBoundary;
                rowCache.remove(0);
                ++cacheStartIndex;
            }
            col = 0;
            while (col < newImageData.width) {
                rowRGBAverages[col] = newImageData.palette.getPixel(new RGB(rowRGBSums[col].red / numRows, rowRGBSums[col].green / numRows, rowRGBSums[col].blue / numRows));
                ++col;
            }
            newImageData.setPixels(0, targetRow, newImageData.width, rowRGBAverages, 0);
            ++targetRow;
        }
        return newImageData;
    }

    private static RGB[] blurRow(ImageData originalImageData, int row, int radius) {
        RGB[] rowRGBAverages = new RGB[originalImageData.width];
        int[] lineData = new int[originalImageData.width];
        originalImageData.getPixels(0, row, originalImageData.width, lineData, 0);
        int r = 0;
        int g = 0;
        int b = 0;
        int leftSumBoundary = 0;
        int targetColumn = 0;
        int rightSumBoundary = 0;
        int numCols = 0;
        while (targetColumn < lineData.length) {
            RGB rgb;
            if (rightSumBoundary < lineData.length) {
                do {
                    rgb = originalImageData.palette.getRGB(lineData[rightSumBoundary]);
                    r += rgb.red;
                    g += rgb.green;
                    b += rgb.blue;
                    ++numCols;
                } while (++rightSumBoundary <= radius);
            }
            if (targetColumn - leftSumBoundary > radius) {
                rgb = originalImageData.palette.getRGB(lineData[leftSumBoundary]);
                r -= rgb.red;
                g -= rgb.green;
                b -= rgb.blue;
                --numCols;
                ++leftSumBoundary;
            }
            rowRGBAverages[targetColumn] = new RGB(r / numCols, g / numCols, b / numCols);
            ++targetColumn;
        }
        return rowRGBAverages;
    }

    public static void enable(Control control, boolean enable) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                SWTGraphicUtil.enable(c, enable);
                ++n2;
            }
        }
        control.setEnabled(enable);
    }

    public static Font buildFontFrom(Control control, int style) {
        Font temp = control.getFont();
        FontData[] fontData = temp.getFontData();
        if (fontData == null || fontData.length == 0) {
            return temp;
        }
        return new Font((Device)control.getDisplay(), fontData[0].getName(), fontData[0].getHeight(), style);
    }

    public static Font buildFontFrom(Control control, int style, int size) {
        Font temp = control.getFont();
        FontData[] fontData = temp.getFontData();
        if (fontData == null || fontData.length == 0) {
            return temp;
        }
        return new Font((Device)control.getDisplay(), fontData[0].getName(), size, style);
    }
}

