/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import zipeditor.model.Node;
import zipeditor.model.ZipModel;

public class ZipNode
extends Node {
    private String comment;
    private ZipEntry zipEntry;

    public ZipNode(ZipModel model, ZipEntry entry, String name, boolean isFolder) {
        this(model, name, isFolder);
        this.zipEntry = entry;
        if (entry != null) {
            this.time = entry.getTime();
            this.size = entry.getSize();
            this.comment = entry.getComment();
        }
    }

    public ZipNode(ZipModel model, String name, boolean isFolder) {
        super(model, name, isFolder);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (comment == this.comment || comment != null && comment.equals(this.comment)) {
            return;
        }
        this.comment = comment;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public byte[] getExtra() {
        return this.zipEntry != null && this.file == null && this.zipEntry.getExtra() != null ? this.zipEntry.getExtra() : new byte[]{};
    }

    public long getCrc() {
        return this.zipEntry != null && this.file == null ? this.zipEntry.getCrc() : 0L;
    }

    public long getCompressedSize() {
        return this.zipEntry != null && this.file == null ? this.zipEntry.getCompressedSize() : 0L;
    }

    public double getRatio() {
        return this.zipEntry != null && this.file == null ? (double)(this.zipEntry.getSize() - this.zipEntry.getCompressedSize()) / (double)this.zipEntry.getSize() * 100.0 : 0.0;
    }

    @Override
    protected InputStream doGetContent() throws IOException {
        InputStream in = super.doGetContent();
        if (in != null) {
            return in;
        }
        if (this.zipEntry != null) {
            return new EntryStream(this.zipEntry, this.model.getZipPath() != null ? new ZipFile(this.model.getZipPath()) : null);
        }
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.zipEntry != null) {
            this.time = this.zipEntry.getTime();
            this.size = this.zipEntry.getSize();
        }
    }

    @Override
    public void update(Object entry) {
        if (!(entry instanceof ZipEntry)) {
            return;
        }
        ZipEntry zipEntry = (ZipEntry)entry;
        this.time = zipEntry.getTime();
    }

    @Override
    public Node create(ZipModel model, String name, boolean isFolder) {
        return new ZipNode(model, name, isFolder);
    }

    private class EntryStream
    extends InputStream {
        private InputStream in;
        private ZipFile zipFile;

        private EntryStream(ZipEntry entry, ZipFile zipFile) throws IOException {
            this.in = zipFile.getInputStream(entry);
            this.zipFile = zipFile;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
    }
}

