/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.receiver;

import java.io.IOException;
import java.util.ArrayList;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.AbstractShellOutputReceiver;

public abstract class MultiLineReceiver
extends AbstractShellOutputReceiver
implements IShellOutputReceiver {
    protected boolean bTrimLines = true;
    protected static final int ST_NORMAL = 0;
    protected static final int ST_LINE_CANDIDATE = 1;
    protected int status = 0;
    private final ArrayList<String> lines = new ArrayList();
    protected final StringBuilder buffer = new StringBuilder();

    public MultiLineReceiver() {
        this(true);
    }

    public MultiLineReceiver(boolean bTrimLines) {
        this.bTrimLines = bTrimLines;
    }

    public void setTrimLines(boolean bTrimLines) {
        this.bTrimLines = bTrimLines;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.status == 0) {
            if ('\r' == c) {
                this.status = 1;
            } else if ('\n' == c) {
                String line = this.buffer.toString();
                if (this.bTrimLines) {
                    line = line.trim();
                }
                this.lines.add(line);
                this.buffer.delete(0, this.buffer.length());
                this.status = 0;
            } else {
                this.buffer.append(c);
            }
        } else if (1 == this.status) {
            if ('\n' == c) {
                String line = this.buffer.toString();
                if (this.bTrimLines) {
                    line = line.trim();
                }
                this.lines.add(line);
                this.buffer.delete(0, this.buffer.length());
                this.status = 0;
            } else if ('\r' == c) {
                this.buffer.append('\r');
            } else {
                this.buffer.append('\r');
                this.buffer.append(c);
                this.status = 0;
            }
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        Appendable ret = super.append(csq, start, end);
        this.flush();
        return ret;
    }

    @Override
    public void flush() throws IOException {
        if (this.lines.size() > 0) {
            this.processNewLines(this.lines.toArray(new String[this.lines.size()]));
            this.lines.clear();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.length() > 0) {
            this.lines.add(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
            this.flush();
        }
        super.close();
    }

    public abstract void processNewLines(String[] var1);
}

