/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Executor;
import org.tizen.common.sign.preferences.UIMessages;

public class SmartThingsSignatureGenerator {
    private static final String SMART_THINGS = "smartthings";
    private static final String PROFILE_FILE = ".activeprofile";
    private static final String CERT_STORE = "certstore";
    private static final String RES_FOLDER = "res";
    private static final String TPK_FOLDER = ".tpk";
    private static final String PEM_EXTENSION = ".pem";
    private static final String DER_EXTENSION = ".der";
    private static final String CERTIFICATE_FILE = "certificate";
    private static final String PRIVATEKEY_FILE = "privatekey";
    private static final String IOT_CERT_WARN_MSG = "org.tizen.common.sign.smartthings_profile_warn_msg";
    protected static final Logger logger = LoggerFactory.getLogger(SmartThingsSignatureGenerator.class);
    protected Executor executor = CommonPlugin.getDefault().getExecutor();
    private String projectPath;
    private String signDirectoryPath;

    public SmartThingsSignatureGenerator(String tpkPath) {
        this.projectPath = new File(tpkPath).getParentFile().getParentFile().getPath();
        this.signDirectoryPath = new File(tpkPath).getParentFile().getPath();
    }

    public void loadProfiles() {
        logger.trace("load profiles");
        String activeProfileName = null;
        activeProfileName = SmartThingsSignatureGenerator.getSmartThingsActiveProfileName();
        if (activeProfileName != null && !activeProfileName.isEmpty()) {
            this.copyCertificate(activeProfileName);
        } else {
            this.executor.getContext().getPrompter().notify(UIMessages.getString(IOT_CERT_WARN_MSG));
        }
    }

    private void copyCertificate(String activeProfileName) {
        File certStoreDirectory = new File(new Path(InstallPathConfig.getUserDataPath()).append(SMART_THINGS).append(CERT_STORE).toPortableString());
        if (certStoreDirectory != null) {
            File[] fileArray = certStoreDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File[] files;
                File certificate = fileArray[n2];
                if (certificate.getName().equals(activeProfileName) && (files = certificate.listFiles()) != null) {
                    File[] fileArray2 = files;
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray2[n4];
                        String fileName = file.getName();
                        String fileExtension = "";
                        if (fileName.equalsIgnoreCase(CERTIFICATE_FILE)) {
                            fileExtension = PEM_EXTENSION;
                        } else if (fileName.equalsIgnoreCase(PRIVATEKEY_FILE)) {
                            fileExtension = DER_EXTENSION;
                        }
                        try {
                            java.nio.file.Path destFile = Paths.get(new Path(this.projectPath).append(RES_FOLDER).append(String.valueOf(fileName) + fileExtension).toPortableString(), new String[0]);
                            java.nio.file.Path tpkFile = Paths.get(new Path(this.signDirectoryPath).append(TPK_FOLDER).append(RES_FOLDER).append(String.valueOf(fileName) + fileExtension).toPortableString(), new String[0]);
                            if (!destFile.getParent().toFile().exists()) {
                                Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                            }
                            Files.copy(file.toPath(), destFile, StandardCopyOption.REPLACE_EXISTING);
                            Files.copy(file.toPath(), tpkFile, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            logger.error(e.getLocalizedMessage());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public static String getSmartThingsActiveProfileName() {
        IPath path = new Path(InstallPathConfig.getUserDataPath()).append(SMART_THINGS).append(PROFILE_FILE);
        try {
            return new String(Files.readAllBytes(Paths.get(path.toPortableString(), new String[0]))).trim();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage());
            return "";
        }
    }
}

