/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IReferenceEnabled;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.ui.ObjectTransfer;
import org.tizen.common.rest.ui.dialogs.RestDialog;
import org.tizen.common.rest.ui.handlers.RESTDialogHandler;
import org.tizen.common.rest.ui.views.RestViewerContentProvider;
import org.tizen.common.rest.ui.views.RestViewerLabelProvider;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.rest.util.OutputUtil;
import org.tizen.common.util.SWTUtil;

public class RestViewer
extends ViewPart {
    public static final String ID = "org.tizen.common.rest.ui.views.RestViewer";
    private TreeViewer viewer;
    private Action doubleClickAction;
    protected Clipboard clipboard = null;

    public boolean validateSelection(IStructuredSelection selection) {
        List list = selection.toList();
        Iterator itor = selection.iterator();
        Application application = null;
        while (itor.hasNext()) {
            IWadlModel obj = (IWadlModel)itor.next();
            if (obj instanceof Application) {
                return false;
            }
            if (application == null) {
                application = obj.getRoot();
            } else if (!application.equals(obj.getRoot())) {
                return false;
            }
            ArrayList<IWadlModel> subList = new ArrayList<IWadlModel>(Arrays.asList(list.toArray(new IWadlModel[list.size()])));
            subList.remove(obj);
            if (list.size() <= 1 || !ModelUtil.isDecendentFrom(subList, obj)) continue;
            return false;
        }
        return true;
    }

    private void copyReference(IStructuredSelection selection, IRestUiModel target) throws JAXBException {
        for (IRestUiModel model : selection) {
            IReferenceEnabled refEnabled;
            IReferenceEnabled ref;
            if (!(model instanceof IReferenceEnabled) || (ref = ModelUtil.findReferences(refEnabled = (IReferenceEnabled)((Object)model))).equals(refEnabled)) continue;
            Application app = target.getRoot();
            List<IWadlModel> children = app.getResourceTypeOrMethodOrRepresentation();
            boolean duplicated = false;
            int i = 0;
            while (i < children.size()) {
                IWadlModel child = children.get(i);
                if (child instanceof IReferenceEnabled && ref.getId().equals(((IReferenceEnabled)child).getId())) {
                    duplicated = true;
                    break;
                }
                ++i;
            }
            if (duplicated) continue;
            IReferenceEnabled cloned = OutputUtil.clone(ref);
            app.addChild((IRestUiModel)((Object)cloned));
        }
    }

    private List<IRestUiModel> gatherModelToAdd(IStructuredSelection selection, IRestUiModel targetParent, int operation) {
        ArrayList<IRestUiModel> modelToAdd = new ArrayList<IRestUiModel>();
        Iterator itor = selection.iterator();
        if (targetParent != null) {
            while (itor.hasNext()) {
                IRestUiModel model = (IRestUiModel)itor.next();
                if (!targetParent.isVaildChild(model)) {
                    return Collections.emptyList();
                }
                if (1 == operation) {
                    try {
                        model = this.cloneModel(model);
                    }
                    catch (JAXBException e) {
                        RestPlugin.log(e);
                        return Collections.emptyList();
                    }
                }
                modelToAdd.add(model);
            }
        }
        return modelToAdd;
    }

    public boolean moveOn(IStructuredSelection selection, IRestUiModel target, int operation, int location) {
        boolean result = true;
        List<IRestUiModel> modelToAdd = null;
        IRestUiModel targetParent = null;
        if (location == 3) {
            modelToAdd = this.gatherModelToAdd(selection, target, operation);
        } else {
            targetParent = (IRestUiModel)target.getParent();
            modelToAdd = this.gatherModelToAdd(selection, targetParent, operation);
        }
        int i = 0;
        while (i < modelToAdd.size()) {
            IRestUiModel model = modelToAdd.get(i);
            IRestUiModel parent = (IRestUiModel)model.getParent();
            if (2 == operation) {
                parent.removeChild(model);
            }
            switch (location) {
                case 1: {
                    targetParent.insertBefore(model, target);
                    break;
                }
                case 2: {
                    targetParent.insertAfter(model, target);
                    break;
                }
                case 3: {
                    target.addChild(model);
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    private IRestUiModel cloneModel(IRestUiModel model) throws JAXBException {
        IRestUiModel cloned = OutputUtil.clone(model);
        return cloned;
    }

    public boolean validateTarget(Object target, IStructuredSelection selection, int location) {
        List list = selection.toList();
        if (ModelUtil.isDecendentFrom(list, (IWadlModel)target)) {
            return false;
        }
        IRestUiModel targetModel = (IRestUiModel)target;
        if (targetModel instanceof Method && 3 == location) {
            return false;
        }
        IRestUiModel parent = targetModel;
        if (3 != location) {
            parent = (IRestUiModel)targetModel.getParent();
        }
        if (parent != null) {
            for (IRestUiModel model : selection) {
                if (parent.isVaildChild(model)) continue;
                return false;
            }
        }
        return true;
    }

    public void createPartControl(Composite parent) {
        this.createContentArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.tizen.common.rest.viewer");
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeDoubleClickAction();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    public void dispose() {
        super.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null && this.getTreeViewer() != null && !this.getTreeViewer().getControl().isDisposed()) {
            this.clipboard = new Clipboard(SWTUtil.getDisplay());
        }
        return this.clipboard;
    }

    private void createContentArea(Composite composite) {
        this.viewer = new TreeViewer(composite, 770);
        this.viewer.setContentProvider((IContentProvider)new RestViewerContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new RestViewerLabelProvider(), decorator));
        this.viewer.setInput(RepositoryManager.getInstance().getApplications());
        this.viewer.addDragSupport(3, new Transfer[]{ObjectTransfer.getInstance()}, (DragSourceListener)new RestDragSourceListener(this.viewer));
        this.viewer.addDropSupport(3, new Transfer[]{ObjectTransfer.getInstance()}, (DropTargetListener)new RestDropTargetAdapter(this.viewer));
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void hookContextMenu() {
        this.activateContext();
    }

    private void makeDoubleClickAction() {
        this.doubleClickAction = new DoubleClickAction(this);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RestViewer.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.tizen.common.rest.new.service.context");
        contextService.activateContext("org.tizen.common.rest.new.child.context");
        contextService.activateContext("org.tizen.common.rest.modify.context");
        contextService.activateContext("org.tizen.common.rest.copy.context");
        contextService.activateContext("org.tizen.common.rest.paste.context");
        contextService.activateContext("org.tizen.common.rest.delete.context");
        contextService.activateContext("org.tizen.common.rest.import.wadl.context");
        contextService.activateContext("org.tizen.common.rest.import.swagger.context");
        contextService.activateContext("org.tizen.common.rest.export.wadl.context");
        contextService.activateContext("org.tizen.common.rest.export.swagger.context");
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void refreshTreeViewer() {
        this.viewer.refresh();
    }

    public void refreshTreeViewer(Object element) {
        this.viewer.refresh(element);
    }

    public void reloadTreeViewer() {
        if (this.viewer != null) {
            this.viewer.setInput(RepositoryManager.getInstance().getApplications());
        }
    }

    public class DoubleClickAction
    extends Action {
        RestViewer restViewer;

        public DoubleClickAction(RestViewer restViewer2) {
            this.restViewer = restViewer2;
        }

        public void run() {
            Tree tree = RestViewer.this.viewer.getTree();
            TreeItem[] items = tree.getSelection();
            if (items.length == 1) {
                IStructuredSelection selection = (IStructuredSelection)RestViewer.this.viewer.getSelection();
                Object element = selection.getFirstElement();
                TreeItem treeSelection = items[0];
                if (element instanceof Method || treeSelection.getItems().length == 0) {
                    RESTDialogHandler.openRESTDialog(RestViewer.this.viewer.getTree().getShell(), this.restViewer, selection, RestDialog.OPEN_MODIFY);
                } else {
                    treeSelection.setExpanded(!treeSelection.getExpanded());
                    RestViewer.this.viewer.refresh();
                }
            }
        }
    }

    private class RestDragSourceListener
    implements DragSourceListener {
        private TreeViewer viewer;

        private RestDragSourceListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (!RestViewer.this.validateSelection(selection)) {
                event.doit = false;
                return;
            }
            event.doit = true;
        }

        public void dragSetData(DragSourceEvent event) {
            ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
            if (ObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = selection;
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }

    private class RestDropTargetAdapter
    extends ViewerDropAdapter {
        private RestDropTargetAdapter(TreeViewer viewer) {
            super((Viewer)viewer);
        }

        public boolean performDrop(Object data) {
            int location = this.getCurrentLocation();
            IRestUiModel target = (IRestUiModel)this.getCurrentTarget();
            int operation = this.getCurrentOperation();
            IStructuredSelection selection = (IStructuredSelection)data;
            try {
                RestViewer.this.copyReference(selection, target);
            }
            catch (JAXBException e) {
                RestPlugin.log(e);
                return false;
            }
            Application origin_application = ((AbstractWadlModel)selection.getFirstElement()).getRoot();
            boolean result = RestViewer.this.moveOn(selection, target, operation, location);
            RepositoryManager.getInstance().updateOrAddApplication(origin_application);
            RestViewer.this.viewer.refresh((Object)origin_application);
            Application application = ((AbstractWadlModel)((Object)target)).getRoot();
            RepositoryManager.getInstance().updateOrAddApplication(application);
            RestViewer.this.viewer.refresh((Object)application);
            return result;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (!(target instanceof IRestUiModel)) {
                return false;
            }
            int location = this.getCurrentLocation();
            IStructuredSelection selection = (IStructuredSelection)RestViewer.this.viewer.getSelection();
            return RestViewer.this.validateTarget(target, selection, location);
        }
    }
}

