/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.connection.explorer.RemoteDeviceManagerDialog;
import org.tizen.sdblib.util.IOUtil;

public class RemoteDeviceMangerScanWorker
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)"RemoteDeviceManagerDialog.class");
    private final int REMOTE_SOCKET_CONNECT_WAIT_TIME = 20000;
    private boolean isRunning = false;
    private RemoteDeviceManagerDialog dlg = null;

    public RemoteDeviceMangerScanWorker(RemoteDeviceManagerDialog dlg) {
        this.dlg = dlg;
    }

    @Override
    public void run() {
        this.start();
        try {
            try {
                List<String> ipList = this.getHostAddressList();
                for (String hostIP : ipList) {
                    if (!this.isRunning()) {
                        break;
                    }
                    this.updateReachableIPList(hostIP);
                }
            }
            catch (Exception e) {
                logger.info(ConnectionUIMessages.Remote_Message_ScanError, (Throwable)e);
                this.finish();
            }
        }
        finally {
            this.finish();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        this.isRunning = true;
        this.dlg.enableScanButton(false);
        ScanSpinner spinner = new ScanSpinner();
        Thread threadSpinner = new Thread((Runnable)spinner, "Remote ScanSpinner");
        threadSpinner.start();
    }

    public void finish() {
        this.isRunning = false;
        this.dlg.enableScanButton(true);
    }

    private List<String> getHostAddressList() throws SocketException {
        ArrayList<String> addressList = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterface.isLoopback()) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                String hostAddress = inetAddress.getHostAddress();
                addressList.add(hostAddress);
                logger.debug("Add hostAddress: " + hostAddress + ", interface Name: " + networkInterface.getName());
            }
        }
        return addressList;
    }

    private void updateReachableIPList(String hostIP) throws InterruptedException {
        String[] tokens = hostIP.split(Pattern.quote("."));
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        if (tokens.length != 4) {
            logger.debug("Failed to check reachable IP, cause it's invalid ip: " + hostIP);
            return;
        }
        int i = 1;
        while (i < 255) {
            final String ip = String.valueOf(tokens[0]) + "." + tokens[1] + "." + tokens[2] + "." + i;
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    RemoteDeviceMangerScanWorker.this.findReachableIP(ip);
                }
            });
            th.start();
            threadList.add(th);
            ++i;
        }
        for (Thread th : threadList) {
            try {
                th.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void findReachableIP(String ip) {
        block7: {
            InetAddress inet = null;
            Socket socket = null;
            InetSocketAddress destAddr = null;
            try {
                try {
                    inet = InetAddress.getByName(ip);
                    logger.debug("Start Thread for checking reachable ip: " + ip);
                    if (inet.isReachable(4000)) {
                        logger.debug("Is reachable ip: " + ip);
                        socket = new Socket();
                        destAddr = new InetSocketAddress(ip, Integer.parseInt("26101"));
                        logger.debug("before connect ip: " + ip);
                        socket.connect(destAddr, 20000);
                        logger.debug("after connect ip: " + ip);
                        this.addIPToTable(ip);
                    } else {
                        logger.debug("Is not reachable ip: " + ip);
                    }
                }
                catch (IOException e) {
                    logger.debug("Failed to connect: " + ip, (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{destAddr});
                    IOUtil.tryClose((Object[])new Object[]{inet});
                    IOUtil.tryClose(socket);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{destAddr});
                IOUtil.tryClose((Object[])new Object[]{inet});
                IOUtil.tryClose(socket);
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{destAddr});
            IOUtil.tryClose((Object[])new Object[]{inet});
            IOUtil.tryClose((Closeable)socket);
        }
    }

    private void addIPToTable(final String ip) {
        this.dlg.table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RemoteDeviceMangerScanWorker.this.isExistIP(ip)) {
                    return;
                }
                RemoteDeviceMangerScanWorker.this.dlg.addRemoteDeviceToTable(ConnectionUIMessages.Remote_Device_Manager_Table_Default_Item_Name, ip, "26101");
            }
        });
    }

    private boolean isExistIP(String ip) {
        TableItem[] items;
        if (this.dlg.table.isDisposed()) {
            return false;
        }
        TableItem[] tableItemArray = items = this.dlg.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText(1).equals(ip)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    class ScanSpinner
    implements Runnable {
        ScanSpinner() {
        }

        @Override
        public void run() {
            while (RemoteDeviceMangerScanWorker.this.isRunning()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!((RemoteDeviceMangerScanWorker)((ScanSpinner)ScanSpinner.this).RemoteDeviceMangerScanWorker.this).dlg.table.isDisposed()) {
                            ((RemoteDeviceMangerScanWorker)((ScanSpinner)ScanSpinner.this).RemoteDeviceMangerScanWorker.this).dlg.table.redraw();
                        }
                    }
                });
                try {
                    Thread.sleep(((RemoteDeviceMangerScanWorker)RemoteDeviceMangerScanWorker.this).dlg.imageDataList.get((int)0).delayTime * 10);
                }
                catch (InterruptedException e) {
                    logger.error("Failed to scanning: " + e.getMessage(), (Throwable)e);
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!((RemoteDeviceMangerScanWorker)((ScanSpinner)ScanSpinner.this).RemoteDeviceMangerScanWorker.this).dlg.table.isDisposed()) {
                        ((RemoteDeviceMangerScanWorker)((ScanSpinner)ScanSpinner.this).RemoteDeviceMangerScanWorker.this).dlg.table.redraw();
                    }
                }
            });
        }
    }
}

