/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command.receiver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.sdb.command.receiver.OutputReceiver;

public abstract class LineReceiver
implements OutputReceiver {
    protected boolean needTrim = true;
    Status status = Status.NORMAL;
    private final List<String> lines = new ArrayList<String>();
    protected final StringBuilder buffer = new StringBuilder();

    public LineReceiver() {
        this(true);
    }

    public LineReceiver(boolean needTrim) {
        this.needTrim = needTrim;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (csq == null) {
            return this;
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            return this;
        }
        int i = start;
        while (i < end) {
            this.append(csq.charAt(i));
            ++i;
        }
        this.flush();
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.status == Status.NORMAL) {
            if ('\r' == c) {
                this.status = Status.CANDIDATE;
            } else if ('\n' == c) {
                this.makeLine();
            } else {
                this.buffer.append(c);
            }
        } else if (this.status == Status.CANDIDATE) {
            if ('\n' == c) {
                this.makeLine();
            } else if ('\r' == c) {
                this.buffer.append(c);
            } else {
                this.buffer.append('\r');
                this.buffer.append(c);
                this.status = Status.NORMAL;
            }
        }
        return this;
    }

    private void makeLine() {
        String line = this.buffer.toString();
        if (this.needTrim) {
            line = line.trim();
        }
        this.lines.add(line);
        this.buffer.delete(0, this.buffer.length());
        this.status = Status.NORMAL;
    }

    @Override
    public void flush() throws IOException {
        if (this.lines.size() > 0) {
            this.processNewLines(this.lines.toArray(new String[this.lines.size()]));
            this.lines.clear();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.length() > 0) {
            this.lines.add(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
            this.flush();
        }
    }

    public abstract void processNewLines(String[] var1);

    static enum Status {
        NORMAL,
        CANDIDATE;

    }
}

