/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.packager.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.file.FileHandlingCommand;
import org.tizen.common.core.command.policy.OptionPolicy;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.core.command.prompter.RunnableOption;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.packager.PackageResource;
import org.tizen.common.sign.signer.TizenCommonSigner;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.PackageUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;

public class PackageCommand
extends FileHandlingCommand<Boolean> {
    private Collection<IResource> resources;
    private OutputStream outputStream = null;
    private boolean needSign;
    private String signPath;
    private String platformName;
    private FileHandlingOption selectedAllFlagOption;
    private IDevice device;

    public PackageCommand(Collection<IResource> resources, OutputStream os, boolean needSign, String signPath, String platformName) {
        Assert.notNull(resources);
        Assert.notNull((Object)os);
        this.outputStream = os;
        this.resources = resources;
        this.needSign = needSign;
        this.signPath = signPath;
        this.platformName = platformName;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public void run(Executor executor, ExecutionContext context) throws Exception {
        Assert.notNull((Object)this.outputStream);
        ArrayList<IResource> packageResources = new ArrayList<IResource>();
        for (IResource resource : this.resources) {
            if (!this.filter.accept(resource.getFileHandler().getCurrentWorkingDirectory(), resource.getPath())) continue;
            packageResources.add(resource);
        }
        Collection<IResource> handledPackageResources = this.handleDuplicateFile(packageResources, context);
        if (this.needSign) {
            handledPackageResources.addAll(this.generateSignResources(this.signPath));
        }
        UserLogger.start((String)"web.package", (String)".packaging");
        this.result = PackageUtil.createPackage(handledPackageResources, (OutputStream)this.outputStream);
        UserLogger.end((String)"web.package", (String)".packaging");
    }

    private Collection<IResource> handleDuplicateFile(List<IResource> packageResources, ExecutionContext context) throws IOException {
        Option[] options;
        if (packageResources == null || packageResources.isEmpty()) {
            return packageResources;
        }
        Policy policy = context.getPolicy("exist.file.when.copy");
        if (policy == null) {
            return packageResources;
        }
        OptionPolicy optionPolicy = (OptionPolicy)policy.adapt(OptionPolicy.class);
        if (optionPolicy == null) {
            return packageResources;
        }
        Option[] optionArray = options = optionPolicy.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (!(option instanceof FileHandlingOption)) {
                throw new IllegalArgumentException(String.format("Option %s is not a FileHandlingOption", option.getName()));
            }
            ++n2;
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.addAll(packageResources);
        int i = 0;
        while (i < packageResources.size()) {
            IResource packageResource = packageResources.get(i);
            int j = i + 1;
            while (j < packageResources.size()) {
                IResource duplicateResource = packageResources.get(j);
                if (this.getDestPath(packageResource).equals(this.getDestPath(duplicateResource))) {
                    if (this.isDirectory(packageResource) && this.isDirectory(duplicateResource)) {
                        resources.remove(duplicateResource);
                    } else {
                        FileHandlingOption resultOption = null;
                        if (this.selectedAllFlagOption == null) {
                            String overwriteFilePath = FileUtil.appendPath((String)duplicateResource.getFileHandler().getCurrentWorkingDirectory(), (String)this.getDestPath(duplicateResource));
                            String question = "Resource exists in package. Do you wish to overwrite?\n\nOverwrite: " + packageResource.getPath() + "\n\nwith: " + overwriteFilePath;
                            resultOption = (RunnableOption)context.getPrompter().interact(question, options);
                        } else {
                            resultOption = this.selectedAllFlagOption;
                        }
                        if (resultOption.isAllFlag()) {
                            this.selectedAllFlagOption = resultOption;
                        }
                        if (resultOption.getName().startsWith("Overwrite")) {
                            resources.remove(packageResource);
                        } else if (resultOption.getName().startsWith("Ignore")) {
                            resources.remove(duplicateResource);
                        } else if (resultOption.getName().startsWith("Cancel")) {
                            throw new CommandCancelException();
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return resources;
    }

    private boolean isDirectory(IResource resource) throws IOException {
        return FileHandler.Type.DIRECTORY.equals(resource.getFileHandler().get(resource.getPath(), FileHandler.Attribute.TYPE));
    }

    private String getDestPath(IResource resource) {
        if (resource instanceof PackageResource) {
            return ((PackageResource)resource).getDestination();
        }
        return resource.getPath();
    }

    private Collection<? extends IResource> generateSignResources(String savedSignTmpPath) throws Exception {
        UserLogger.start((String)"web.package", (String)".signing");
        TizenCommonSigner signer = new TizenCommonSigner();
        Collection signResources = signer.doSign(this.resources, true, savedSignTmpPath, this.getDevice());
        UserLogger.end((String)"web.package", (String)".signing");
        return signResources;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }
}

