/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedInputStream;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryPackParser;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.transport.PackParser;
import org.kohsuke.args4j.Option;

@Command(usage="usage_IndexPack")
class IndexPack
extends TextBuiltin {
    @Option(name="--fix-thin", usage="usage_fixAThinPackToBeComplete")
    private boolean fixThin;
    @Option(name="--index-version", usage="usage_indexFileFormatToCreate")
    private int indexVersion = -1;

    IndexPack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Exception {
        BufferedInputStream in = new BufferedInputStream(System.in);
        ObjectInserter inserter = this.db.newObjectInserter();
        try {
            PackParser p = inserter.newPackParser(in);
            p.setAllowThin(this.fixThin);
            if (this.indexVersion != -1 && p instanceof ObjectDirectoryPackParser) {
                ObjectDirectoryPackParser imp = (ObjectDirectoryPackParser)p;
                imp.setIndexVersion(this.indexVersion);
            }
            p.parse(new TextProgressMonitor());
            inserter.flush();
        }
        finally {
            inserter.release();
        }
    }
}

