/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.ui.views.RestViewerLabelProvider;

public class RestParamLableProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int index = cell.getColumnIndex();
        switch (index) {
            case 0: {
                cell.setImage(this.getColumnImage(element, index));
            }
        }
        cell.setText(this.getColumnText(element, index));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Param param = (Param)element;
        IWadlModel parent = param.getParent();
        switch (columnIndex) {
            case 0: {
                if (parent == null) {
                    return null;
                }
                return RestViewerLabelProvider.getImageIcon(parent);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Param param = (Param)element;
        switch (columnIndex) {
            case 0: {
                return this.getParamParent(param);
            }
            case 1: {
                return param.getName();
            }
            case 2: {
                return param.getDefault();
            }
            case 3: {
                ParamStyle style = param.getStyle();
                if (style != null) {
                    return style.value();
                }
            }
            case 4: {
                return param.getType().getLocalPart();
            }
        }
        return "";
    }

    public String getParamParent(Param param) {
        IWadlModel parent = param.getParent();
        if (parent == null) {
            return "";
        }
        return RestViewerLabelProvider.getDisplayName(parent);
    }
}

