/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.model.Certification;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.ui.CertificateCreationHandler;
import org.tizen.common.sign.ui.common.CertificateComposite;
import org.tizen.common.sign.ui.common.CertificateCustomButton;
import org.tizen.common.sign.ui.common.CertificateManagementImages;
import org.tizen.common.sign.ui.dialog.CertificateAdditionDialog;
import org.tizen.common.sign.ui.dialog.CertificateEditionDialog;
import org.tizen.common.sign.ui.dialog.CertificateInformationDialog;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.ui.dialog.ProfileRemovalListener;
import org.tizen.common.sign.ui.model.CertificateInformation;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.StringUtil;

public class CertificateManageDialog
extends Dialog {
    private final int PROFILE_TABLE_WIDTH = 170;
    private final int PROFILE_TABLE_HEIGHT = 95;
    private final int DISTRIBUTOR_CERT1_INDEX = 1;
    private final int DISTRIBUTOR_CERT2_INDEX = 2;
    private Composite authorComposite;
    private Composite distributor1Composite;
    private Composite distributor2Composite;
    private Label lDescription;
    private CertificateCustomButton addProfileButton;
    private CertificateCustomButton removeProfileButton;
    private CertificateCustomButton activeProfileButton;
    private TableViewer profileTable;
    private SigningProfileContainer profileContainer;
    private SigningProfile selectedProfile;
    private List<SigningProfile> profileList;
    private final CertificateManagementImages certificateImages = new CertificateManagementImages();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CertificateManageDialog(Shell parentShell) {
        super(parentShell);
        this.updateProfileListFromFile();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CERT_MANAGER_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        CertificateManageDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createTitleArea(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        this.setInput();
        return composite;
    }

    private Control createTitleArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 60;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.lDescription = new Label(composite, 0);
        layoutData = new GridData(772);
        layoutData.grabExcessVerticalSpace = true;
        this.lDescription.setLayoutData((Object)layoutData);
        this.lDescription.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        return this.createMainComposite(parent);
    }

    private Composite createMainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 30;
        layout.marginHeight = 30;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        composite.setBackgroundMode(2);
        composite.setBackground(TizenColors.getTizenLightGrey());
        this.createProfileComposite(composite);
        this.createCertificateComposite(composite);
        Canvas separator = new Canvas(parent, 0);
        separator.setBackground(TizenColors.getTizenSmokeGrey());
        GridData separatorData = new GridData(768);
        separatorData.heightHint = 1;
        separator.setLayoutData((Object)separatorData);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control composite = super.createButtonBar(parent);
        parent.setBackground(this.getShell().getDisplay().getSystemColor(1));
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeButton = this.createButton(parent, 12, Messages.CERT_MANAGER_CLOSE, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateManageDialog.this.setReturnCode(0);
                CertificateManageDialog.this.close();
            }
        });
    }

    private void createProfileTitleComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Label lProfile = new Label(composite, 0);
        lProfile.setFont(TizenFonts.getBoldFont());
        lProfile.setText(Messages.CERT_MANAGER_CERT_PROFILE);
        lProfile.setLayoutData((Object)new GridData(768));
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 12;
        buttonComp.setLayout((Layout)layout);
        gridData = new GridData(128);
        buttonComp.setLayoutData((Object)gridData);
        this.addProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_ADD[this.certificateImages.IDX_DISABLED], this.certificateImages.PROFILE_ADD[this.certificateImages.IDX_ENABLED], this.certificateImages.PROFILE_ADD[this.certificateImages.IDX_HOVER], this.certificateImages.PROFILE_ADD[this.certificateImages.IDX_CLICKED]);
        GridData layoutData = new GridData(68);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        this.addProfileButton.setLayoutData(layoutData);
        this.removeProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_REMOVE[this.certificateImages.IDX_DISABLED], this.certificateImages.PROFILE_REMOVE[this.certificateImages.IDX_ENABLED], this.certificateImages.PROFILE_REMOVE[this.certificateImages.IDX_HOVER], this.certificateImages.PROFILE_REMOVE[this.certificateImages.IDX_CLICKED]);
        this.removeProfileButton.setLayoutData(layoutData);
        this.activeProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_ACTIVE[this.certificateImages.IDX_DISABLED], this.certificateImages.PROFILE_ACTIVE[this.certificateImages.IDX_ENABLED], this.certificateImages.PROFILE_ACTIVE[this.certificateImages.IDX_HOVER], this.certificateImages.PROFILE_ACTIVE[this.certificateImages.IDX_CLICKED]);
        this.activeProfileButton.setLayoutData(layoutData);
    }

    private void createProfileListComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(1);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 95;
        composite.setLayoutData((Object)gridData);
        this.profileTable = new TableViewer(composite, 68352);
        GridData data = new GridData(1808);
        this.profileTable.getTable().setLayoutData((Object)data);
        this.profileTable.getTable().setHeaderVisible(false);
        final TableColumn column = new TableColumn(this.profileTable.getTable(), 0);
        this.profileTable.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                column.setWidth(((CertificateManageDialog)CertificateManageDialog.this).profileTable.getTable().getClientArea().width);
            }
        });
        this.profileTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Composite removeButton;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CertificateManageDialog.this.selectedProfile = (SigningProfile)selection.getFirstElement();
                SigningProfileItem authCert = null;
                SigningProfileItem distCert1 = null;
                SigningProfileItem distCert2 = null;
                if (CertificateManageDialog.this.selectedProfile != null) {
                    authCert = CertificateManageDialog.this.selectedProfile.getAuthorProfileItem();
                    List distCerts = CertificateManageDialog.this.selectedProfile.getDistributorProfileItems();
                    distCert1 = (SigningProfileItem)distCerts.get(0);
                    distCert2 = (SigningProfileItem)distCerts.get(1);
                }
                if (CertificateManageDialog.this.selectedProfile != null && distCert2 == null) {
                    distCert2 = CertificateManageDialog.this.selectedProfile.createEmptyProfileItem(2);
                }
                CertificateManageDialog.this.updateCertComposite(CertificateManageDialog.this.authorComposite, authCert, false);
                CertificateManageDialog.this.updateCertComposite(CertificateManageDialog.this.distributor1Composite, distCert1, true);
                CertificateManageDialog.this.updateCertComposite(CertificateManageDialog.this.distributor2Composite, distCert2, true);
                CertificateManageDialog.this.activeProfileButton.setEnabled(CertificateManageDialog.this.selectedProfile != null);
                if (CertificateManageDialog.this.selectedProfile == null) {
                    return;
                }
                if (StringUtil.isEmpty((CharSequence)distCert1.getKeyLocation())) {
                    removeButton = (Composite)CertificateManageDialog.this.distributor2Composite.getData("remove_button");
                    removeButton.setEnabled(false);
                }
                if (StringUtil.isEmpty((CharSequence)distCert2.getKeyLocation())) {
                    removeButton = (Composite)CertificateManageDialog.this.distributor1Composite.getData("remove_button");
                    removeButton.setEnabled(false);
                }
            }
        });
        this.profileTable.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CertificateManageDialog.this.setActiveProfile();
            }
        });
        this.profileTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return ((List)element).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.profileTable.getTable().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (CertificateManageDialog.this.profileTable.getTable().getItemCount() == 0) {
                    Point textPt = event.gc.textExtent(Messages.CERT_MANAGER_NOPROFILE);
                    int x = (((CertificateManageDialog)CertificateManageDialog.this).profileTable.getTable().getSize().x - textPt.x) / 2;
                    int y = (((CertificateManageDialog)CertificateManageDialog.this).profileTable.getTable().getSize().y - textPt.y) / 2;
                    event.gc.drawString(Messages.CERT_MANAGER_NOPROFILE, x, y, true);
                }
            }
        });
        this.profileTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof SigningProfile) {
                    String profileName = ((SigningProfile)element).getProfileName();
                    String activeProfileName = SigningProfileUtil.getActiveProfileName();
                    if (activeProfileName.equals(profileName)) {
                        return ((CertificateManageDialog)CertificateManageDialog.this).certificateImages.ACTIVE_STATUS;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof SigningProfile) {
                    String profileName = ((SigningProfile)element).getProfileName();
                    return profileName;
                }
                return null;
            }
        });
    }

    private void createProfileComposite(final Composite parent) {
        this.createProfileTitleComposite(parent);
        this.createProfileListComposite(parent);
        this.activeProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                CertificateManageDialog.this.setActiveProfile();
            }
        });
        this.addProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)CertificateManageDialog.this.profileContainer);
                CertificateCreationHandler creationHandler = new CertificateCreationHandler();
                try {
                    int result = (Integer)creationHandler.execute(null);
                    if (result == 0) {
                        CertificateManageDialog.this.updateProfileListFromFile();
                        CertificateManageDialog.this.setInput();
                    }
                }
                catch (ExecutionException e) {
                    CertificateManageDialog.this.logger.error("Failed to execute certificate creation handler", (Throwable)e);
                }
            }
        });
        this.removeProfileButton.addMouseListener((MouseListener)new ProfileRemovalListener(this.profileTable));
        this.removeProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                TableItem[] items = CertificateManageDialog.this.profileTable.getTable().getItems();
                if (items.length == 0) {
                    CertificateManageDialog.this.changeMainComposite(parent.getParent());
                    return;
                }
                if (items.length <= 1) {
                    CertificateManageDialog.this.activeProfileButton.setEnabled(false);
                }
            }
        });
    }

    private void updateCertComposite(Composite parent, SigningProfileItem data, boolean isDistributor) {
        Control[] children;
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (data == null) {
            this.createEmptyComposite(parent, false);
        } else if (StringUtil.isEmpty((CharSequence)data.getKeyLocation())) {
            this.createEmptyComposite(parent, true);
        } else {
            CertificateInformation certInfo = this.getCertificateInformation(data);
            new CertificateComposite(parent, 0, certInfo);
            this.createButtonComposite(parent, isDistributor);
        }
        parent.setData("data", (Object)data);
        parent.layout(true, true);
    }

    private void createCertificateComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 15;
        layout.marginWidth = 20;
        layout.horizontalSpacing = 32;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 215;
        composite.setLayoutData((Object)gridData);
        this.createTitleComposite(composite);
        this.createAuthCertComposite(composite);
        this.createDistCertComposite(composite);
    }

    private void createTitleComposite(Composite parent) {
        Composite authTitleComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        authTitleComp.setLayout((Layout)layout);
        authTitleComp.setLayoutData((Object)new GridData(768));
        Label lTitle = new Label(authTitleComp, 0);
        lTitle.setFont(TizenFonts.getBoldFont());
        lTitle.setText(Messages.CERT_MANAGER_AUTHOR_CERT);
        Composite distTitleComp = new Composite(parent, 0);
        distTitleComp.setLayout((Layout)layout);
        distTitleComp.setLayoutData((Object)new GridData(768));
        lTitle = new Label(distTitleComp, 0);
        lTitle.setFont(TizenFonts.getBoldFont());
        lTitle.setText(Messages.CERT_MANAGER_DIST_CERT);
    }

    private void createAuthCertComposite(Composite parent) {
        this.authorComposite = this.createCertificateDeckComposite(parent);
        new CertificateComposite(this.authorComposite, 0);
    }

    private void createEmptyComposite(final Composite parent, boolean needAddButton) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        if (!needAddButton) {
            return;
        }
        CertificateCustomButton btAdd = new CertificateCustomButton(composite, this.certificateImages.CERT_ADD[this.certificateImages.IDX_DISABLED], this.certificateImages.CERT_ADD[this.certificateImages.IDX_ENABLED], this.certificateImages.CERT_ADD[this.certificateImages.IDX_HOVER], this.certificateImages.CERT_ADD[this.certificateImages.IDX_CLICKED]);
        GridData layoutData = new GridData(68);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        btAdd.setLayoutData(layoutData);
        btAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateAdditionDialog dlg = new CertificateAdditionDialog(CertificateManageDialog.this.getShell());
                    if (dlg.open() == 0) {
                        certificate.setKeyLocation(dlg.getCertPath());
                        certificate.setPassword(dlg.getCertPasswd().toCharArray());
                        CertificateManageDialog.this.profileTable.setSelection(CertificateManageDialog.this.profileTable.getSelection(), true);
                    }
                }
            }
        });
    }

    private void createDistCertComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.distributor1Composite = this.createCertificateDeckComposite(composite);
        new CertificateComposite(this.distributor1Composite, 0);
        this.distributor2Composite = this.createCertificateDeckComposite(composite);
        new CertificateComposite(this.distributor2Composite, 0);
    }

    private Composite createCertificateDeckComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new FormLayout());
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 165;
        layoutData.widthHint = 180;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    private void createButtonComposite(final Composite parent, final boolean isDistributor) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(100, -30);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        Composite buttonComp = new Composite(composite, 0);
        layout = isDistributor ? new GridLayout(3, false) : new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.marginBottom = 10;
        layout.horizontalSpacing = 5;
        buttonComp.setLayout((Layout)layout);
        GridData layoutData = new GridData(1936);
        buttonComp.setLayoutData((Object)layoutData);
        if (isDistributor) {
            CertificateCustomButton btDistRemove = new CertificateCustomButton(buttonComp, this.certificateImages.CERT_REMOVE[this.certificateImages.IDX_DISABLED], this.certificateImages.CERT_REMOVE[this.certificateImages.IDX_ENABLED], this.certificateImages.CERT_REMOVE[this.certificateImages.IDX_HOVER], this.certificateImages.CERT_REMOVE[this.certificateImages.IDX_CLICKED]);
            btDistRemove.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    Object data = parent.getData("data");
                    if (data == null) {
                        return;
                    }
                    if (data instanceof SigningProfileItem) {
                        SigningProfileItem certificate = (SigningProfileItem)data;
                        String filename = FilenameUtil.getFilename((String)certificate.getKeyLocation());
                        String name = FilenameUtil.getName((String)filename);
                        int result = DialogUtil.openQuestionDialog((String)String.format(Messages.CERT_REMOVE_QUESTION, name));
                        if (result == 128) {
                            return;
                        }
                        int ordinal = CertificateManageDialog.this.selectedProfile.getOrdinal(certificate);
                        if (ordinal == 1) {
                            SigningProfileItem item = CertificateManageDialog.this.selectedProfile.getProfileItem(2);
                            Assert.isNotNull((Object)item);
                            CertificateManageDialog.this.selectedProfile.setProfileItem(1, item);
                        }
                        CertificateManageDialog.this.selectedProfile.createEmptyProfileItem(2);
                        CertificateManageDialog.this.profileTable.setSelection(CertificateManageDialog.this.profileTable.getSelection(), true);
                    }
                }
            });
            parent.setData("remove_button", (Object)btDistRemove);
        }
        CertificateCustomButton btAuthEdit = new CertificateCustomButton(buttonComp, this.certificateImages.CERT_EDIT[this.certificateImages.IDX_DISABLED], this.certificateImages.CERT_EDIT[this.certificateImages.IDX_ENABLED], this.certificateImages.CERT_EDIT[this.certificateImages.IDX_HOVER], this.certificateImages.CERT_EDIT[this.certificateImages.IDX_CLICKED]);
        btAuthEdit.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateEditionDialog dlg = new CertificateEditionDialog(CertificateManageDialog.this.getShell(), certificate, isDistributor);
                    if (dlg.open() == 0) {
                        certificate.setKeyLocation(dlg.getCertPath());
                        certificate.setPassword(dlg.getCertPasswd().toCharArray());
                        CertificateManageDialog.this.profileTable.setSelection(CertificateManageDialog.this.profileTable.getSelection(), true);
                    }
                }
            }
        });
        layoutData = new GridData(4);
        layoutData.grabExcessVerticalSpace = true;
        btAuthEdit.setLayoutData(layoutData);
        CertificateCustomButton btAuthInfo = new CertificateCustomButton(buttonComp, this.certificateImages.CERT_INFO[this.certificateImages.IDX_DISABLED], this.certificateImages.CERT_INFO[this.certificateImages.IDX_ENABLED], this.certificateImages.CERT_INFO[this.certificateImages.IDX_HOVER], this.certificateImages.CERT_INFO[this.certificateImages.IDX_CLICKED]);
        btAuthInfo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateInformation certInfo = CertificateManageDialog.this.getCertificateInformation(certificate);
                    CertificateInformationDialog dlg = new CertificateInformationDialog(CertificateManageDialog.this.getShell(), certInfo);
                    dlg.open();
                }
            }
        });
        layoutData = new GridData(4);
        layoutData.grabExcessVerticalSpace = true;
        btAuthInfo.setLayoutData(layoutData);
    }

    private void setInput() {
        if (this.profileList.size() == 0) {
            this.lDescription.setText(Messages.CERT_MANAGER_EMPTY_DESC);
            this.removeProfileButton.setEnabled(false);
            this.activeProfileButton.setEnabled(false);
            this.logger.trace("Profile list is empty");
            return;
        }
        this.lDescription.setText(Messages.CERT_MANAGER_DESC);
        this.activeProfileButton.setEnabled(this.profileList.size() > 1);
        this.removeProfileButton.setEnabled(true);
        String activeProfileName = SigningProfileUtil.getActiveProfileName();
        SigningProfile activeProfile = this.profileContainer.getProfileByName(activeProfileName);
        if (activeProfile == null) {
            SigningProfile firstProfile = this.profileContainer.getFirstProfile();
            if (firstProfile == null) {
                this.logger.trace("The first profile is empty");
                return;
            }
            SigningProfileUtil.setActiveProfileName((String)firstProfile.getProfileName());
            this.profileContainer.setActiveProfile(firstProfile);
            activeProfile = this.profileContainer.getActiveProfile();
        } else {
            this.profileContainer.setActiveProfile(activeProfile);
        }
        int activeProfileIndex = this.profileList.indexOf(activeProfile);
        this.profileTable.setInput(this.profileList);
        this.profileTable.getTable().setSelection(activeProfileIndex);
        this.profileTable.setSelection(this.profileTable.getSelection(), true);
    }

    private void changeMainComposite(Composite composite) {
        Composite parent = composite.getParent();
        composite.dispose();
        this.createContents(parent);
        parent.layout(true, true);
    }

    private CertificateInformation getCertificateInformation(SigningProfileItem item) {
        String keyType = Certification.KeyExtension.p12.getKeyType();
        return new CertificateInformation(item.getKeyLocation(), keyType, item.getPassword());
    }

    private void updateProfileListFromFile() {
        this.profileContainer = SigningProfileUtil.getProfileContainerFromFile();
        this.profileList = this.profileContainer.getProfiles();
    }

    private void setActiveProfile() {
        TableItem[] items = this.profileTable.getTable().getSelection();
        if (items.length < 1) {
            return;
        }
        SigningProfile selectedProfile = (SigningProfile)items[0].getData();
        TableItem[] tableItemArray = this.profileTable.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            SigningProfile profile = (SigningProfile)item.getData();
            if (profile == selectedProfile) {
                SigningProfileUtil.setActiveProfileName((String)profile.getProfileName());
            }
            ++n2;
        }
        this.profileTable.refresh();
    }

    public boolean close() {
        if (!this.profileList.isEmpty()) {
            String activeProfileName = SigningProfileUtil.getActiveProfileName();
            SigningProfile activeProfile = this.profileContainer.getProfileByName(activeProfileName);
            this.profileContainer.setActiveProfile(activeProfile);
        }
        SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)this.profileContainer);
        this.logger.trace("Security preferences was saved");
        return super.close();
    }
}

