/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.IReferenceEnabled;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Link;
import org.tizen.common.rest.model.schema.Option;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.util.ModelUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"doc", "option", "link", "any"})
@XmlRootElement(name="param")
public class Param
extends AbstractWadlModel
implements IReferenceEnabled,
IRestUiModel,
Cloneable {
    protected List<Doc> doc;
    protected List<Option> option;
    protected Link link;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlAttribute(name="href")
    @XmlSchemaType(name="anyURI")
    protected String href;
    @XmlAttribute(name="name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String name;
    @XmlTransient
    protected String value;
    @XmlAttribute(name="style")
    protected ParamStyle style;
    @XmlAttribute(name="id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;
    @XmlAttribute(name="type")
    protected QName type;
    @XmlAttribute(name="default")
    protected String _default;
    @XmlAttribute(name="required")
    protected Boolean required;
    @XmlAttribute(name="repeating")
    protected Boolean repeating;
    @XmlAttribute(name="fixed")
    protected String fixed;
    @XmlAttribute(name="path")
    protected String path;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Param() {
    }

    public Param(String name, String value, ParamStyle style, QName type, Boolean isRequired) {
        this.setName(name);
        this.setDefault(value);
        this.setStyle(style);
        this.setType(type);
        this.setRequired(isRequired);
    }

    @Override
    public List<IWadlModel> getChildren() {
        ArrayList<IWadlModel> list = new ArrayList<IWadlModel>();
        list.addAll(this.getDoc());
        list.addAll(this.getOption());
        return list;
    }

    public List<Doc> getDoc() {
        if (this.doc == null) {
            this.doc = new ArrayList<Doc>();
        }
        return this.doc;
    }

    public List<Option> getOption() {
        if (this.option == null) {
            this.option = new ArrayList<Option>();
        }
        return this.option;
    }

    public Link getLink() {
        return this.link;
    }

    public void setLink(Link value) {
        this.link = value;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public void setHref(String value) {
        this.href = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ParamStyle getStyle() {
        Representation representation;
        if (ParamStyle.QUERY.equals((Object)this.style) && this.getParent() instanceof Representation && "multipart/form-data".equals((representation = (Representation)this.getParent()).getMediaType())) {
            return ParamStyle.FILE;
        }
        return this.style;
    }

    public void setStyle(ParamStyle style) {
        IWadlModel parent = this.getParent();
        if (parent != null) {
            if (ParamStyle.FILE.equals((Object)style)) {
                this.style = ParamStyle.QUERY;
                if (parent instanceof Request) {
                    Request request = (Request)parent;
                    request.removeChild(this);
                    List<Representation> rList = request.getRepresentation();
                    boolean isFind = false;
                    for (Representation representation : rList) {
                        if (!"multipart/form-data".equals(representation.getMediaType())) continue;
                        isFind = true;
                        representation.addChild(this);
                        break;
                    }
                    if (!isFind) {
                        Representation representation;
                        representation = new Representation();
                        representation.setMediaType("multipart/form-data");
                        request.addChild(representation);
                        representation.setMediaType("multipart/form-data");
                        representation.addChild(this);
                    }
                }
            } else if (parent instanceof Representation) {
                Representation representation = (Representation)parent;
                representation.removeChild(this);
                Request request = (Request)representation.getParent();
                request.addChild(this);
            }
        }
        this.style = style;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public QName getType() {
        if (this.type == null) {
            return new QName("http://www.w3.org/2001/XMLSchema", "string", "xs");
        }
        return this.type;
    }

    public void setType(QName value) {
        this.type = value;
    }

    public String getDefault() {
        return this._default;
    }

    public void setDefault(String value) {
        this._default = value;
    }

    public boolean isRequired() {
        if (this.required == null) {
            return false;
        }
        return this.required;
    }

    public void setRequired(Boolean value) {
        this.required = value;
    }

    public boolean isRepeating() {
        if (this.repeating == null) {
            return false;
        }
        return this.repeating;
    }

    public void setRepeating(Boolean value) {
        this.repeating = value;
    }

    public String getFixed() {
        return this.fixed;
    }

    public void setFixed(String value) {
        this.fixed = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public String getElementId() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public void addChild(IRestUiModel model) {
    }

    @Override
    public void removeChild(IRestUiModel model) {
    }

    @Override
    public boolean isVaildChild(IRestUiModel model) {
        return false;
    }

    @Override
    public IRestUiModel update(IRestUiModel updateModel) {
        if (updateModel instanceof Param) {
            Param param = ModelUtil.findReferences(this);
            Param updateParam = (Param)updateModel;
            if (!this.equals(param)) {
                try {
                    param = (Param)param.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                ((Request)this.getParent()).addChild(param);
                this.delete();
            }
            param.setName(updateParam.getName());
            param.setDefault(updateParam.getDefault());
            param.setStyle(updateParam.getStyle());
            param.setType(updateParam.getType());
            param.setRequired(updateParam.isRequired());
            return param;
        }
        return null;
    }

    @Override
    public void delete() {
        IWadlModel model = this.getParent();
        if (model != null) {
            if (model instanceof Request) {
                Request request = (Request)model;
                request.removeChild(this);
            } else if (model instanceof Representation) {
                Representation representation = (Representation)model;
                representation.removeChild(this);
            } else {
                ((IRestUiModel)model).removeChild(this);
            }
        }
    }

    @Override
    public void insertBefore(IRestUiModel model, IRestUiModel target) {
    }

    @Override
    public void insertAfter(IRestUiModel model, IRestUiModel target) {
    }

    public static enum PROPERTY {
        PARENT,
        NAME,
        VALUE,
        STYLE,
        TYPE,
        REQUIRED;

    }
}

