/*
 * Decompiled with CFR 0.152.
 */
package howdoi;

import howdoi.Handler;
import howdoi.HandlerUtil;
import java.io.OutputStream;
import java.util.List;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackoverflowHandler
implements Handler {
    @Override
    public boolean isQuestion(String link) {
        return link.matches(".*questions/\\d+/.*");
    }

    @Override
    public String getAnswerQueryString() {
        return "?answertab=votes";
    }

    @Override
    public String getAnswer(String link, Document doc, OutputStream out) throws Exception {
        String answer = "";
        Elements elements = doc.select(".answer");
        if (elements.size() > 0) {
            Element firstAnswer = elements.get(0);
            List<Element> instructions = HandlerUtil.add(firstAnswer.select("pre"), firstAnswer.select("code"));
            answer = instructions.isEmpty() ? firstAnswer.select(".post-text").get(0).text() : this.formatOutput(instructions.get(0).text());
        }
        return answer;
    }

    private String formatOutput(String text) {
        return text;
    }

    @Override
    public boolean useCustomFormat() {
        return false;
    }

    @Override
    public String formatOutput(List<String> answers) {
        return StringUtil.join(answers, (String)"\n");
    }

    @Override
    public String formatVisiting(int answerNumber, String link) {
        return String.format(" Visiting... [%d]\n", answerNumber + 1);
    }
}

