/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.common.RemoteLogger;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.EclipseExecutor;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.prompter.EclipsePrompter;
import org.tizen.common.core.command.prompter.SWTPrompter;
import org.tizen.common.launch.ProjectDeletionListener;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.CrashReportService;

public class CommonPlugin
extends AbstractUIPlugin {
    private static Logger logger;
    public static final String EXTENTION_POINT_CRASHREPORTER = "org.tizen.common.crashreporter";
    public static final String EXTENTION_POINT_PROMPTER = "org.tizen.common.prompter";
    public static final String EXTENTION_POINT_PROJECT_ADAPTER = "org.tizen.common.project.adapter";
    public static final String PLUGIN_ID = "org.tizen.common";
    public static final String PRODUCT_NAME = "TizenStudio";
    private static CommonPlugin plugin;
    protected EclipsePrompter prompter = null;
    protected Executor executor = null;
    protected long startTime;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.startTime = System.currentTimeMillis() / 1000L;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String logPath = prefs.get("installerLogFileName", "%X{userdata_log}/ide-%d{yyyyMMdd}_%d{HHmmss}.log");
        logPath = CommonPlugin.parseLogPath(logPath);
        String logLevel = prefs.get("loggerLevel", "ERROR");
        String logPattern = prefs.get("loggerPattern", "[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n");
        System.setProperty("installerLogFileName", logPath);
        System.setProperty("loggerLevel", logLevel);
        System.setProperty("loggerPattern", logPattern);
        RemoteLogger.logAccess(PRODUCT_NAME, "access", "", "", "");
        this.initializeExecutor();
        this.initializeSmartDeviceBridge();
        this.initDeleteProjectforFastDeploy();
    }

    public static String parseLogPath(String userInputPath) {
        String userDataPath = InstallPathConfig.getIdeUserDataLogPath();
        String resolvedPath = userInputPath.replace("%X{userdata_log}", userDataPath);
        resolvedPath = CommonPlugin.resolveDateFormat(resolvedPath);
        Path absolutePath = Paths.get(resolvedPath, new String[0]).toAbsolutePath();
        return absolutePath.toString();
    }

    private static String resolveDateFormat(String path) {
        while (path.contains("%d{")) {
            String formattedDate;
            int start = path.indexOf("%d{");
            int end = path.indexOf("}", start);
            if (end == -1) break;
            String datePattern = path.substring(start + 3, end);
            try {
                formattedDate = new SimpleDateFormat(datePattern).format(new Date());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                formattedDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            }
            path = String.valueOf(path.substring(0, start)) + formattedDate + path.substring(end + 1);
        }
        return path;
    }

    public void stop(BundleContext context) throws Exception {
        long endTime = System.currentTimeMillis() / 1000L;
        long usage = endTime - this.startTime;
        RemoteLogger.logUsage(PRODUCT_NAME, usage);
        this.destroyCrashReportService();
        this.finalizeSmartDeviceBridge();
        this.finalizeExecutor();
        plugin = null;
        super.stop(context);
    }

    public static void setDefault(CommonPlugin plugin) {
        CommonPlugin.plugin = plugin;
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        if (InstallPathConfig.getSDKPath() != null) {
            store.setDefault("sdkpath", InstallPathConfig.getSDKPath());
        }
        store.setDefault("org.tizen.common.option.rds", false);
        store.setDefault("response_timeout", 300000);
        IPreferenceStore debugPrefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        debugPrefStore.setDefault("org.eclipse.debug.ui.switch_to_perspective", "never");
        debugPrefStore.setDefault("org.eclipse.debug.ui.switch_perspective_on_suspend", "always");
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Prompter getPrompter() {
        return this.prompter;
    }

    protected void initializeExecutor() {
        this.prompter = new EclipsePrompter(new SWTPrompter());
        this.executor = new EclipseExecutor(this.prompter);
    }

    protected void finalizeExecutor() {
    }

    protected void initializeSmartDeviceBridge() {
        String sdbPath = InstallPathConfig.getSDBPath();
        if (!HostUtil.exists(sdbPath)) {
            DialogUtil.openMessageDialog(String.format("There is no %s.", sdbPath));
        } else {
            SmartDevelopmentBridge.createBridge((String)sdbPath);
        }
    }

    protected void finalizeSmartDeviceBridge() {
        SmartDevelopmentBridge.disconnectBridge();
    }

    protected void destroyCrashReportService() {
        CrashReportService.getDefault().down();
    }

    private void initDeleteProjectforFastDeploy() {
        ProjectDeletionListener projectDeletionListener = new ProjectDeletionListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)projectDeletionListener, 4);
    }
}

