/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.opalDialog.ChoiceItem;
import org.mihalis.opal.opalDialog.FooterArea;
import org.mihalis.opal.opalDialog.MessageArea;
import org.mihalis.opal.utils.ResourceManager;

public class Dialog {
    private String title;
    OpalDialogType buttonType;
    private final MessageArea messageArea;
    private final FooterArea footerArea;
    final Shell shell;
    private int minimumWidth = 300;
    private int minimumHeight = 150;

    public Dialog() {
        this(null);
    }

    public Dialog(Shell parent) {
        this.shell = parent == null ? new Shell(Display.getCurrent(), 67680) : new Shell(parent, 67680);
        this.messageArea = new MessageArea(this);
        this.footerArea = new FooterArea(this);
    }

    public int show() {
        GridLayout gd = new GridLayout(1, true);
        gd.horizontalSpacing = 0;
        gd.verticalSpacing = 0;
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        this.shell.setLayout((Layout)gd);
        this.messageArea.render();
        this.footerArea.render();
        if (this.title != null) {
            this.shell.setText(this.title);
        }
        this.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.footerArea.getSelectedButton();
    }

    public void close() {
        this.shell.dispose();
    }

    void pack() {
        Point preferredSize = this.shell.computeSize(-1, -1);
        if (preferredSize.x < this.minimumWidth) {
            preferredSize.x = this.minimumWidth;
        }
        if (preferredSize.y < this.minimumHeight) {
            preferredSize.y = this.minimumHeight;
        }
        Point displaySize = new Point(this.shell.getDisplay().getBounds().width, this.shell.getDisplay().getBounds().height);
        int centerX = (displaySize.x - preferredSize.x) / 2;
        int centerY = (displaySize.y - preferredSize.y) / 2;
        this.shell.setBounds(centerX, centerY, preferredSize.x, preferredSize.y);
    }

    public static String ask(String title, String text, String defaultValue) {
        return Dialog.ask(null, title, text, defaultValue);
    }

    public static String ask(Shell shell, String title, String text, String defaultValue) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Input"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(2)).addTextBox(defaultValue);
        dialog.setButtonType(OpalDialogType.OK_CANCEL);
        if (dialog.show() == 0) {
            return dialog.getMessageArea().getTextBoxValue();
        }
        return null;
    }

    public static void error(String title, String errorMessage) {
        Dialog.error(null, title, errorMessage);
    }

    public static void error(Shell shell, String title, String errorMessage) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("ApplicationError"));
        dialog.getMessageArea().setTitle(title).setText(errorMessage).setIcon(Display.getCurrent().getSystemImage(1));
        dialog.setButtonType(OpalDialogType.OK);
        dialog.show();
    }

    public static void inform(String title, String text) {
        Dialog.inform(null, title, text);
    }

    public static void inform(Shell shell, String title, String text) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Information"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(2));
        dialog.setButtonType(OpalDialogType.CLOSE);
        dialog.show();
    }

    public static boolean isConfirmed(String title, String text) {
        return Dialog.isConfirmed(null, title, text, -1);
    }

    public static boolean isConfirmed(Shell shell, String title, String text) {
        return Dialog.isConfirmed(shell, title, text, -1);
    }

    public static boolean isConfirmed(String title, String text, int timer) {
        return Dialog.isConfirmed(null, title, text, timer);
    }

    public static boolean isConfirmed(Shell shell, String title, String text, int timer) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Warning"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(8));
        dialog.getFooterArea().setTimer(timer).setTimerIndexButton(0);
        dialog.setButtonType(OpalDialogType.YES_NO);
        return dialog.show() == 0;
    }

    public static int radioChoice(String title, String text, int defaultSelection, String ... values) {
        return Dialog.radioChoice(null, title, text, defaultSelection, values);
    }

    public static int radioChoice(Shell shell, String title, String text, int defaultSelection, String ... values) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Choice"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(4)).addRadioButtons(defaultSelection, values);
        dialog.setButtonType(OpalDialogType.SELECT_CANCEL);
        if (dialog.show() == 0) {
            return dialog.getMessageArea().getRadioChoice();
        }
        return -1;
    }

    public static void showException(Throwable exception) {
        Dialog dialog = new Dialog();
        dialog.setTitle(ResourceManager.getLabel("Exception"));
        String msg = exception.getMessage();
        String className = exception.getClass().getName();
        boolean noMessage = msg == null || msg.trim().length() == 0;
        dialog.getMessageArea().setTitle(noMessage ? className : msg).setText(noMessage ? "" : className).setIcon(Display.getCurrent().getSystemImage(1)).setException(exception);
        dialog.getFooterArea().setExpanded(true);
        dialog.setButtonType(OpalDialogType.CLOSE);
        dialog.show();
    }

    public static int choice(String title, String text, int defaultSelection, ChoiceItem ... items) {
        return Dialog.choice(null, title, text, defaultSelection, items);
    }

    public static int choice(Shell shell, String title, String text, int defaultSelection, ChoiceItem ... items) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel("Choice"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(4)).addChoice(defaultSelection, items);
        dialog.setButtonType(OpalDialogType.NONE);
        dialog.show();
        return dialog.getMessageArea().getChoice();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OpalDialogType getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(OpalDialogType buttonType) {
        this.buttonType = buttonType;
        switch (buttonType) {
            case CLOSE: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Close")).setDefaultButtonIndex(0);
                break;
            }
            case NO_BUTTON: {
                break;
            }
            case OK: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Ok")).setDefaultButtonIndex(0);
                break;
            }
            case OK_CANCEL: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Ok"), ResourceManager.getLabel("Cancel")).setDefaultButtonIndex(-1);
                break;
            }
            case SELECT_CANCEL: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Select"), ResourceManager.getLabel("Cancel")).setDefaultButtonIndex(-1);
                break;
            }
            case YES_NO: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel("Yes"), ResourceManager.getLabel("No")).setDefaultButtonIndex(0);
                break;
            }
        }
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public FooterArea getFooterArea() {
        return this.footerArea;
    }

    public Shell getShell() {
        return this.shell;
    }

    public int getSelectedButton() {
        return this.getFooterArea().getSelectedButton();
    }

    public boolean getCheckboxValue() {
        return this.footerArea.getCheckBoxValue();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public static enum OpalDialogType {
        CLOSE,
        YES_NO,
        OK,
        OK_CANCEL,
        SELECT_CANCEL,
        NO_BUTTON,
        OTHER,
        NONE;

    }
}

