/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.constants.IRestUIConstants;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.ui.dialogs.RestDialog;
import org.tizen.common.rest.util.StringUtil;

public class RestParamDialog
extends Dialog {
    private List<IRestUiModel> parentList = new ArrayList<IRestUiModel>();
    private Text txtName;
    private Text txtValue;
    private Combo comboParent;
    private Combo comboStyle;
    private Combo comboType;
    private Button btnRequired;
    private Param param = null;
    public boolean isRequired = false;

    protected RestParamDialog(Shell parentShell, IRestUiModel[] modelList) {
        super(parentShell);
        IRestUiModel[] iRestUiModelArray = modelList;
        int n = modelList.length;
        int n2 = 0;
        while (n2 < n) {
            IRestUiModel model = iRestUiModelArray[n2];
            if (!(model instanceof Resources) && model != null) {
                this.parentList.add(model);
            }
            ++n2;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(RestUIMessages.UI_ADD_PARAM);
        newShell.setMinimumSize(RestDialog.WIDTH / 2, RestDialog.HEIGHT / 2);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label labelH0 = new Label(composite, 0);
        labelH0.setText(RestDialog.tableHeader[0]);
        if (this.parentList.size() > 0) {
            this.comboParent = new Combo(composite, 8);
            this.comboParent.setLayoutData((Object)new GridData(768));
            String str = null;
            for (IRestUiModel model : this.parentList) {
                if (model instanceof Application) {
                    str = ((Application)model).getTitle();
                } else if (model instanceof Resource) {
                    str = ((Resource)model).getPath();
                } else if (model instanceof Method) {
                    str = ((Method)model).getId();
                }
                if (org.tizen.common.util.StringUtil.isEmpty((CharSequence)str)) continue;
                this.comboParent.add(str);
            }
            this.comboParent.select(0);
        } else {
            Label labelError = new Label(composite, 0);
            labelError.setText(RestUIMessages.UI_ERR_PARAM_PARENT_REQUIRED);
        }
        Label labelH1 = new Label(composite, 0);
        labelH1.setText(RestDialog.tableHeader[1]);
        this.txtName = new Text(composite, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button button;
                if (RestParamDialog.this.txtName != null && (button = RestParamDialog.this.getButton(0)) != null && !button.isDisposed()) {
                    boolean isOK = !org.tizen.common.util.StringUtil.isEmpty((CharSequence)RestParamDialog.this.txtName.getText());
                    button.setEnabled(isOK);
                }
            }
        });
        Label labelH2 = new Label(composite, 0);
        labelH2.setText(RestDialog.tableHeader[2]);
        this.txtValue = new Text(composite, 2048);
        this.txtValue.setLayoutData((Object)new GridData(768));
        StringUtil.supportContentAssist(this.txtValue);
        Label labelH3 = new Label(composite, 0);
        labelH3.setText(RestDialog.tableHeader[3]);
        this.comboStyle = RestDialog.makeCombo(composite, IRestUIConstants.DEFAULT_PARAM_STYLE_ITEMS);
        this.comboStyle.setLayoutData((Object)new GridData(768));
        this.comboStyle.setText("query");
        Label labelH4 = new Label(composite, 0);
        labelH4.setText(RestDialog.tableHeader[4]);
        this.comboType = RestDialog.makeCombo(composite, IRestUIConstants.DEFAULT_PARAM_TYPE_ITEMS);
        this.comboType.setLayoutData((Object)new GridData(768));
        Label labelH5 = new Label(composite, 0);
        labelH5.setText(RestDialog.tableHeader[5]);
        this.btnRequired = new Button(composite, 32);
        this.btnRequired.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RestParamDialog.this.isRequired = !RestParamDialog.this.isRequired;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    private void setParam() {
        int typeIndex;
        int styleIndex;
        this.param = new Param();
        this.param.setName(this.txtName.getText());
        this.param.setDefault(this.txtValue.getText());
        int parentIndex = this.comboParent.getSelectionIndex();
        if (parentIndex >= 0) {
            IRestUiModel parent = this.parentList.get(parentIndex);
            this.param.setParent(parent);
        }
        if ((styleIndex = this.comboStyle.getSelectionIndex()) >= 0) {
            ParamStyle style = ParamStyle.fromValue(IRestUIConstants.DEFAULT_PARAM_STYLE_ITEMS[styleIndex]);
            this.param.setStyle(style);
        }
        if ((typeIndex = this.comboType.getSelectionIndex()) >= 0) {
            QName qName = QName.valueOf(IRestUIConstants.DEFAULT_PARAM_TYPE_ITEMS[typeIndex]);
            this.param.setType(qName);
        }
        this.param.setRequired(this.isRequired);
    }

    protected void okPressed() {
        this.setParam();
        super.okPressed();
    }

    public Param getParam() {
        return this.param;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }
}

