/*
* Web IDE - Command Line Interface
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact:
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.cli.exec.query;

import org.apache.commons.cli.CommandLine;

import static org.tizen.cli.exec.LaunchOptionConstants.DESC_FAILED_CANNOT_FIND_CONNECTED_DEVICE;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_FAILED_CANNOT_FIND_SELECTED_DEVICE;

import org.tizen.cli.exec.Help;
import org.tizen.cli.exec.WRTLauncher;
import org.tizen.web.zimlaunch.cli.command.QueryCommand;

/**
 * Command Line Interface for show widget list in target's installed
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public class
Main
extends WRTLauncher
{
    protected String FAILED_FIND_LIST = "Failed to find list: ";

    /**
     * Entry point for cli main
     * 
     * @param args user input parameter
     * 
     * @throws Exception If unhandled exception occur
     */
    public static
    void
    main(
        final String[] args
    )
    throws Exception
    {
        final Main instance = new Main();
        instance.run( args );
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#execute(org.apache.commons.cli.CommandLine)
     */
    @Override
    protected
    void
    execute(
        final CommandLine cmdLine
    )
    throws Exception
    {
        super.execute( cmdLine );

        // device not connect then exit
        if ( getDevice() == null ) {
            exit( 1 );
        }

        // core operation
        QueryCommand command = new QueryCommand();
        command.setDevice( getDevice() );
        command.setTime( getTime() );
        getExecutor().execute( command );

        exit( 0 );
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.WRTLauncher#getDeviceNotConnectedMessage()
     */
    @Override
    protected String getDeviceNotConnectedMessage() {
        return FAILED_FIND_LIST + DESC_FAILED_CANNOT_FIND_CONNECTED_DEVICE;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.WRTLauncher#getDeviceNotSelectedMessage()
     */
    @Override
    protected String getDeviceNotSelectedMessage() {
        return FAILED_FIND_LIST + DESC_FAILED_CANNOT_FIND_SELECTED_DEVICE;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#createHelp()
     */
    @Override
    protected Help createHelp() {
        Help help = super.createHelp();

        help.setSyntax( help.getSyntax() + getSyntax() );
        return help;
    }

    /* (non-Javadoc)
     * @see org.tizen.cli.exec.AbstractLauncher#getSyntax()
     */
    @Override
    protected
    String
    getSyntax()
    {
        return " [options]";
    }
}
