/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.tizen.common.connection.logview.dialog.ButtonBar;
import org.tizen.common.connection.logview.dialog.ButtonType;
import org.tizen.common.connection.logview.dialog.CustomLogTabInfo;
import org.tizen.common.connection.logview.dialog.Dialog;
import org.tizen.common.connection.logview.service.DeviceDescriptor;
import org.tizen.common.connection.logview.view.LogTab;
import org.tizen.common.connection.logview.view.Messages;

public class CustomLogTabDialog
extends Dialog<CustomLogTabInfo> {
    private ArrayList<DeviceDescriptor> deviceList;
    private TextField tabname;
    private ComboBox<DeviceDescriptor> targets;
    private final String LABEL_TITLE = Messages.Log_Tab_Dialog_Title_Add_Log_Tab;
    private final String LABEL_NAME = Messages.Log_Tab_Dialog_Label_Tab_Name;
    private final String LABEL_TARGET = Messages.Log_Tab_Dialog_Label_Device;
    private StringConverter<DeviceDescriptor> deviceNameConverter = new StringConverter<DeviceDescriptor>(){
        private Map<String, DeviceDescriptor> map = new HashMap<String, DeviceDescriptor>();

        public String toString(DeviceDescriptor device) {
            this.map.put(device.getSerialId(), device);
            return device.getSerialId();
        }

        public DeviceDescriptor fromString(String name) {
            if (this.map.containsKey(name)) {
                return this.map.get(name);
            }
            return null;
        }
    };

    public CustomLogTabDialog(ArrayList<DeviceDescriptor> connectedDeviceDescriptortList) {
        this.deviceList = connectedDeviceDescriptortList;
        this.createContents();
        this.setResultConverter(new Callback<ButtonType, CustomLogTabInfo>(){

            public CustomLogTabInfo call(ButtonType btn) {
                if (btn.getButtonData().equals((Object)ButtonBar.ButtonData.OK_DONE)) {
                    DeviceDescriptor device = (DeviceDescriptor)CustomLogTabDialog.this.targets.getSelectionModel().getSelectedItem();
                    if (CustomLogTabDialog.this.tabname.getText().isEmpty()) {
                        String name = LogTab.generateDefaultTabName(device);
                        return new CustomLogTabInfo(name, device);
                    }
                    return new CustomLogTabInfo(CustomLogTabDialog.this.tabname.getText(), device);
                }
                return null;
            }
        });
    }

    private void createContents() {
        this.setTitle(this.LABEL_TITLE);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        this.tabname = new TextField();
        this.tabname.setPromptText(LogTab.generateDefaultTabName(this.deviceList.get(0)));
        this.tabname.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.6));
        this.targets = new ComboBox();
        this.targets.setConverter(this.deviceNameConverter);
        this.targets.getItems().addAll(this.deviceList);
        this.targets.getSelectionModel().select((Object)this.deviceList.get(0));
        this.targets.valueProperty().addListener((ChangeListener)new ChangeListener<DeviceDescriptor>(){

            public void changed(ObservableValue<? extends DeviceDescriptor> ov, DeviceDescriptor arg1, DeviceDescriptor arg2) {
                DeviceDescriptor device = (DeviceDescriptor)ov.getValue();
                if (device != null) {
                    CustomLogTabDialog.this.tabname.setPromptText(LogTab.generateDefaultTabName(device));
                }
            }
        });
        this.targets.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.6));
        grid.add((Node)new Label(this.LABEL_NAME), 0, 1);
        grid.add((Node)this.tabname, 1, 1);
        grid.add((Node)new Label(this.LABEL_TARGET), 0, 3);
        grid.add(this.targets, 1, 3);
        grid.add((Node)new Label(""), 0, 4);
        this.getDialogPane().setContent((Node)grid);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResizable(false);
    }
}

