/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.rangeSlider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class RangeSlider
extends Canvas {
    private int minimum = 0;
    private int maximum = 100;
    private int lowerValue = 0;
    private int upperValue = 100;
    private final List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private final Image slider;
    private final Image sliderHover;
    private final Image sliderDrag;
    private final Image sliderSelected;
    private final Image vSlider;
    private final Image vSliderHover;
    private final Image vSliderDrag;
    private final Image vSliderSelected;
    private int orientation;
    private int increment = 1;
    private int pageIncrement = 10;
    private SELECTED_KNOB lastSelected = SELECTED_KNOB.NONE;
    private boolean dragInProgress;
    private Point coordUpper;
    private boolean upperHover;
    private Point coordLower;
    private boolean lowerHover;
    private int previousUpperValue;
    private int previousLowerValue;

    public RangeSlider(Composite parent, int style) {
        super(parent, 0x20000000 | ((style & 0x800) == 2048 ? 2048 : 0));
        this.slider = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-normal.png"));
        this.sliderHover = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-hover.png"));
        this.sliderDrag = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-drag.png"));
        this.sliderSelected = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/slider-selected.png"));
        this.vSlider = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-normal.png"));
        this.vSliderHover = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-hover.png"));
        this.vSliderDrag = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-drag.png"));
        this.vSliderSelected = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/h-slider-selected.png"));
        this.orientation = (style & 0x200) == 512 ? 512 : 256;
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.slider);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.sliderHover);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.sliderDrag);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.sliderSelected);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.vSlider);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.vSliderHover);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.vSliderDrag);
                SWTGraphicUtil.dispose((Resource)RangeSlider.this.vSliderSelected);
            }
        });
        this.addMouseListeners();
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                RangeSlider.this.handleKeyDown(event);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                RangeSlider.this.drawWidget(e);
            }
        });
    }

    private void addMouseListeners() {
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                RangeSlider.this.handleMouseDown(e);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                RangeSlider.this.handleMouseUp(e);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                RangeSlider.this.handleMouseMove(e);
            }
        });
        this.addListener(37, new Listener(){

            public void handleEvent(Event e) {
                RangeSlider.this.handleMouseWheel(e);
            }
        });
    }

    private void handleMouseDown(Event e) {
        if (this.upperHover) {
            this.dragInProgress = true;
            this.lastSelected = SELECTED_KNOB.UPPER;
            this.previousUpperValue = this.upperValue;
            return;
        }
        if (this.lowerHover) {
            this.dragInProgress = true;
            this.lastSelected = SELECTED_KNOB.LOWER;
            this.previousLowerValue = this.lowerValue;
            return;
        }
        this.dragInProgress = false;
        this.lastSelected = SELECTED_KNOB.NONE;
    }

    private void handleMouseUp(Event e) {
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        if (!this.fireSelectionListeners(e)) {
            if (this.lastSelected == SELECTED_KNOB.UPPER) {
                this.upperValue = this.previousUpperValue;
            } else {
                this.lowerValue = this.previousLowerValue;
            }
            this.redraw();
        }
    }

    private boolean fireSelectionListeners(Event event) {
        for (SelectionListener selectionListener : this.listeners) {
            SelectionEvent selectionEvent = new SelectionEvent(event);
            selectionListener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    private void handleMouseMove(Event e) {
        int x = e.x;
        int y = e.y;
        Image img = this.orientation == 256 ? this.slider : this.vSlider;
        this.upperHover = x >= this.coordUpper.x && x <= this.coordUpper.x + img.getBounds().width && y >= this.coordUpper.y && y <= this.coordUpper.y + img.getBounds().height;
        boolean bl = this.lowerHover = x >= this.coordLower.x && x <= this.coordLower.x + img.getBounds().width && y >= this.coordLower.y && y <= this.coordLower.y + img.getBounds().height;
        if (this.dragInProgress) {
            if (this.orientation == 256) {
                int mouseValue = (int)(((float)x - 9.0f) / this.computePixelSizeForHorizonalSlider()) + this.minimum;
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = (int)(Math.ceil(mouseValue / this.increment) * (double)this.increment) - this.increment;
                    this.checkUpperValue();
                } else {
                    this.lowerValue = (int)(Math.ceil(mouseValue / this.increment) * (double)this.increment) - this.increment;
                    this.checkLowerValue();
                }
            } else {
                int mouseValue = (int)(((float)y - 9.0f) / this.computePixelSizeForVerticalSlider()) + this.minimum;
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = (int)(Math.ceil(mouseValue / this.increment) * (double)this.increment) - this.increment;
                    this.checkUpperValue();
                } else {
                    this.lowerValue = (int)(Math.ceil(mouseValue / this.increment) * (double)this.increment) - this.increment;
                    this.checkLowerValue();
                }
            }
        }
        this.redraw();
    }

    private void handleMouseWheel(Event e) {
        if (this.lastSelected == SELECTED_KNOB.NONE) {
            return;
        }
        if (this.lastSelected == SELECTED_KNOB.LOWER) {
            this.lowerValue += e.count * this.increment;
            this.checkLowerValue();
            this.redraw();
        } else {
            this.upperValue += e.count * this.increment;
            this.checkUpperValue();
            this.redraw();
        }
    }

    private void checkLowerValue() {
        if (this.lowerValue < this.minimum) {
            this.lowerValue = this.minimum;
        }
        if (this.lowerValue > this.maximum) {
            this.lowerValue = this.maximum;
        }
        if (this.lowerValue > this.upperValue) {
            this.lowerValue = this.upperValue;
        }
    }

    private void checkUpperValue() {
        if (this.upperValue < this.minimum) {
            this.upperValue = this.minimum;
        }
        if (this.upperValue > this.maximum) {
            this.upperValue = this.maximum;
        }
        if (this.upperValue < this.lowerValue) {
            this.upperValue = this.lowerValue;
        }
    }

    private void drawWidget(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        e.gc.setAdvanced(true);
        e.gc.setAntialias(1);
        if (this.orientation == 256) {
            this.drawHorizontalRangeSlider(e.gc);
        } else {
            this.drawVerticalRangeSlider(e.gc);
        }
    }

    private void drawHorizontalRangeSlider(GC gc) {
        this.drawBackgroundHorizontal(gc);
        this.drawBarsHorizontal(gc);
        this.coordUpper = this.drawHorizontalKnob(gc, this.upperValue, true);
        this.coordLower = this.drawHorizontalKnob(gc, this.lowerValue, false);
    }

    private void drawBackgroundHorizontal(GC gc) {
        Rectangle clientArea = this.getClientArea();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        gc.drawRoundRectangle(9, 9, clientArea.width - 20, clientArea.height - 20, 3, 3);
        float pixelSize = this.computePixelSizeForHorizonalSlider();
        int startX = (int)(pixelSize * (float)this.lowerValue);
        int endX = (int)(pixelSize * (float)this.upperValue);
        if (this.isEnabled()) {
            gc.setBackground(this.getForeground());
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(15));
        }
        gc.fillRectangle(12 + startX, 9, endX - startX - 6, clientArea.height - 20);
    }

    private float computePixelSizeForHorizonalSlider() {
        return ((float)this.getClientArea().width - 20.0f) / (float)(this.maximum - this.minimum);
    }

    private void drawBarsHorizontal(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        float pixelSize = this.computePixelSizeForHorizonalSlider();
        int i = 1;
        while (i < 10) {
            int x = (int)(9.0f + pixelSize * (float)(this.maximum - this.minimum) / 10.0f * (float)i);
            gc.drawLine(x, 4, x, 7);
            gc.drawLine(x, clientArea.height - 6, x, clientArea.height - 9);
            ++i;
        }
    }

    private Point drawHorizontalKnob(GC gc, int value, boolean upper) {
        float pixelSize = this.computePixelSizeForHorizonalSlider();
        int x = (int)(pixelSize * (float)value);
        Image image = upper ? (this.upperHover ? (this.dragInProgress ? this.sliderDrag : this.sliderHover) : (this.lastSelected == SELECTED_KNOB.UPPER ? this.sliderSelected : this.slider)) : (this.lowerHover ? (this.dragInProgress ? this.sliderDrag : this.sliderHover) : (this.lastSelected == SELECTED_KNOB.LOWER ? this.sliderSelected : this.slider));
        if (this.isEnabled()) {
            gc.drawImage(image, x + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
        } else {
            Image temp = new Image((Device)this.getDisplay(), image, 1);
            gc.drawImage(temp, x + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
            temp.dispose();
        }
        return new Point(x + 5, this.getClientArea().height / 2 - this.slider.getBounds().height / 2);
    }

    private void drawVerticalRangeSlider(GC gc) {
        this.drawBackgroundVertical(gc);
        this.drawBarsVertical(gc);
        this.coordUpper = this.drawVerticalKnob(gc, this.upperValue, true);
        this.coordLower = this.drawVerticalKnob(gc, this.lowerValue, false);
    }

    private void drawBackgroundVertical(GC gc) {
        Rectangle clientArea = this.getClientArea();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        gc.drawRoundRectangle(9, 9, clientArea.width - 20, clientArea.height - 20, 3, 3);
        float pixelSize = this.computePixelSizeForVerticalSlider();
        int startY = (int)(pixelSize * (float)this.lowerValue);
        int endY = (int)(pixelSize * (float)this.upperValue);
        if (this.isEnabled()) {
            gc.setBackground(this.getForeground());
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(15));
        }
        gc.fillRectangle(9, 12 + startY, clientArea.width - 20, endY - startY - 6);
    }

    private float computePixelSizeForVerticalSlider() {
        return ((float)this.getClientArea().height - 20.0f) / (float)(this.maximum - this.minimum);
    }

    private void drawBarsVertical(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (this.isEnabled()) {
            gc.setForeground(this.getForeground());
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        float pixelSize = this.computePixelSizeForVerticalSlider();
        int i = 1;
        while (i < 10) {
            int y = (int)(9.0f + pixelSize * (float)(this.maximum - this.minimum) / 10.0f * (float)i);
            gc.drawLine(4, y, 7, y);
            gc.drawLine(clientArea.width - 6, y, clientArea.width - 9, y);
            ++i;
        }
    }

    private Point drawVerticalKnob(GC gc, int value, boolean upper) {
        float pixelSize = this.computePixelSizeForVerticalSlider();
        int y = (int)(pixelSize * (float)value);
        Image image = upper ? (this.upperHover ? (this.dragInProgress ? this.vSliderDrag : this.vSliderHover) : (this.lastSelected == SELECTED_KNOB.UPPER ? this.vSliderSelected : this.vSlider)) : (this.lowerHover ? (this.dragInProgress ? this.vSliderDrag : this.vSliderHover) : (this.lastSelected == SELECTED_KNOB.LOWER ? this.vSliderSelected : this.vSlider));
        if (this.isEnabled()) {
            gc.drawImage(image, this.getClientArea().width / 2 - 8, y + 2);
        } else {
            Image temp = new Image((Device)this.getDisplay(), image, 1);
            gc.drawImage(temp, this.getClientArea().width / 2 - 8, y + 2);
            temp.dispose();
        }
        return new Point(this.getClientArea().width / 2 - 8, y + 2);
    }

    private void handleKeyDown(Event event) {
        boolean needRedraw = false;
        if (this.lastSelected == SELECTED_KNOB.NONE) {
            this.lastSelected = SELECTED_KNOB.LOWER;
        }
        switch (event.keyCode) {
            case 0x1000007: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue = this.minimum;
                } else {
                    this.lowerValue = this.minimum;
                }
                needRedraw = true;
                break;
            }
            case 0x1000008: {
                this.upperValue = this.lastSelected == SELECTED_KNOB.UPPER ? this.maximum : this.maximum;
                needRedraw = true;
                break;
            }
            case 0x1000005: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue += this.pageIncrement;
                } else {
                    this.lowerValue += this.pageIncrement;
                }
                needRedraw = true;
                break;
            }
            case 0x1000006: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue -= this.pageIncrement;
                } else {
                    this.lowerValue -= this.pageIncrement;
                }
                needRedraw = true;
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue -= this.increment;
                } else {
                    this.lowerValue -= this.increment;
                }
                needRedraw = true;
                break;
            }
            case 0x1000002: 
            case 0x1000004: {
                if (this.lastSelected == SELECTED_KNOB.UPPER) {
                    this.upperValue += this.increment;
                } else {
                    this.lowerValue += this.increment;
                }
                needRedraw = true;
                break;
            }
        }
        if (needRedraw) {
            if (this.lastSelected == SELECTED_KNOB.UPPER) {
                this.checkUpperValue();
            } else {
                this.checkLowerValue();
            }
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.listeners.add(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        this.checkWidget();
        if (this.orientation == 256) {
            width = wHint < 100 ? 100 : wHint;
            height = hHint < 30 ? 30 : hHint;
        } else {
            width = wHint < 30 ? 30 : wHint;
            height = hHint < 100 ? 100 : hHint;
        }
        return new Point(width, height);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getLowerValue() {
        this.checkWidget();
        return this.lowerValue;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int[] getSelection() {
        this.checkWidget();
        int[] selection = new int[]{this.lowerValue, this.upperValue};
        return selection;
    }

    public int getUpperValue() {
        this.checkWidget();
        return this.upperValue;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.listeners.remove(listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        this.increment = increment;
        this.redraw();
    }

    public void setLowerValue(int value) {
        this.checkWidget();
        if (this.minimum <= value && value <= this.maximum && value <= this.upperValue) {
            this.lowerValue = value;
        }
        this.redraw();
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (this.minimum <= value) {
            this.maximum = value;
            if (this.lowerValue >= this.maximum) {
                this.lowerValue = this.maximum;
            }
            if (this.upperValue >= this.maximum) {
                this.upperValue = this.maximum;
            }
        }
        this.redraw();
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (this.maximum >= value) {
            this.minimum = value;
            if (this.lowerValue <= this.minimum) {
                this.lowerValue = this.minimum;
            }
            if (this.upperValue <= this.minimum) {
                this.upperValue = this.minimum;
            }
        }
        this.redraw();
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        this.pageIncrement = pageIncrement;
    }

    public void setSelection(int[] values) {
        this.checkWidget();
        this.setLowerValue(values[0]);
        this.setUpperValue(values[1]);
        this.checkUpperValue();
        this.checkLowerValue();
        this.redraw();
    }

    public void setSelection(int lowerValue, int upperValue) {
        this.checkWidget();
        this.setLowerValue(lowerValue);
        this.setUpperValue(upperValue);
    }

    public void setUpperValue(int value) {
        this.checkWidget();
        if (this.minimum <= value && value <= this.maximum && value >= this.lowerValue) {
            this.upperValue = value;
        }
        this.redraw();
    }

    private static enum SELECTED_KNOB {
        NONE,
        UPPER,
        LOWER;

    }
}

