/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.PluginDropAdapter;
import zipeditor.model.Node;
import zipeditor.operations.AddOperation;

public class ZipEditorDropAdapter
extends PluginDropAdapter {
    public ZipEditorDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    public void dragEnter(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail == 16) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        return super.validateDrop(target, operation, transferType);
    }

    public boolean performDrop(Object data) {
        if (!(data instanceof String[])) {
            return false;
        }
        Node selectedNode = (Node)((Object)this.getCurrentTarget());
        Node parentNode = selectedNode;
        if (parentNode == null && this.getViewer().getInput() instanceof Node) {
            parentNode = (Node)((Object)this.getViewer().getInput());
        }
        if (!parentNode.isFolder()) {
            parentNode = parentNode.getParent();
        }
        if (this.getViewer() instanceof TreeViewer && this.getCurrentLocation() == 1 && parentNode != this.getViewer().getInput()) {
            parentNode = parentNode.getParent();
        }
        String[] names = (String[])data;
        AddOperation operation = new AddOperation();
        operation.execute(names, parentNode, selectedNode, (StructuredViewer)this.getViewer());
        return true;
    }
}

