/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.run;

import com.google.gson.annotations.Expose;
import java.util.List;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.run.AdvancedTreePath;
import org.tizen.common.rest.run.MaxSizeHashMap;

public class HistoryData {
    @Expose(serialize=true, deserialize=false)
    private MaxSizeHashMap<String, List<AdvancedTreePath>> historyMap;

    public HistoryData() {
        int size = RestPlugin.getDefault().getPreferenceStore().getInt("PREF_KEY_RUN_HISTORY_SIZE");
        this.historyMap = new MaxSizeHashMap(size);
    }

    public MaxSizeHashMap<String, List<AdvancedTreePath>> getHistories() {
        return this.historyMap;
    }

    public List<AdvancedTreePath> getHistory(String key) {
        return (List)this.historyMap.get(key);
    }

    public List<AdvancedTreePath> putHistory(String key, List<AdvancedTreePath> history) {
        List old = (List)this.historyMap.remove(key);
        this.historyMap.put(key, history);
        return old;
    }

    public List<AdvancedTreePath> removeHistory(String key) {
        return (List)this.historyMap.remove(key);
    }

    public void clearHistories() {
        this.historyMap.clear();
    }

    public void updateHistorySize(int size) {
        if (this.historyMap.getMaxSize() != size) {
            MaxSizeHashMap<String, List<AdvancedTreePath>> newMap = new MaxSizeHashMap<String, List<AdvancedTreePath>>(size);
            newMap.putAll(this.historyMap);
            this.historyMap = newMap;
        }
    }
}

