/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.ui.preferences.AbstractPreferencePage;
import org.tizen.common.rest.ui.preferences.AuthPrefSection;
import org.tizen.common.rest.ui.preferences.IRestAuthPreference;
import org.tizen.common.rest.ui.preferences.WadlTreeSection;

public class AuthPreferencePage
extends AbstractPreferencePage
implements ISelectionChangedListener {
    private static IConfigurationElement[] authTypeElements;
    private Map<String, AuthPrefSection> authSectionMap = new LinkedHashMap<String, AuthPrefSection>();
    private Button useAuthCheck;
    private WadlTreeSection wadlTreeSection;
    private String selectedAppId;
    private Application selected;

    public AuthPreferencePage() {
        super(RestUIMessages.AuthPreferencePage_description);
        if (authTypeElements == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            authTypeElements = registry.getConfigurationElementsFor("org.tizen.common.rest.authType");
        }
    }

    @Override
    public void init(IWorkbench workbench) {
        IWadlModel model;
        Application app;
        IStructuredSelection ss;
        Object obj;
        super.init(workbench);
        ISelection selection = workbench.getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IWadlModel && (app = (model = (IWadlModel)obj).getRoot()) != null) {
            this.selected = app;
        }
    }

    @Override
    protected Composite createContentArea(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Composite leftComp = this.createComposite(composite, 1);
        leftComp.setLayout((Layout)new FillLayout());
        gd = new GridData(1808);
        gd.minimumWidth = 100;
        gd.widthHint = 200;
        leftComp.setLayoutData((Object)gd);
        this.wadlTreeSection = new WadlTreeSection(leftComp);
        this.wadlTreeSection.addSelectionChangedListener(this);
        Composite rightComp = this.createComposite(composite, 1);
        gd = new GridData(1808);
        gd.minimumWidth = 200;
        rightComp.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.numColumns = 1;
        rightComp.setLayout((Layout)layout);
        this.createAuthTypeArea(rightComp);
        return composite;
    }

    private void createAuthTypeArea(Composite parent) {
        this.useAuthCheck = new Button(parent, 32);
        this.useAuthCheck.setText(RestUIMessages.AuthPreferencePage_useAuth);
        this.useAuthCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthPreferencePage.this.updateUIState();
            }
        });
        Composite container = this.createComposite(parent, 1);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        IConfigurationElement[] iConfigurationElementArray = authTypeElements;
        int n = authTypeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String id = element.getAttribute("id");
                String title = element.getAttribute("name");
                String desc = element.getAttribute("description");
                IRestAuthPreference pref = (IRestAuthPreference)element.createExecutableExtension("preferenceClass");
                Label empty = this.createLabel(container, " ");
                gd = new GridData();
                gd.heightHint = 10;
                empty.setLayoutData((Object)gd);
                AuthPrefSection section = AuthPrefSection.createSection(this, container, id, title, desc, pref);
                this.authSectionMap.put(id, section);
            }
            catch (CoreException e) {
                RestPlugin.log(e);
            }
            ++n2;
        }
    }

    @Override
    protected void loadData() {
        this.loadData(null);
        if (this.selected != null) {
            this.wadlTreeSection.setSelection((ISelection)new StructuredSelection((Object)this.selected), true);
        }
    }

    private void loadData(String selectedAppId) {
        if (selectedAppId == null || selectedAppId.length() == 0) {
            this.performDefaults();
        } else {
            boolean useAuth = Boolean.parseBoolean(this.getValue(this.getKeyByAppId("PREF_KEY_USE_AUTH", selectedAppId)));
            if (authTypeElements.length == 0) {
                useAuth = false;
            }
            this.useAuthCheck.setSelection(useAuth);
            String activeAuthType = this.getValue(this.getKeyByAppId("PREF_KEY_ACTIVE_AUTH_TYPE", selectedAppId));
            for (String id : this.authSectionMap.keySet()) {
                AuthPrefSection section = this.authSectionMap.get(id);
                section.getAuthTypePref().loadData(selectedAppId);
                section.setSelection(activeAuthType);
            }
            this.updateUIState();
        }
    }

    private String getKeyByAppId(String originalKey, String appId) {
        String result = originalKey;
        if (appId != null && appId.length() > 0) {
            result = String.valueOf(result) + "." + appId;
        }
        return result;
    }

    private void updateUIState() {
        boolean enabled = this.useAuthCheck.getSelection();
        for (String id : this.authSectionMap.keySet()) {
            AuthPrefSection section = this.authSectionMap.get(id);
            if (enabled) {
                section.updateUIState(enabled);
                continue;
            }
            section.setEnabled(false);
        }
    }

    @Override
    protected void performApply() {
        boolean useAuth = this.useAuthCheck.getSelection();
        this.setValue(this.getKeyByAppId("PREF_KEY_USE_AUTH", this.selectedAppId), String.valueOf(useAuth));
        for (String id : this.authSectionMap.keySet()) {
            AuthPrefSection section = this.authSectionMap.get(id);
            if (section.getSelection()) {
                String data = section.getId();
                this.setValue(this.getKeyByAppId("PREF_KEY_ACTIVE_AUTH_TYPE", this.selectedAppId), data);
            }
            section.getAuthTypePref().performApply(this.selectedAppId);
        }
        this.updateUIState();
    }

    protected void performDefaults() {
        boolean useAuth = Boolean.parseBoolean(this.getDefault("PREF_KEY_USE_AUTH"));
        if (authTypeElements.length == 0) {
            useAuth = false;
        }
        this.useAuthCheck.setSelection(useAuth);
        for (String id : this.authSectionMap.keySet()) {
            AuthPrefSection section = this.authSectionMap.get(id);
            section.getAuthTypePref().performDefaults(this.selectedAppId);
            section.setEnabled(useAuth);
        }
        this.updateUIState();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.wadlTreeSection.getSelection();
        if (selection != null && selection.size() > 0) {
            Object obj = selection.getFirstElement();
            if (obj instanceof Application) {
                Application app = (Application)obj;
                this.selectedAppId = app.getElementId();
                this.loadData(this.selectedAppId);
            } else if (obj instanceof Resources) {
                Resources res = (Resources)obj;
                Application app = res.getRoot();
                this.selectedAppId = app.getElementId();
                this.loadData(this.selectedAppId);
            }
        } else {
            this.selectedAppId = null;
            this.loadData();
        }
    }
}

