/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.project.model;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.project.model.ISourceProject;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;

public class SourceProject
implements ISourceProject {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String type;
    private String path;
    private boolean bPackage;
    private String currentPlatform;
    private String name;
    private String platform;

    public SourceProject(String path, String type, boolean bPackage, String currentPlatform) {
        Assert.notNull((Object)path);
        this.path = path;
        this.type = type;
        this.bPackage = bPackage;
        this.currentPlatform = currentPlatform;
    }

    @Override
    public String getType() {
        return StringUtil.isEmpty((CharSequence)this.type) ? "Unknown" : this.type;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isPackage() {
        return this.bPackage;
    }

    @Override
    public String getCurrentPlatform() {
        return StringUtil.isEmpty((CharSequence)this.currentPlatform) ? "Not Available" : this.currentPlatform;
    }

    @Override
    public String getNameToCreate() {
        return this.name;
    }

    @Override
    public void setNameToCreate(String name) {
        this.name = name;
    }

    @Override
    public String getPlatformToCreate() {
        return this.platform;
    }

    @Override
    public void setPlatformToCreate(String platform) {
        this.platform = platform;
    }

    @Override
    public String validatePath() {
        String path = this.getPath();
        if (StringUtil.isEmpty((CharSequence)path)) {
            return "Path is empty.";
        }
        File file = new File(path);
        if (!file.exists()) {
            return "Input a valid path.";
        }
        if (this.isPackage()) {
            try {
                ZipFile zipFile = new ZipFile(path);
                IOUtil.tryClose((Object[])new Object[]{zipFile});
            }
            catch (IOException iOException) {
                return "It is not a package.";
            }
        } else if (!file.isDirectory()) {
            return "It is not a directory";
        }
        return null;
    }

    protected int parsePlatform(String platform) {
        if (StringUtil.isEmpty((CharSequence)platform)) {
            return -1;
        }
        if ("Not Available".equals(platform)) {
            return -1;
        }
        return platform.lastIndexOf("-");
    }

    @Override
    public String getProfileFrom(String platform) {
        int lastIndexOf = this.parsePlatform(platform);
        if (lastIndexOf == -1) {
            return null;
        }
        return platform.substring(0, lastIndexOf);
    }

    @Override
    public String getVersionFrom(String platform) {
        int lastIndexOf = this.parsePlatform(platform);
        if (lastIndexOf == -1) {
            return null;
        }
        return platform.substring(lastIndexOf + 1, platform.length());
    }

    @Override
    public File getProjectDescriptionFile() {
        if (this.validatePath() != null || this.isPackage()) {
            return null;
        }
        File file = new File(this.getPath(), ".project");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

