/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.common;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CertificateCustomButton
extends Canvas {
    protected Image image;
    protected Image disableImage;
    protected Image enableImage;
    protected Image hoverImage;
    protected Image clickImage;
    private final String TABLEDATA_KEY = "table";

    public CertificateCustomButton(Composite parent, Image disableImage, Image enableImage, Image hoverImage, Image clickImage) {
        super(parent, 0x20000000);
        Assert.isNotNull((Object)enableImage);
        this.addListeners();
        this.disableImage = disableImage;
        this.enableImage = enableImage;
        this.hoverImage = hoverImage;
        this.clickImage = clickImage;
        this.image = enableImage;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changedpublic) {
        Rectangle bounds = this.image.getBounds();
        return new Point(bounds.width, bounds.height);
    }

    public void setTableData(TableViewer table) {
        this.setData("table", table);
    }

    public TableViewer getTableData() {
        return (TableViewer)this.getData("table");
    }

    protected void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.fillRectangle(0, 0, CertificateCustomButton.this.getSize().x, CertificateCustomButton.this.getSize().y);
                if (CertificateCustomButton.this.image != null && !CertificateCustomButton.this.image.isDisposed()) {
                    CertificateCustomButton.this.drawImageAlignCenter(gc, CertificateCustomButton.this.image, 0, 0, CertificateCustomButton.this.getSize().x, CertificateCustomButton.this.getSize().y);
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (CertificateCustomButton.this.clickImage == null) {
                    return;
                }
                CertificateCustomButton.this.image = CertificateCustomButton.this.enableImage;
                CertificateCustomButton.this.redraw();
            }

            public void mouseDown(MouseEvent arg0) {
                if (CertificateCustomButton.this.clickImage == null) {
                    return;
                }
                CertificateCustomButton.this.image = CertificateCustomButton.this.clickImage;
                CertificateCustomButton.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent paramMouseEvent) {
                if (CertificateCustomButton.this.disableImage == null) {
                    return;
                }
                CertificateCustomButton.this.image = CertificateCustomButton.this.getEnabled() ? CertificateCustomButton.this.enableImage : CertificateCustomButton.this.disableImage;
                CertificateCustomButton.this.redraw();
            }

            public void mouseEnter(MouseEvent paramMouseEvent) {
                if (CertificateCustomButton.this.hoverImage == null) {
                    return;
                }
                CertificateCustomButton.this.image = CertificateCustomButton.this.hoverImage;
                CertificateCustomButton.this.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.disableImage == null) {
            return;
        }
        this.image = this.getEnabled() ? this.enableImage : this.disableImage;
        this.redraw();
    }

    private void drawImageAlignCenter(GC gc, Image image, int x, int y, int width, int height) {
        int imageWidth = image.getImageData().width;
        int imageHeight = image.getImageData().height;
        double widthScale = (double)width / (double)imageWidth;
        double heightScale = (double)height / (double)imageHeight;
        if (widthScale >= 1.0 && heightScale >= 1.0) {
            gc.drawImage(image, width / 2 - imageWidth / 2 + x, height / 2 - imageHeight / 2 + y);
        } else if (widthScale < heightScale) {
            gc.drawImage(image, 0, 0, imageWidth, imageHeight, x, (int)((double)(height / 2) - (double)imageHeight * widthScale / 2.0) + y, (int)((double)imageWidth * widthScale), (int)((double)imageHeight * widthScale));
        } else {
            gc.drawImage(image, 0, 0, imageWidth, imageHeight, (int)((double)(width / 2) - (double)imageWidth * heightScale / 2.0) + x, y, (int)((double)imageWidth * heightScale), (int)((double)imageHeight * heightScale));
        }
    }
}

