/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.debugtools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.debugtools.DebugTool;
import org.tizen.common.connection.debugtools.OnDemandInstallMessages;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.FsCommand;
import org.tizen.common.sdb.command.OnDemandCommand;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.RootJob;
import org.tizen.common.util.SdbCommandUtil;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class OnDemandInstall {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ID_DEBUGTOOLS_EXTENSION = "org.tizen.common.connection.tools";
    public static final String RPM_PACKAGE_TYPE = "rpm";
    private static final String CMD_RESULT_SUCCESS = "0";
    private IDevice device = null;
    private String toolsPathOnTarget;
    private boolean isMultiUser;
    private static IProgressMonitor nullMonitor = new OnDemandNullProgressMonitor();
    private List<DebugTool> debugTools = null;
    boolean blocking = false;
    private String pkgVersion;

    public OnDemandInstall(IDevice device) {
        this.device = device;
        this.pkgVersion = "";
        this.toolsPathOnTarget = TizenPlatformConstants.getToolsTargetDirectory((IDevice)device);
        this.debugTools = this.getDebugTools(device, this.pkgVersion);
        this.isMultiUser = SdbCommandUtil.isMultiUserDevice((IDevice)device);
    }

    public OnDemandInstall(IDevice device, String packageName) {
        this.device = device;
        this.pkgVersion = "";
        this.debugTools = this.getDebugTools(device, packageName, this.pkgVersion);
        this.toolsPathOnTarget = TizenPlatformConstants.getToolsTargetDirectory((IDevice)device);
        this.isMultiUser = SdbCommandUtil.isMultiUserDevice((IDevice)device);
    }

    public OnDemandInstall(IDevice device, String packageName, String version) {
        this.device = device;
        this.pkgVersion = version;
        this.debugTools = this.getDebugTools(device, packageName, this.pkgVersion);
        this.toolsPathOnTarget = TizenPlatformConstants.getToolsTargetDirectory((IDevice)device);
        this.isMultiUser = SdbCommandUtil.isMultiUserDevice((IDevice)device);
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    private boolean checkDirectory(String dir) {
        if (this.isMultiUser) {
            return this.checkDirOnMultiUserTarget();
        }
        return this.checkDirOnSingleUserTarget();
    }

    private boolean checkDirOnMultiUserTarget() {
        try {
            FsCommand command = new FsCommand(this.device, null);
            return command.isExists(this.toolsPathOnTarget);
        }
        catch (Exception e) {
            this.logger.error(OnDemandInstallMessages.CANNOT_CHECK_DIRECTORY, (Throwable)e);
            return false;
        }
    }

    private boolean checkDirOnSingleUserTarget() {
        String result;
        String cmd;
        String toolsTargetPath;
        FsCommand command;
        block4: {
            command = new FsCommand(this.device, null);
            toolsTargetPath = TizenPlatformConstants.getToolsTargetDirectory((IDevice)this.device);
            cmd = String.valueOf(String.format("[ -L '%s' ]", toolsTargetPath)) + "; echo $?;";
            result = this.getResult(cmd);
            if (!CMD_RESULT_SUCCESS.equals(result)) break block4;
            return true;
        }
        try {
            if (command.isExists(toolsTargetPath)) {
                cmd = String.valueOf(String.format(TizenPlatformConstants.REMOVE_FILE_COMMAND, toolsTargetPath)) + "; echo $?;";
                result = this.getResult(cmd);
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error(OnDemandInstallMessages.CANNOT_CHECK_DIRECTORY, (Throwable)e);
        }
        return false;
    }

    private boolean makeDirectory(String dir) {
        if (this.isMultiUser) {
            return this.makeDirOnMultiUserTarget();
        }
        return this.makeDirOnSingleUserTarget();
    }

    private boolean makeDirOnSingleUserTarget() {
        FsCommand command;
        block3: {
            try {
                command = new FsCommand(this.device, null);
                if (command.mkdir(this.toolsPathOnTarget)) break block3;
                this.logger.error(OnDemandInstallMessages.CANNOT_CREATE_DIRECTORY);
                return false;
            }
            catch (Exception e) {
                this.logger.error(OnDemandInstallMessages.CANNOT_CREATE_DIRECTORY, (Throwable)e);
                return false;
            }
        }
        return command.createSymbolicLink(this.toolsPathOnTarget, TizenPlatformConstants.TOOLS_TARGET_PATH);
    }

    private boolean makeDirOnMultiUserTarget() {
        try {
            FsCommand command = new FsCommand(this.device, null);
            return command.mkdir(this.toolsPathOnTarget);
        }
        catch (Exception e) {
            this.logger.error(OnDemandInstallMessages.CANNOT_CREATE_DIRECTORY, (Throwable)e);
            return false;
        }
    }

    private String getResult(String cmd) throws Exception {
        String string;
        String result = "";
        CommandOuputReceiver receiver = new CommandOuputReceiver();
        try {
            this.device.executeShellCommand(cmd, (IShellOutputReceiver)receiver, 0);
            string = result = receiver.getResult();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{receiver});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{receiver});
        return string;
    }

    private boolean isInstalled(DebugTool dt) {
        if (RPM_PACKAGE_TYPE.equals(dt.getPackagetype())) {
            return false;
        }
        FsCommand command = new FsCommand(this.device, null);
        try {
            return command.isExists(String.valueOf(this.toolsPathOnTarget) + "/" + dt.getPackagename());
        }
        catch (Exception e) {
            this.logger.error(NLS.bind((String)OnDemandInstallMessages.CANNOT_CHECK_INSTALLED, (Object)dt.getPackagename()), (Throwable)e);
            return false;
        }
    }

    public void install(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = nullMonitor;
        }
        if (this.blocking) {
            this.installPackage(monitor);
        } else {
            String threadName = "OnDemandInstallThread";
            OnDemandRunnable r = new OnDemandRunnable(monitor);
            Thread t = new Thread((Runnable)r, threadName);
            t.start();
        }
    }

    public void setDevice(IDevice pDevice) {
        this.device = pDevice;
    }

    private void copyPackage(String source, String destination) throws IOException {
        SyncService syncService = null;
        try {
            syncService = this.device.getSyncService();
            SyncResult result = syncService.push(source, this.device.getFileEntry(destination).getParent());
            if (!result.isOk()) {
                throw new IOException(result.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{syncService});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{syncService});
    }

    private void installPackage(IProgressMonitor monitor) throws CoreException {
        String message;
        String toolsTargetPath;
        if (CollectionUtil.isEmpty(this.debugTools)) {
            return;
        }
        monitor.beginTask(OnDemandInstallMessages.DIALOG_INITILIZE, 100);
        monitor.subTask(OnDemandInstallMessages.PREPARE_INSTALL);
        if (this.device.isSupportShell() && !this.checkDirectory(toolsTargetPath = TizenPlatformConstants.getToolsTargetDirectory((IDevice)this.device)) && !this.makeDirectory(toolsTargetPath)) {
            message = NLS.bind((String)OnDemandInstallMessages.CANNOT_ON_DEMAND_INSTALL, (Object)(String.valueOf(OnDemandInstallMessages.MAKE_DIRECTORY_FAILED) + toolsTargetPath));
            this.newCoreException(message, null);
        }
        monitor.worked(10);
        ArrayList<String> failedFileList = new ArrayList<String>();
        for (DebugTool dt : this.debugTools) {
            this.verbose("Verifying: " + dt);
            if (!this.verifyArchitecture(dt.getArchitecture())) continue;
            if (this.isInstalled(dt)) {
                this.verbose("Verifying failed (already installed): " + dt);
                continue;
            }
            if (this.deployPackage(dt)) continue;
            failedFileList.add(dt.getBinaryname());
        }
        if (!failedFileList.isEmpty()) {
            message = NLS.bind((String)OnDemandInstallMessages.CANNOT_ON_DEMAND_INSTALL, (Object)((Object)failedFileList).toString());
            this.newCoreException(message, null);
        }
        monitor.done();
    }

    private final boolean deployPackage(DebugTool tool) {
        String local = String.valueOf(tool.getSourcepath()) + "/" + tool.getBinaryname();
        String remote = String.valueOf(this.toolsPathOnTarget) + "/" + tool.getBinaryname();
        if (!ApplicationCommand.isAppCmdSupported((IDevice)this.device)) {
            this.verbose("Deploying: " + tool);
            try {
                this.copyPackage(local, remote);
            }
            catch (IOException e) {
                this.logger.error(NLS.bind((String)OnDemandInstallMessages.CANNOT_COPY_FILE, (Object)tool.getBinaryname()), (Throwable)e);
                return false;
            }
        }
        class InstallJob
        implements RootJob {
            private boolean isSuccess = false;
            private final /* synthetic */ DebugTool val$tool;
            private final /* synthetic */ String val$remote;
            private final /* synthetic */ String val$local;

            InstallJob(DebugTool debugTool, String string, String string2) {
                this.val$tool = debugTool;
                this.val$remote = string;
                this.val$local = string2;
            }

            public void run() {
                OnDemandCommand command = null;
                String localPath = null;
                String remotePath = null;
                try {
                    if (OnDemandInstall.RPM_PACKAGE_TYPE.equals(this.val$tool.getPackagetype())) {
                        remotePath = OnDemandInstall.this.toolsPathOnTarget;
                        localPath = this.val$tool.getBinaryname();
                    } else {
                        remotePath = this.val$remote;
                        localPath = this.val$local;
                    }
                    command = new OnDemandCommand(OnDemandInstall.this.device, null, remotePath, localPath, this.val$tool.getPackagetype());
                    command.execute();
                }
                catch (Exception e) {
                    OnDemandInstall.this.logger.error("Ondemand install failed: " + this.val$tool.getPackagetype() + " " + localPath + " " + remotePath, (Throwable)e);
                    this.isSuccess = false;
                    return;
                }
                this.isSuccess = true;
                OnDemandInstall.this.verbose("Deployed: " + this.val$tool);
            }

            public boolean isSuccess() {
                return this.isSuccess;
            }
        }
        InstallJob installJob = new InstallJob(tool, remote, local);
        if (RPM_PACKAGE_TYPE.equals(tool.getPackagetype())) {
            SdbCommandUtil.runCommandOnRoot((IDevice)this.device, (RootJob)installJob);
        } else {
            installJob.run();
        }
        return installJob.isSuccess();
    }

    private void verbose(String message) {
        this.logger.trace("[OnDemandInstall][" + Thread.currentThread().getId() + "] " + message);
    }

    public static IProgressMonitor getNullIProgressMonitor() {
        return nullMonitor;
    }

    private boolean verifyArchitecture(String arch) {
        if (arch == null) {
            return false;
        }
        if (this.device.getArch() == Arch.X86_64) {
            if (arch.equals("x86_64")) {
                return true;
            }
        } else if (this.device.getArch() == Arch.AARCH) {
            if (arch.equals("aarch64")) {
                return true;
            }
        } else if (this.device.getArch() == Arch.X86) {
            if (arch.equals("x86_64")) {
                return false;
            }
            if (arch.contains("86")) {
                return true;
            }
        } else if (this.device.getArch() == Arch.ARMV8) {
            if (arch.contains("armv8")) {
                return true;
            }
            if (arch.contains("aarch64")) {
                return true;
            }
        } else if (this.device.getArch() == Arch.ARM ? arch.contains("arm") : this.device.getArch() == Arch.RISCV_64 && arch.equals("riscv64")) {
            return true;
        }
        return false;
    }

    private synchronized List<DebugTool> getDebugTools(IDevice device, String packageName, String pkgVersion) {
        List<DebugTool> debugTools = this.getDebugTools(device, pkgVersion);
        ArrayList<DebugTool> toolInfo = new ArrayList<DebugTool>(1);
        if (packageName != null) {
            for (DebugTool dt : debugTools) {
                if (!packageName.equals(dt.getPackagename())) continue;
                toolInfo.add(dt);
            }
        }
        return toolInfo;
    }

    private synchronized List<DebugTool> getDebugTools(IDevice device, String pkgVersion) {
        ArrayList<DebugTool> toolLists = new ArrayList<DebugTool>();
        IExtensionRegistry x = RegistryFactory.getRegistry();
        IConfigurationElement[] ces = x.getConfigurationElementsFor(ID_DEBUGTOOLS_EXTENSION);
        try {
            IConfigurationElement[] iConfigurationElementArray = ces;
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                String sourcepath;
                String packagename;
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (ce.getName().equals("tools") && (packagename = ce.getAttribute("packagename")) != null && (sourcepath = ce.getAttribute("sourcepath")) != null) {
                    this.verbose("a extension ('" + packagename + "') is loaded.");
                    String description = ce.getAttribute("description");
                    DebugTool dt = null;
                    dt = this.makeDebugTool(InstallPathConfig.getToolsPath(), sourcepath, packagename, pkgVersion, description);
                    if (dt != null) {
                        toolLists.add(dt);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            this.logger.error("Failed making DebugTool list for on-demand install", e);
        }
        return toolLists;
    }

    private DebugTool makeDebugTool(String parentDir, String sourcepath, String packagename, String pkgVersion, String description) {
        Path sourcePath = new Path(String.valueOf(parentDir) + sourcepath);
        File packageList = new File(sourcePath.toOSString());
        DebugTool dt = null;
        File[] packageFileList = packageList.listFiles();
        if (packageFileList == null) {
            return null;
        }
        File[] fileArray = packageFileList;
        int n = packageFileList.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            dt = RPM_PACKAGE_TYPE.equals(FileUtil.getFileExtension((String)f.getName())) ? this.makeDebugToolFromRPM(f, this.device, packagename, pkgVersion, String.valueOf(parentDir) + sourcepath, description) : this.makeDebugToolFromTar(f, this.device, packagename, pkgVersion, String.valueOf(parentDir) + sourcepath, description);
            if (dt != null) {
                return dt;
            }
            if (dt == null) {
                this.verbose("packagename('" + packagename + "') does not match with the file name('" + f.getName() + "').");
            }
            ++n2;
        }
        return null;
    }

    private DebugTool makeDebugToolFromRPM(File f, IDevice device, String packagename, String pkgVersion, String sourcepath, String description) {
        String version;
        String architecture;
        DebugTool dt;
        block10: {
            block9: {
                block8: {
                    String[] fileSplit;
                    String name;
                    block7: {
                        dt = null;
                        this.verbose("start makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "')");
                        architecture = "";
                        version = "";
                        name = "";
                        fileSplit = f.getName().split("-");
                        if (fileSplit.length >= 3) break block7;
                        this.verbose("end makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                        return null;
                    }
                    try {
                        name = fileSplit[0];
                        int i = 1;
                        while (i < fileSplit.length - 2) {
                            name = String.valueOf(name) + "-" + fileSplit[i];
                            ++i;
                        }
                        version = fileSplit[fileSplit.length - 2];
                        String[] archSplit = fileSplit[fileSplit.length - 1].split("\\.");
                        architecture = archSplit[archSplit.length - 2];
                        if (packagename.equals(name)) break block8;
                        this.verbose("end makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                        return null;
                    }
                    catch (Throwable throwable) {
                        this.verbose("end makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                        throw throwable;
                    }
                }
                if (pkgVersion.isEmpty() || version.equals(pkgVersion)) break block9;
                this.verbose("end makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                return null;
            }
            if (this.verifyArchitecture(architecture)) break block10;
            this.verbose("end makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
            return null;
        }
        dt = new DebugTool(packagename, f.getName(), sourcepath, version, description, architecture, RPM_PACKAGE_TYPE);
        this.verbose("end makeDebugToolFromRPM(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
        return dt;
    }

    private DebugTool makeDebugToolFromTar(File f, IDevice device, String packagename, String pkgVersion, String sourcepath, String description) {
        String architecture;
        String version;
        DebugTool dt;
        block15: {
            String[] splited;
            block14: {
                String ext;
                block13: {
                    block12: {
                        String name;
                        block11: {
                            int idxVer;
                            int idxName;
                            block10: {
                                block9: {
                                    dt = null;
                                    try {
                                        this.verbose("start makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "')");
                                        idxName = f.getName().indexOf(95);
                                        if (idxName >= 0) break block9;
                                        this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                                        return null;
                                    }
                                    catch (Throwable throwable) {
                                        this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                                        throw throwable;
                                    }
                                }
                                name = f.getName().substring(0, idxName);
                                idxVer = f.getName().indexOf(95, idxName + 1);
                                if (idxVer >= 0) break block10;
                                this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                                return null;
                            }
                            version = f.getName().substring(idxName + 1, idxVer);
                            ext = f.getName().substring(idxVer + 1);
                            if (ext != null && !ext.isEmpty()) break block11;
                            this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                            return null;
                        }
                        if (name.equals(packagename)) break block12;
                        this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                        return null;
                    }
                    if (pkgVersion.isEmpty() || version.equals(pkgVersion)) break block13;
                    this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                    return null;
                }
                splited = ext.split("\\.");
                if (splited.length == 2) break block14;
                this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
                return null;
            }
            architecture = splited[0];
            if (this.verifyArchitecture(architecture)) break block15;
            this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
            return null;
        }
        dt = new DebugTool(packagename, f.getName(), sourcepath, version, description, architecture, "tar");
        this.verbose("end makeDebugToolFromTar(f - '" + f.getName() + ", ' packagename - '" + packagename + "') return: " + dt);
        return dt;
    }

    public void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.common.connection", message, exception);
        throw new CoreException((IStatus)status);
    }

    private static final class CommandOuputReceiver
    extends MultiLineReceiver {
        private String result = "";

        private CommandOuputReceiver() {
        }

        public void processNewLines(String[] lines) {
            this.result = lines[lines.length - 1];
        }

        public String getResult() {
            return this.result;
        }
    }

    private static class OnDemandNullProgressMonitor
    implements IProgressMonitor {
        private OnDemandNullProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }

    class OnDemandRunnable
    implements Runnable {
        IProgressMonitor monitor = null;

        OnDemandRunnable(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void run() {
            try {
                OnDemandInstall.this.installPackage(this.monitor);
            }
            catch (CoreException e) {
                OnDemandInstall.this.logger.debug(e.getLocalizedMessage());
            }
        }
    }
}

