/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.model;

public enum LogLevel {
    VERBOSE(2, "Verbose"),
    DEBUG(3, "Debug"),
    INFO(4, "Info"),
    WARN(5, "Warning"),
    ERROR(6, "Error"),
    FATAL(7, "Fatal");

    private final int priority;
    private final String name;
    private char letter;

    private LogLevel(int priority, String name) {
        this.priority = priority;
        this.name = name;
        this.letter = name.charAt(0);
    }

    public static LogLevel getByName(String name) {
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevel mode = logLevelArray[n2];
            if (mode.name.equalsIgnoreCase(name)) {
                return mode;
            }
            ++n2;
        }
        return null;
    }

    public static LogLevel getByLetter(String val) {
        if (val.length() > 0) {
            char ch = val.charAt(0);
            LogLevel[] logLevelArray = LogLevel.values();
            int n = logLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogLevel mode = logLevelArray[n2];
                if (mode.letter == ch) {
                    return mode;
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    public char getLetter() {
        return this.letter;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }
}

