/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.util;

import java.util.List;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IReferenceEnabled;
import org.tizen.common.rest.model.schema.IWadlModel;

public class ModelUtil {
    public static boolean isDecendentFrom(List<IWadlModel> list, IWadlModel model) {
        if (list.contains(model)) {
            return true;
        }
        IWadlModel parent = model.getParent();
        if (parent != null) {
            return ModelUtil.isDecendentFrom(list, parent);
        }
        return false;
    }

    public static <T extends IReferenceEnabled> T findReferences(T model) {
        Object obj;
        String href = model.getHref();
        if (href != null && href.length() > 0 && (obj = model.getFullPath().getFirstSegment()) instanceof Application) {
            Application root = (Application)obj;
            List<IWadlModel> children = root.getChildren();
            int i = 0;
            while (i < children.size()) {
                IReferenceEnabled t;
                String id;
                IWadlModel child = children.get(i);
                if (child.getClass().isAssignableFrom(model.getClass()) && href.equals("#" + (id = (t = (IReferenceEnabled)child).getId()))) {
                    return (T)t;
                }
                ++i;
            }
        }
        return model;
    }
}

