/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.textAssist;

import java.util.List;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.textAssist.TextAssistContentProvider;

public class TextAssist
extends Composite {
    private final Text text;
    private final Shell popup;
    private final Table table;
    private TextAssistContentProvider contentProvider;
    private int numberOfLines;

    public TextAssist(Composite parent, int style, TextAssistContentProvider contentProvider) {
        super(parent, style);
        this.contentProvider = contentProvider;
        this.contentProvider.setTextAssist(this);
        this.setLayout((Layout)new FillLayout());
        this.numberOfLines = 10;
        this.text = new Text((Composite)this, style);
        this.popup = new Shell(this.getDisplay(), 16384);
        this.popup.setLayout((Layout)new FillLayout());
        this.table = new Table((Composite)this.popup, 4);
        this.text.addListener(1, this.createKeyDownListener());
        this.text.addListener(24, this.createModifyListener());
        this.text.addListener(16, this.createFocusOutListener());
        this.table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                TextAssist.this.text.setText(TextAssist.this.table.getSelection()[0].getText());
                TextAssist.this.popup.setVisible(false);
            }
        });
        this.table.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    TextAssist.this.popup.setVisible(false);
                }
            }
        });
        this.table.addListener(16, this.createFocusOutListener());
        this.getShell().addListener(10, new Listener(){

            public void handleEvent(Event event) {
                TextAssist.this.popup.setVisible(false);
            }
        });
    }

    private Listener createKeyDownListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x1000002: {
                        int index = (TextAssist.this.table.getSelectionIndex() + 1) % TextAssist.this.table.getItemCount();
                        TextAssist.this.table.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        int index = TextAssist.this.table.getSelectionIndex() - 1;
                        if (index < 0) {
                            index = TextAssist.this.table.getItemCount() - 1;
                        }
                        TextAssist.this.table.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 13: {
                        if (!TextAssist.this.popup.isVisible() || TextAssist.this.table.getSelectionIndex() == -1) break;
                        TextAssist.this.text.setText(TextAssist.this.table.getSelection()[0].getText());
                        TextAssist.this.popup.setVisible(false);
                        break;
                    }
                    case 27: {
                        TextAssist.this.popup.setVisible(false);
                        break;
                    }
                }
            }
        };
    }

    private Listener createModifyListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                String string = TextAssist.this.text.getText();
                if (string.length() == 0) {
                    TextAssist.this.popup.setVisible(false);
                    return;
                }
                List<String> values = TextAssist.this.contentProvider.getContent(string);
                if (values == null || values.isEmpty()) {
                    TextAssist.this.popup.setVisible(false);
                    return;
                }
                if (values.size() > TextAssist.this.numberOfLines) {
                    values = values.subList(0, TextAssist.this.numberOfLines);
                }
                TextAssist.this.table.removeAll();
                int numberOfRows = Math.min(values.size(), TextAssist.this.numberOfLines);
                int i = 0;
                while (i < numberOfRows) {
                    TableItem tableItem = new TableItem(TextAssist.this.table, 0);
                    tableItem.setText(values.get(i));
                    ++i;
                }
                Point point = TextAssist.this.text.toDisplay(((TextAssist)TextAssist.this).text.getLocation().x, ((TextAssist)TextAssist.this).text.getSize().y + TextAssist.this.text.getBorderWidth() - 3);
                int x = point.x;
                int y = point.y;
                Rectangle displayRect = TextAssist.this.getMonitor().getClientArea();
                Rectangle parentRect = TextAssist.this.getDisplay().map((Control)TextAssist.this.getParent(), null, TextAssist.this.getBounds());
                TextAssist.this.popup.pack();
                int width = ((TextAssist)TextAssist.this).popup.getBounds().width;
                int height = ((TextAssist)TextAssist.this).popup.getBounds().height;
                if (y + height > displayRect.y + displayRect.height) {
                    y = parentRect.y - height;
                }
                if (x + width > displayRect.x + displayRect.width) {
                    x = displayRect.x + displayRect.width - width;
                }
                TextAssist.this.popup.setLocation(x, y);
                TextAssist.this.popup.setVisible(true);
            }
        };
    }

    private Listener createFocusOutListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TextAssist.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TextAssist.this.getDisplay().isDisposed()) {
                            return;
                        }
                        Control control = TextAssist.this.getDisplay().getFocusControl();
                        if (control == null || control != TextAssist.this.text && control != TextAssist.this.table) {
                            TextAssist.this.popup.setVisible(false);
                        }
                    }
                });
            }
        };
    }

    public TextAssistContentProvider getContentProvider() {
        this.checkWidget();
        return this.contentProvider;
    }

    public void setContentProvider(TextAssistContentProvider contentProvider) {
        this.checkWidget();
        this.contentProvider = contentProvider;
    }

    public int getNumberOfLines() {
        this.checkWidget();
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.checkWidget();
        this.numberOfLines = numberOfLines;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.text.addModifyListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.text.addSelectionListener(listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        this.text.addVerifyListener(listener);
    }

    public void append(String string) {
        this.checkWidget();
        this.text.append(string);
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.text.computeSize(wHint, hHint, changed);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        return super.computeTrim(x, y, width, height);
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return this.text.getCaretLineNumber();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return this.text.getCaretLocation();
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.text.getCaretPosition();
    }

    public int getCharCount() {
        this.checkWidget();
        return this.text.getCharCount();
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.text.getDoubleClickEnabled();
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.text.getEchoChar();
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public int getLineCount() {
        this.checkWidget();
        return this.text.getLineCount();
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.text.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public String getMessage() {
        this.checkWidget();
        return this.text.getMessage();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.text.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.text.getSelectionCount();
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.text.getSelectionText();
    }

    public int getTabs() {
        this.checkWidget();
        return this.text.getTabs();
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public String getText(int start, int end) {
        this.checkWidget();
        return this.text.getText(start, end);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.text.getTopIndex();
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.text.getTopPixel();
    }

    public void insert(String string) {
        this.checkWidget();
        this.text.insert(string);
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.text.removeModifyListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.text.removeSelectionListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        this.text.removeVerifyListener(listener);
    }

    public void selectAll() {
        this.checkWidget();
        this.text.selectAll();
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.text.setDoubleClickEnabled(doubleClick);
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        this.text.setEchoChar(echo);
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.text.setFont(font);
        this.table.setFont(font);
    }

    public void setMessage(String string) {
        this.checkWidget();
        this.text.setMessage(string);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        this.text.setOrientation(orientation);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        this.text.setRedraw(redraw);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.text.setSelection(start, end);
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.text.setSelection(start);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        this.text.setSelection(selection);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        this.text.setTabs(tabs);
    }

    public void setText(String text) {
        this.checkWidget();
        this.text.setText(text);
    }

    public void setTextLimit(int textLimit) {
        this.checkWidget();
        this.text.setTextLimit(textLimit);
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        this.text.setTopIndex(topIndex);
    }

    public void showSelection() {
        this.checkWidget();
        this.text.showSelection();
    }
}

