/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.DialogAction;
import zipeditor.model.Node;
import zipeditor.operations.ExtractOperation;

public class ExtractAction
extends DialogAction {
    private String fSelectedFolder;

    public ExtractAction(StructuredViewer viewer) {
        super(ActionMessages.getString("ExtractAction.0"), viewer, false);
        this.setToolTipText(ActionMessages.getString("ExtractAction.1"));
        this.setImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/elcl18/extract.png"));
        this.setDisabledImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/dlcl18/extract.png"));
    }

    public void run() {
        String[] folder;
        Node[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            nodes = new Node[]{this.getViewerInputAsNode()};
        }
        if ((folder = this.openDialog(ActionMessages.getString("ExtractAction.2"), this.fSelectedFolder, false, false)) != null && folder.length > 0) {
            ExtractOperation operation = new ExtractOperation();
            operation.setRefreshJob(new RefreshJob());
            this.fSelectedFolder = operation.execute(nodes, new File(folder[0]), true, false).getAbsolutePath();
        }
    }

    protected void finished() {
        if (this.fSelectedFolder == null) {
            return;
        }
        try {
            IContainer[] resources = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(this.fSelectedFolder));
            if (resources != null && resources.length > 0) {
                resources[0].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            ZipEditorPlugin.log((Object)e);
        }
    }

    private class RefreshJob
    extends Job {
        public RefreshJob() {
            super(ActionMessages.getString("ExtractAction.3"));
        }

        protected IStatus run(IProgressMonitor monitor) {
            ExtractAction.this.finished();
            return Status.OK_STATUS;
        }
    }
}

