/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParamBean;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.run.Cookie;
import org.tizen.common.rest.model.run.FileArgument;
import org.tizen.common.rest.model.run.RequestModel;
import org.tizen.common.rest.model.run.ResponseModel;
import org.tizen.common.rest.model.run.RuntimeSetting;
import org.tizen.common.rest.model.run.RuntimeSettingLocal;
import org.tizen.common.rest.model.run.TestData;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.run.AbstractParamAuthProcessor;
import org.tizen.common.rest.run.RestHttpDelete;
import org.tizen.common.rest.util.OutputUtil;

public class RestApiRunner {
    private final IProgressMonitor monitor;
    private MessageConsoleStream out;
    private HttpClient client;
    private final Method api;
    private AbstractParamAuthProcessor authProcessor;

    public RestApiRunner(IProgressMonitor monitor, MessageConsoleStream out, HttpClient client, Method api) {
        this.monitor = monitor;
        this.out = out;
        this.client = client;
        this.api = api;
    }

    public TestData run() {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.monitor, 1);
        subMonitor.beginTask("Run each API", 2);
        RequestModel reqModel = new RequestModel(this.api);
        if (this.authProcessor != null) {
            reqModel.applyAuthProcessor(this.authProcessor);
        }
        ResponseModel resModel = new ResponseModel();
        TestData data = new TestData(reqModel, resModel);
        HttpResponse response = null;
        HttpRequestBase method = null;
        try {
            method = this.generateHttpMethod(reqModel);
        }
        catch (URISyntaxException e) {
            resModel.setExceptionMessage(e.getMessage());
        }
        subMonitor.worked(1);
        long start = System.currentTimeMillis();
        data.setStartTime(start);
        if (method != null) {
            try {
                long latency = 0L;
                if (method != null) {
                    response = this.client.execute((HttpUriRequest)method);
                }
                long end = System.currentTimeMillis();
                latency = end - start;
                data.setLatency(latency);
                this.fillResponseModel(reqModel, resModel, response);
                subMonitor.worked(1);
            }
            catch (Exception e) {
                resModel.setExceptionMessage(e.getMessage());
            }
        }
        OutputUtil.println(this.out, data.toPrintableString());
        subMonitor.done();
        return data;
    }

    private HttpRequestBase generateHttpMethod(RequestModel reqModel) throws URISyntaxException {
        boolean useKeepalive;
        String methodStr = reqModel.getMethod();
        Object method = null;
        if ("GET".equalsIgnoreCase(methodStr)) {
            method = new HttpGet();
        } else if ("POST".equalsIgnoreCase(methodStr)) {
            method = new HttpPost();
        } else if ("PUT".equalsIgnoreCase(methodStr)) {
            method = new HttpPut();
        } else if ("DELETE".equalsIgnoreCase(methodStr)) {
            method = new RestHttpDelete();
        }
        String uriStr = reqModel.getRequestUrl();
        if (method == null) {
            OutputUtil.println(this.out, "Error - Method is null");
            return method;
        }
        URI uri = new URI(uriStr);
        method.setURI(uri);
        String encoding = reqModel.getEncoding();
        if (encoding != null && encoding.length() > 0) {
            BasicHttpParams encodingParams = new BasicHttpParams();
            HttpProtocolParamBean paramBean = new HttpProtocolParamBean((HttpParams)encodingParams);
            paramBean.setContentCharset(encoding);
        }
        if (useKeepalive = reqModel.isUseKeepAlive()) {
            method.addHeader("Connection", "Keep-Alive");
        }
        this.fillCookies((HttpRequestBase)method, reqModel);
        this.fillHeaders((HttpRequestBase)method, reqModel);
        List<NameValuePair> paramList = reqModel.getParamList();
        this.fillParameters((HttpRequestBase)method, encoding, paramList);
        reqModel.setRequestUrl(method.getURI().toString());
        if (reqModel.isUseMultipart() && method instanceof HttpEntityEnclosingRequestBase) {
            List<FileArgument> fileArgList = reqModel.getFileArgumentList();
            this.fillFileParameters((HttpEntityEnclosingRequestBase)method, fileArgList);
        }
        return method;
    }

    private void fillCookies(HttpRequestBase method, RequestModel reqModel) {
        List<Cookie> list;
        Map<String, Cookie> cookieMap = reqModel.getCookieMap();
        RuntimeSetting runtimeSetting = RuntimeSettingLocal.get();
        if (runtimeSetting != null && (list = runtimeSetting.getCookies()) != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                Cookie cookie = list.get(i);
                if (cookieMap == null) {
                    cookieMap = new LinkedHashMap<String, Cookie>();
                    reqModel.setCookieMap(cookieMap);
                }
                cookieMap.put(cookie.getCookieData(), cookie);
                ++i;
            }
        }
        if (cookieMap != null && cookieMap.size() > 0) {
            for (Cookie cookie : cookieMap.values()) {
                method.addHeader("Cookie", cookie.getCookieData());
            }
        }
    }

    private void fillHeaders(HttpRequestBase method, RequestModel reqModel) {
        Map<String, String> headerMap = reqModel.getHeaderMap();
        if (headerMap != null && headerMap.size() > 0) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                method.addHeader(key, value);
            }
        }
    }

    private void fillParameters(HttpRequestBase method, String encoding, List<NameValuePair> paramList) {
        if (paramList != null && paramList.size() > 0) {
            if (method instanceof HttpEntityEnclosingRequestBase) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                int i = 0;
                while (i < paramList.size()) {
                    NameValuePair p = paramList.get(i);
                    params.add(new BasicNameValuePair(p.getName(), p.getValue()));
                    ++i;
                }
                HttpEntityEnclosingRequestBase entityMethod = (HttpEntityEnclosingRequestBase)method;
                UrlEncodedFormEntity entity = null;
                try {
                    entity = encoding != null && encoding.length() > 0 ? new UrlEncodedFormEntity(params, encoding) : new UrlEncodedFormEntity(params);
                }
                catch (UnsupportedEncodingException e) {
                    RestPlugin.log(e);
                }
                if (entity != null) {
                    entityMethod.setEntity((HttpEntity)entity);
                }
            } else if (method instanceof HttpGet) {
                String uriStr = method.getURI().toString();
                String query = "";
                Iterator<NameValuePair> itor = paramList.iterator();
                while (itor.hasNext()) {
                    NameValuePair pair = itor.next();
                    String key = pair.getName();
                    String value = pair.getValue();
                    if (value == null) {
                        value = "";
                    }
                    try {
                        value = URLEncoder.encode(value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    query = String.valueOf(query) + key + "=" + value;
                    if (!itor.hasNext()) continue;
                    query = String.valueOf(query) + "&";
                }
                if (query.length() > 0) {
                    uriStr = String.valueOf(uriStr) + "?" + query;
                }
                URI uri = URI.create(uriStr);
                method.setURI(uri);
            } else {
                BasicHttpParams httpParams = new BasicHttpParams();
                for (NameValuePair pair : paramList) {
                    httpParams.setParameter(pair.getName(), (Object)pair.getValue());
                }
                method.setParams((HttpParams)httpParams);
            }
        }
    }

    private void fillFileParameters(HttpEntityEnclosingRequestBase method, List<FileArgument> fileArgList) {
        if (fileArgList != null && fileArgList.size() > 0) {
            int i = 0;
            while (i < fileArgList.size()) {
                FileArgument arg = fileArgList.get(i);
                String filePath = arg.getPath();
                String paramName = arg.getParam();
                String mimeType = arg.getMime();
                if (filePath != null && filePath.length() > 0) {
                    File file = new File(filePath);
                    if (file != null && file.exists()) {
                        FileBody bin = null;
                        if (paramName != null && paramName.length() > 0) {
                            bin = mimeType != null && mimeType.length() > 0 ? new FileBody(file, mimeType) : new FileBody(file);
                            MultipartEntity entity = new MultipartEntity();
                            entity.addPart(paramName, (ContentBody)bin);
                            method.setEntity((HttpEntity)entity);
                        } else {
                            RestPlugin.log((IStatus)new Status(4, RestPlugin.getPluginId(), String.valueOf(paramName) + " does not exist on file upload"));
                        }
                    } else {
                        RestPlugin.log((IStatus)new Status(4, RestPlugin.getPluginId(), "File " + filePath + " does not exist."));
                    }
                }
                ++i;
            }
        }
    }

    private void fillResponseModel(RequestModel reqModel, ResponseModel resModel, HttpResponse response) throws IllegalStateException, IOException {
        String contents;
        Charset charset;
        StatusLine status = response.getStatusLine();
        int resCode = status.getStatusCode();
        String resMsg = status.getReasonPhrase();
        resModel.setResponseCode(resCode);
        resModel.setResponseMessage(resMsg);
        Header[] headers = response.getAllHeaders();
        this.processHeaderAndCookie(headers, resModel);
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        String mimeType = contentType.getMimeType();
        if (mimeType != null && mimeType.length() > 0) {
            resModel.setMimeType(mimeType);
        }
        if ((charset = contentType.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        if ((contents = EntityUtils.toString((HttpEntity)entity, (Charset)charset)) != null && contents.length() > 0) {
            contents = StringEscapeUtils.unescapeJava((String)contents);
        }
        resModel.setContents(contents);
        long contentLength = contents.length();
        resModel.setContentLength(contentLength);
    }

    private void processHeaderAndCookie(Header[] headers, ResponseModel resModel) {
        if (headers != null && headers.length > 0) {
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                String name = header.getName();
                String value = header.getValue();
                headerMap.put(name, value);
                if ("Set-Cookie".equalsIgnoreCase(name) && value != null && value.length() > 0) {
                    Cookie cookie = new Cookie();
                    cookie.setCookieData(value);
                    cookieList.add(cookie);
                    RuntimeSetting runtimeSetting = RuntimeSettingLocal.get();
                    if (runtimeSetting != null) {
                        runtimeSetting.addCookie(cookie);
                    }
                }
                ++n2;
            }
            resModel.setHeaders(headerMap);
            resModel.setCookies(cookieList);
        }
    }

    public void setAuthProcessor(AbstractParamAuthProcessor authProcessor) {
        this.authProcessor = authProcessor;
    }
}

