/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.views.RestViewer;
import org.tizen.common.rest.ui.wizards.AbstractOperation;

public abstract class AbstractFileImportWizardPage
extends WizardDataTransferPage {
    private RestViewer viewer;
    private String initialContainerFieldValue;
    private Text containerNameField;
    private Button containerBrowseButton;

    public AbstractFileImportWizardPage(String name, RestViewer viewer, String title, String description) {
        super(name);
        this.viewer = viewer;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected final void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(this.getSourceLabel());
        resourcesLabel.setFont(parent.getFont());
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(parent.getFont());
        this.containerBrowseButton = new Button(containerGroup, 8);
        this.containerBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browse2);
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.containerBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.containerBrowseButton);
        this.initialPopulateContainerField();
    }

    protected final void initialPopulateContainerField() {
        if (this.initialContainerFieldValue != null) {
            this.containerNameField.setText(this.initialContainerFieldValue);
        }
    }

    public void setContainerFieldValue(String value) {
        if (this.containerNameField == null) {
            this.initialContainerFieldValue = value;
        } else {
            this.containerNameField.setText(value);
        }
    }

    public String getContainerFieldValue() {
        String destinationText = this.containerNameField.getText().trim();
        return destinationText;
    }

    protected void handleBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 0x10001000);
        dialog.setFilterExtensions(this.getFileDialogFilterExtensions());
        dialog.setText(this.selectSourceTitleMessage());
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setErrorMessage(null);
            this.setContainerFieldValue(selectedFileName);
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.containerBrowseButton) {
            this.handleBrowseButtonPressed();
        }
        this.updateWidgetEnablements();
    }

    protected boolean ensureSourceIsValid() {
        String targetPath = this.getContainerFieldValue();
        if (targetPath.length() == 0) {
            this.displayErrorDialog(DataTransferMessages.FileImport_sourceEmpty);
            return false;
        }
        boolean valid = false;
        URL url = null;
        try {
            url = new URL(targetPath);
        }
        catch (MalformedURLException malformedURLException) {}
        if (url != null) {
            try {
                InputStream is = url.openStream();
                if (is != null) {
                    valid = true;
                }
            }
            catch (IOException iOException) {}
        } else {
            File file = new File(targetPath);
            if (file.exists()) {
                valid = true;
            }
        }
        if (!valid) {
            this.displayErrorDialog(RestUIMessages.AbstractFileImportWizardPage_source_not_exist);
        }
        return valid;
    }

    protected void giveFocusToDestination() {
        this.containerNameField.setFocus();
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        return this.executeImportOperation(this.createImportOperation(this.viewer, this.getContainerFieldValue()));
    }

    protected boolean executeImportOperation(AbstractOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected String getSourceLabel() {
        return DataTransferMessages.FileImport_fromDirectory;
    }

    protected abstract AbstractOperation createImportOperation(RestViewer var1, String var2);

    protected abstract String getInputSuffix();

    protected abstract String[] getFileDialogFilterExtensions();

    protected abstract String selectSourceTitleMessage();
}

