/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.net.URISyntaxException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;

public class BranchConfig {
    private final Config config;
    private final String branchName;

    public BranchConfig(Config config, String branchName) {
        this.config = config;
        this.branchName = branchName;
    }

    public String getTrackingBranch() {
        String remote = this.getRemote();
        String mergeRef = this.getMergeBranch();
        if (remote == null || mergeRef == null) {
            return null;
        }
        if (remote.equals(".")) {
            return mergeRef;
        }
        return this.findRemoteTrackingBranch(remote, mergeRef);
    }

    public String getRemoteTrackingBranch() {
        String remote = this.getRemote();
        String mergeRef = this.getMergeBranch();
        if (remote == null || mergeRef == null) {
            return null;
        }
        return this.findRemoteTrackingBranch(remote, mergeRef);
    }

    private String findRemoteTrackingBranch(String remote, String mergeRef) {
        RemoteConfig remoteConfig;
        try {
            remoteConfig = new RemoteConfig(this.config, remote);
        }
        catch (URISyntaxException e) {
            return null;
        }
        for (RefSpec refSpec : remoteConfig.getFetchRefSpecs()) {
            if (!refSpec.matchSource(mergeRef)) continue;
            RefSpec expanded = refSpec.expandFromSource(mergeRef);
            return expanded.getDestination();
        }
        return null;
    }

    private String getRemote() {
        String remoteName = this.config.getString("branch", this.branchName, "remote");
        if (remoteName == null) {
            return "origin";
        }
        return remoteName;
    }

    private String getMergeBranch() {
        String mergeRef = this.config.getString("branch", this.branchName, "merge");
        return mergeRef;
    }
}

