/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;

public class DeviceCliManager {
    private final String EMULATOR_BIN_PATH = InstallPathConfig.getEmulatorBinPath();
    private final String WIN_COMMAND_EM_CLI = String.valueOf(this.EMULATOR_BIN_PATH) + File.separator + "em-cli.bat" + " ";
    private final String UNIX_COMMAND_EM_CLI = String.valueOf(this.EMULATOR_BIN_PATH) + File.separator + "em-cli" + " ";
    private final String WIN_COMMAND_EMULMANAGER = String.valueOf(this.EMULATOR_BIN_PATH) + File.separator + "emulator-manager.exe";
    private final String UNIX_COMMAND_EMULMANAGER = String.valueOf(this.EMULATOR_BIN_PATH) + File.separator + "emulator-manager";
    private ArrayList<String> resultList = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected int executeLaunchEmulCliCommand(String command) throws InterruptedException {
        Process p = null;
        int status = -1;
        try {
            p = OSChecker.isWindows() ? Runtime.getRuntime().exec(String.valueOf(this.WIN_COMMAND_EM_CLI) + command) : Runtime.getRuntime().exec(String.valueOf(this.UNIX_COMMAND_EM_CLI) + command);
        }
        catch (IOException e) {
            this.logger.error("Error occurred!", (Throwable)e);
        }
        if (p != null) {
            status = p.waitFor();
        }
        return status;
    }

    protected int executeEmulManagerCommand() throws InterruptedException {
        int status = -1;
        if (OSChecker.isWindows()) {
            HostUtil.batchExecute((String)this.WIN_COMMAND_EMULMANAGER, null, (File)new File(InstallPathConfig.getEmulatorBinPath()));
        } else {
            HostUtil.execute((String)(String.valueOf(this.UNIX_COMMAND_EMULMANAGER) + " 1>/dev/null 2>/dev/null &"));
        }
        return status;
    }

    protected ArrayList<String> executeListVmCliCommand(String command) {
        try {
            Process p = OSChecker.isWindows() ? Runtime.getRuntime().exec(String.valueOf(this.WIN_COMMAND_EM_CLI) + command) : Runtime.getRuntime().exec(String.valueOf(this.UNIX_COMMAND_EM_CLI) + command);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                this.resultList.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resultList;
    }
}

